/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils;

import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StreamUtils {
    public static <T> Stream<T> fromArray(T[] array) {
        return Stream.of(array);
    }

    public static <T> Stream<T> fromList(List<T> list) {
        return list.stream();
    }

    public static <T> Stream<T> fromListParallel(List<T> list) {
        return list.parallelStream();
    }

    public static <T> Stream<T> fromSupplier(Supplier<T> supplier) {
        return Stream.generate(supplier);
    }

    public static <T> Stream<T> distinct(Stream<T> stream) {
        return stream.distinct();
    }

    public static long countStrings(Stream<String> stream, boolean distinct, boolean ignoreCase) {
        if (ignoreCase && distinct) {
            return stream.map(String::toLowerCase).distinct().count();
        }
        if (ignoreCase) {
            return stream.map(String::toLowerCase).count();
        }
        if (distinct) {
            return stream.distinct().count();
        }
        return stream.count();
    }

    public static String getString(Stream<Object> stream, String separator, String prefix, String suffix) {
        if (prefix != null || suffix != null) {
            if (prefix == null) {
                prefix = "";
            }
            if (suffix == null) {
                suffix = "";
            }
            return stream.map(Object::toString).collect(Collectors.joining(separator, prefix, suffix));
        }
        return stream.map(Object::toString).collect(Collectors.joining(separator));
    }

    public static <T> List<T> toList(Stream<T> stream) {
        return stream.collect(Collectors.toList());
    }

    public static <T> Set<T> toSet(Stream<T> stream) {
        return stream.collect(Collectors.toSet());
    }

    public static <T> TreeSet<T> toTreeSet(Stream<T> stream) {
        return stream.collect(Collectors.toCollection(TreeSet::new));
    }

    public static <T, K, V> Map<K, V> toMap(Stream<T> stream, Function<T, K> keySupplier, Function<T, V> valueSupplier) {
        return stream.collect(Collectors.toMap(keySupplier, valueSupplier));
    }

    public static <T, K> Map<K, T> toMapWithToStringValue(Stream<T> stream, Function<T, K> keySupplier) {
        return stream.collect(Collectors.toMap(keySupplier, Function.identity()));
    }

    public static <T, K, R> Map<R, List<T>> toMapGroupBy(Stream<T> stream, Function<T, R> groupingFunction) {
        return stream.collect(Collectors.groupingBy(groupingFunction));
    }

    public static <T> Map<Boolean, List<T>> toMapPartition(Stream<T> stream, Predicate<T> predicate) {
        return stream.collect(Collectors.partitioningBy(predicate));
    }

    public static <T, R> void printLongStats(Stream<T> stream, ToLongFunction<T> summarizingFunction) {
        LongSummaryStatistics summary = stream.collect(Collectors.summarizingLong(summarizingFunction));
        System.out.println(summary.getCount());
        System.out.println(summary.getSum());
        System.out.println(summary.getMin());
        System.out.println(summary.getMax());
        System.out.println(summary.getAverage());
    }

    public static <T> T findAny(Stream<T> stream, Predicate<T> predicate) {
        Optional<Object> element = stream.filter(predicate).findAny();
        return element.orElse(null);
    }

    public static <T> Stream<T> findAll(Stream<T> stream, Predicate<T> predicate) {
        Stream<T> filteredStream = stream.filter(predicate);
        return filteredStream;
    }
}

