/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.locationtech.jts.geom.util.NoninvertibleTransformationException;

public class TransformationUtils {
    public static AffineTransform getWorldToPixel(Envelope worldEnvelope, Rectangle pixelRectangle) {
        double width = pixelRectangle.getWidth();
        double worldWidth = worldEnvelope.getWidth();
        double height = pixelRectangle.getHeight();
        double worldHeight = worldEnvelope.getHeight();
        AffineTransform translate = AffineTransform.getTranslateInstance(-worldEnvelope.getMinX(), -worldEnvelope.getMinY());
        AffineTransform scale = AffineTransform.getScaleInstance(width / worldWidth, height / worldHeight);
        AffineTransform mirror_y = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, pixelRectangle.getHeight());
        AffineTransform world2pixel = new AffineTransform(mirror_y);
        world2pixel.concatenate(scale);
        world2pixel.concatenate(translate);
        return world2pixel;
    }

    public static AffineTransform getPixelToWorld(Rectangle pixelRectangle, Envelope worldEnvelope) throws NoninvertibleTransformException {
        return TransformationUtils.getWorldToPixel(worldEnvelope, pixelRectangle).createInverse();
    }

    public static AffineTransformation getWorldToRectangle(Envelope worldEnvelope, Rectangle pixelRectangle) {
        int cols = (int)pixelRectangle.getWidth();
        int rows = (int)pixelRectangle.getHeight();
        double worldWidth = worldEnvelope.getWidth();
        double worldHeight = worldEnvelope.getHeight();
        double x = -worldEnvelope.getMinX();
        double y = -worldEnvelope.getMinY();
        AffineTransformation translate = AffineTransformation.translationInstance((double)x, (double)y);
        double xScale = (double)cols / worldWidth;
        double yScale = (double)rows / worldHeight;
        AffineTransformation scale = AffineTransformation.scaleInstance((double)xScale, (double)yScale);
        boolean m00 = true;
        boolean m10 = false;
        boolean m01 = false;
        int m11 = -1;
        boolean m02 = false;
        int m12 = rows;
        AffineTransformation mirror_y = new AffineTransformation((double)m00, (double)m01, (double)m02, (double)m10, (double)m11, (double)m12);
        AffineTransformation world2pixel = new AffineTransformation(translate);
        world2pixel.compose(scale);
        world2pixel.compose(mirror_y);
        return world2pixel;
    }

    public static AffineTransformation getRectangleToWorld(Rectangle pixelRectangle, Envelope worldEnvelope) throws NoninvertibleTransformationException {
        return TransformationUtils.getWorldToRectangle(worldEnvelope, pixelRectangle).getInverse();
    }

    public static Envelope scaleToWidth(Envelope original, double newWidth) {
        double width = original.getWidth();
        double factor = newWidth / width;
        double newHeight = original.getHeight() * factor;
        return new Envelope(original.getMinX(), original.getMinX() + newWidth, original.getMinY(), original.getMinY() + newHeight);
    }

    public static Envelope scaleToHeight(Envelope original, double newHeight) {
        double height = original.getHeight();
        double factor = newHeight / height;
        double newWidth = original.getWidth() * factor;
        return new Envelope(original.getMinX(), original.getMinX() + newWidth, original.getMinY(), original.getMinY() + newHeight);
    }

    public static Envelope expandToFitRatio(Envelope original, double width, double height) {
        double ow;
        double oh = height * original.getWidth() / width;
        if (oh < original.getHeight()) {
            ow = width * original.getHeight() / height;
            oh = original.getHeight();
        } else {
            ow = original.getWidth();
        }
        double expandX = (ow - original.getWidth()) / 2.0;
        double expandY = (oh - original.getHeight()) / 2.0;
        Envelope newEnv = new Envelope(original);
        newEnv.expandBy(expandX, expandY);
        return newEnv;
    }

    public static Envelope transformEnvelope(AffineTransform transformation, Envelope env) {
        Point2D.Double llFromPoint = new Point2D.Double(env.getMinX(), env.getMinY());
        Point2D.Double urFromPoint = new Point2D.Double(env.getMaxX(), env.getMaxY());
        Point2D.Double ll = new Point2D.Double();
        Point2D.Double ur = new Point2D.Double();
        transformation.transform(llFromPoint, ll);
        transformation.transform(urFromPoint, ur);
        return new Envelope(((Point2D)ll).getX(), ((Point2D)ur).getX(), ((Point2D)ll).getY(), ((Point2D)ur).getY());
    }

    public static Coordinate transformCoordinate(AffineTransform transformation, Coordinate coordinate) {
        Point2D.Double fromPoint = new Point2D.Double(coordinate.x, coordinate.y);
        Point2D.Double toPoint = new Point2D.Double();
        transformation.transform(fromPoint, toPoint);
        return new Coordinate(((Point2D)toPoint).getX(), ((Point2D)toPoint).getY());
    }

    public static Envelope transformEnvelope(AffineTransformation transformation, Envelope env) {
        Coordinate llFromPoint = new Coordinate(env.getMinX(), env.getMinY());
        Coordinate urFromPoint = new Coordinate(env.getMaxX(), env.getMaxY());
        Coordinate ll = new Coordinate();
        Coordinate ur = new Coordinate();
        transformation.transform(llFromPoint, ll);
        transformation.transform(urFromPoint, ur);
        return new Envelope(ll.getX(), ur.getX(), ll.getY(), ur.getY());
    }
}

