/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.chart;

import java.util.Arrays;
import java.util.List;
import org.hortonmachine.gears.utils.chart.IChart;
import org.hortonmachine.gears.utils.chart.PlotFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class CategoryHistogram
implements IChart {
    private String[] categories;
    private List<double[]> values;
    private DefaultCategoryDataset dataset;
    private String title;
    private JFreeChart chart;
    private String yLabel = "Value";
    private String xLabel = "Category";
    private List<String> series;

    public CategoryHistogram(String[] categories, double[] values) {
        this("Histogram", null, categories, Arrays.asList(new double[][]{values}));
    }

    public CategoryHistogram(List<String> series, String[] categories, List<double[]> values) {
        this("Histogram", series, categories, values);
    }

    public CategoryHistogram(String title, List<String> series, String[] categories, List<double[]> values) {
        this.title = title;
        this.series = series;
        this.categories = categories;
        this.values = values;
        if (this.series == null) {
            this.series = Arrays.asList("");
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    private void createDataset() {
        this.dataset = new DefaultCategoryDataset();
        for (int j = 0; j < this.series.size(); ++j) {
            double[] seriesValues = this.values.get(j);
            for (int i = 0; i < this.categories.length; ++i) {
                this.dataset.addValue(seriesValues[i], (Comparable)((Object)this.series.get(j)), (Comparable)((Object)this.categories[i]));
            }
        }
    }

    public void setXLabel(String xLabel) {
        this.xLabel = xLabel;
    }

    public void setYLabel(String yLabel) {
        this.yLabel = yLabel;
    }

    @Override
    public JFreeChart getChart() {
        if (this.chart == null) {
            this.createDataset();
            boolean doLegend = this.series.size() > 1;
            this.chart = ChartFactory.createBarChart((String)this.title, (String)this.xLabel, (String)this.yLabel, (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)doLegend, (boolean)true, (boolean)false);
            CategoryPlot plot = (CategoryPlot)this.chart.getPlot();
            CategoryAxis rangeAxis = plot.getDomainAxis();
            rangeAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        }
        return this.chart;
    }

    public static void main(String[] args) {
        String[] asd = new String[]{"a", "b", "c", "d", "e", "f", "g"};
        double[] qwe = new double[]{1.0, 2.0, 3.0, 2.5, 5.5, 1.0, 2.0};
        double[] zxc = new double[]{2.0, 2.0, 0.0, 0.0, 1.0, 1.0, 5.0};
        CategoryHistogram categoryHistogram = new CategoryHistogram("test", Arrays.asList("series A", "series B"), asd, Arrays.asList(qwe, zxc));
        categoryHistogram.setXLabel("letters");
        categoryHistogram.setYLabel("numbers");
        PlotFrame frame = new PlotFrame(categoryHistogram);
        frame.setDimension(1600, 1000);
        frame.plot();
    }
}

