/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.chart;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import org.hortonmachine.gears.utils.chart.IChart;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class PlotFrame
extends ApplicationFrame {
    private static final long serialVersionUID = 1L;
    private IChart ichart;
    private int chartWidth = 500;
    private int chartHeight = 270;

    public PlotFrame(IChart chart) {
        super(chart.getTitle());
        this.ichart = chart;
    }

    public void setDimension(int chartWidth, int chartHeight) {
        this.chartWidth = chartWidth;
        this.chartHeight = chartHeight;
    }

    public void plot() {
        JFreeChart chart = this.ichart.getChart();
        ChartPanel chartPanel = new ChartPanel(chart, true);
        chartPanel.setPreferredSize(new Dimension(this.chartWidth, this.chartHeight));
        this.setContentPane((Container)chartPanel);
        this.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)this));
        this.setVisible(true);
        this.setDefaultCloseOperation(1);
    }
}

