/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.List;
import org.hortonmachine.gears.utils.chart.IChart;
import org.hortonmachine.gears.utils.colors.ColorBrewer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.LogAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.TextAnchor;

public class Scatter
implements IChart {
    protected String xLabel = "X";
    protected String yLabel = "Y";
    protected XYSeriesCollection dataset;
    protected boolean xLog = false;
    protected boolean yLog = false;
    protected List<Boolean> showLines;
    protected List<Boolean> showShapes;
    protected JFreeChart chart;
    protected String title;
    private Color[] colors;

    public Scatter(String title) {
        this.title = title;
        this.dataset = new XYSeriesCollection();
    }

    public Scatter() {
        this("Scatter");
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void addSeries(String seriesName, double[] x, double[] y) {
        XYSeries series = new XYSeries((Comparable)((Object)seriesName));
        for (int i = 0; i < x.length; ++i) {
            series.add(x[i], y[i]);
        }
        this.dataset.addSeries(series);
    }

    public void addSeries(XYSeries series) {
        this.dataset.addSeries(series);
    }

    public XYSeries getSeries(String seriesName) {
        XYSeries series = new XYSeries((Comparable)((Object)seriesName));
        this.dataset.addSeries(series);
        return series;
    }

    public void setLogAxes(boolean xLog, boolean yLog) {
        this.xLog = xLog;
        this.yLog = yLog;
    }

    public void setShowLines(List<Boolean> showLines) {
        this.showLines = showLines;
    }

    public void setShowShapes(List<Boolean> showShapes) {
        this.showShapes = showShapes;
    }

    public void setXLabel(String xLabel) {
        this.xLabel = xLabel;
    }

    public void setYLabel(String yLabel) {
        this.yLabel = yLabel;
    }

    public BufferedImage getImage(int width, int height) {
        JFreeChart chart = this.getChart();
        BufferedImage bufferedImage = chart.createBufferedImage(width, height);
        return bufferedImage;
    }

    @Override
    public JFreeChart getChart() {
        if (this.chart == null) {
            this.chart = ChartFactory.createXYLineChart((String)this.title, (String)this.xLabel, (String)this.yLabel, (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            XYPlot plot = (XYPlot)this.chart.getPlot();
            if (this.xLog) {
                LogAxis xAxis = new LogAxis("");
                xAxis.setBase(10.0);
                plot.setDomainAxis((ValueAxis)xAxis);
            }
            if (this.yLog) {
                LogAxis yAxis = new LogAxis("");
                yAxis.setBase(10.0);
                plot.setRangeAxis((ValueAxis)yAxis);
            }
            if (this.colors == null) {
                this.colors = ColorBrewer.getMainColors(this.dataset.getSeriesCount());
            }
            for (int i = 0; i < this.colors.length; ++i) {
                plot.getRenderer().setSeriesPaint(i, (Paint)this.colors[i]);
            }
            ValueAxis rangeAxis = plot.getRangeAxis();
            if (rangeAxis instanceof NumberAxis) {
                NumberAxis axis = (NumberAxis)rangeAxis;
                axis.setAutoRangeIncludesZero(false);
            }
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
            double x = 1.5;
            double w = x * 2.0;
            renderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(-x, x, w, w));
            this.setShapeLinesVisibility(plot);
        }
        return this.chart;
    }

    private void setShapeLinesVisibility(XYPlot plot) {
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        int seriesCount = plot.getSeriesCount();
        for (int i = 0; i < seriesCount; ++i) {
            if (this.showShapes != null) {
                renderer.setSeriesShapesVisible(i, this.showShapes.get(i));
            }
            if (this.showLines == null) continue;
            renderer.setSeriesLinesVisible(i, this.showLines.get(i));
        }
    }

    public void setXRange(double min, double max) {
        XYPlot plot = (XYPlot)this.getChart().getPlot();
        ValueAxis domainAxis = plot.getDomainAxis();
        domainAxis.setRange(min, max);
    }

    public void setYRange(double min, double max) {
        XYPlot plot = (XYPlot)this.getChart().getPlot();
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setRange(min, max);
    }

    public void addAnnotation(String text, double x) {
        XYPlot plot = (XYPlot)this.getChart().getPlot();
        Color color = new Color(0, 0, 0, 100);
        ValueMarker updateMarker = new ValueMarker(x, (Paint)color, (Stroke)new BasicStroke(2.0f));
        plot.addDomainMarker((Marker)updateMarker);
        if (text != null) {
            XYTextAnnotation updateLabel = new XYTextAnnotation(text, x, 0.0);
            updateLabel.setRotationAnchor(TextAnchor.BASELINE_CENTER);
            updateLabel.setTextAnchor(TextAnchor.BASELINE_CENTER);
            updateLabel.setRotationAngle(-1.57);
            updateLabel.setPaint((Paint)Color.black);
            plot.addAnnotation((XYAnnotation)updateLabel);
        }
        this.setShapeLinesVisibility(plot);
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
    }
}

