/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.chart;

import java.awt.Color;
import java.awt.Paint;
import java.util.Date;
import java.util.List;
import org.hortonmachine.gears.utils.chart.IChart;
import org.hortonmachine.gears.utils.colors.ColorBrewer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class TimeSeries
implements IChart {
    private List<long[]> timesList;
    private List<double[]> valuesList;
    private TimeSeriesCollection dataset = new TimeSeriesCollection();
    private String title;
    private JFreeChart chart;
    private String yLabel = "Value";
    private String xLabel = "Time";
    private List<String> seriesNames;
    private Color[] colors;
    protected List<Boolean> showLines;
    protected List<Boolean> showShapes;

    public TimeSeries(List<String> seriesNames, List<long[]> times, List<double[]> values) {
        this("Time Series", seriesNames, times, values);
    }

    public TimeSeries(String title, List<String> seriesNames, List<long[]> times, List<double[]> values) {
        this.title = title;
        this.timesList = times;
        this.valuesList = values;
        this.seriesNames = seriesNames;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    private void createDataset() {
        int size = this.timesList.size();
        for (int i = 0; i < size; ++i) {
            long[] ts = this.timesList.get(i);
            double[] values = this.valuesList.get(i);
            Object name = "series" + (i + 1);
            if (this.seriesNames != null && this.seriesNames.size() == size) {
                name = this.seriesNames.get(i);
            }
            org.jfree.data.time.TimeSeries series = new org.jfree.data.time.TimeSeries((Comparable)name);
            for (int j = 0; j < ts.length; ++j) {
                series.add((RegularTimePeriod)new Day(new Date(ts[j])), values[j]);
            }
            this.dataset.addSeries(series);
        }
    }

    public void setXLabel(String xLabel) {
        this.xLabel = xLabel;
    }

    public void setYLabel(String yLabel) {
        this.yLabel = yLabel;
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
    }

    public void setShowLines(List<Boolean> showLines) {
        this.showLines = showLines;
    }

    public void setShowShapes(List<Boolean> showShapes) {
        this.showShapes = showShapes;
    }

    @Override
    public JFreeChart getChart() {
        if (this.chart == null) {
            this.createDataset();
            this.chart = ChartFactory.createTimeSeriesChart((String)this.title, (String)this.xLabel, (String)this.yLabel, (XYDataset)this.dataset, (boolean)true, (boolean)true, (boolean)false);
        }
        XYPlot plot = (XYPlot)this.chart.getPlot();
        if (this.colors == null) {
            this.colors = ColorBrewer.getPairedColors(this.seriesNames.size());
        }
        for (int i = 0; i < this.colors.length; ++i) {
            plot.getRenderer().setSeriesPaint(i, (Paint)this.colors[i]);
        }
        this.setShapeLinesVisibility(plot);
        return this.chart;
    }

    private void setShapeLinesVisibility(XYPlot plot) {
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        int seriesCount = plot.getSeriesCount();
        for (int i = 0; i < seriesCount; ++i) {
            if (this.showShapes != null) {
                renderer.setSeriesShapesVisible(i, this.showShapes.get(i));
            }
            if (this.showLines == null) continue;
            renderer.setSeriesLinesVisible(i, this.showLines.get(i));
        }
    }
}

