/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.clustering;

import org.hortonmachine.gears.utils.clustering.GvmCluster;
import org.hortonmachine.gears.utils.clustering.GvmSpace;

public class GvmResult<K> {
    private int count;
    private double mass;
    private GvmSpace space;
    private Object point;
    private double variance;
    private double stdDeviation;
    private K key;

    public GvmResult() {
    }

    GvmResult(GvmCluster<?, K> cluster) {
        this.count = cluster.count;
        this.mass = cluster.m0;
        this.variance = cluster.var / this.mass;
        this.stdDeviation = -1.0;
        this.key = cluster.key;
        this.space = cluster.clusters.space;
        this.point = this.space.newCopy(cluster.m1);
        this.space.scale(this.point, 1.0 / this.mass);
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public GvmSpace getSpace() {
        return this.space;
    }

    public void setSpace(GvmSpace space) {
        this.space = space;
    }

    public Object getPoint() {
        return this.point;
    }

    public void setPoint(Object point) {
        this.point = point;
    }

    public double getVariance() {
        return this.variance;
    }

    public double getStdDeviation() {
        return this.stdDeviation < 0.0 ? (this.stdDeviation = Math.sqrt(this.variance)) : this.stdDeviation;
    }

    public void setVariance(double variance) {
        if (variance < 0.0) {
            throw new IllegalArgumentException("negative variance");
        }
        this.variance = variance;
        this.stdDeviation = -1.0;
    }

    public K getKey() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("point: %s  count: %d  variance: %3.3f  mass: %3.3f  key: %s", this.space.toString(this.point), this.count, this.variance, this.mass, this.key));
        return sb.toString();
    }
}

