/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.colors;

import java.awt.Color;
import java.util.ArrayList;
import org.hortonmachine.gears.utils.colors.DefaultTables;

public class ColorInterpolator {
    private Color[] colors;
    private double[] values;
    private double min;
    private double max;

    public ColorInterpolator(Color[] colors, double[] values, int alpha) {
        this.colors = colors;
        this.values = values;
        this.min = values[0];
        this.max = values[values.length - 1];
    }

    public ColorInterpolator(String colorTableName, double min, double max, Integer alpha) {
        this.min = min;
        this.max = max;
        this.createColortableArrays(colorTableName, min, max, alpha);
    }

    public Color getColorFor(double value) {
        if (value <= this.min) {
            return this.colors[0];
        }
        if (value >= this.max) {
            return this.colors[this.colors.length - 1];
        }
        for (int i = 1; i < this.colors.length; ++i) {
            double v1 = this.values[i - 1];
            double v2 = this.values[i];
            if (!(value < v2)) continue;
            double v = (value - v1) / (v2 - v1);
            Color interpolateColor = ColorInterpolator.interpolateColor(this.colors[i - 1], this.colors[i], (float)v);
            return interpolateColor;
        }
        return this.colors[this.colors.length - 1];
    }

    private void createColortableArrays(String colorTableName, double min, double max, Integer alpha) {
        int a = 255;
        if (alpha != null) {
            a = alpha;
        }
        ArrayList<Color> colorList = new ArrayList<Color>();
        String tableString = new DefaultTables().getTableString(colorTableName);
        String[] split = tableString.split("\n");
        int length = split.length - 1;
        double delta = (max - min) / (double)length;
        this.values = new double[split.length];
        for (int i = 0; i < split.length; ++i) {
            this.values[i] = min + (double)i * delta;
        }
        ArrayList<Double> newValues = null;
        for (String line : split) {
            int b1;
            int g1;
            int r1;
            if (line.startsWith("#")) continue;
            String[] lineSplit = line.trim().split("\\s+");
            if (lineSplit.length == 3) {
                int r = Integer.parseInt(lineSplit[0]);
                int g = Integer.parseInt(lineSplit[1]);
                int b = Integer.parseInt(lineSplit[2]);
                colorList.add(new Color(r, g, b, a));
                continue;
            }
            if (lineSplit.length == 8) {
                if (newValues == null) {
                    newValues = new ArrayList<Double>();
                }
                double v1 = Double.parseDouble(lineSplit[0]);
                r1 = Integer.parseInt(lineSplit[1]);
                g1 = Integer.parseInt(lineSplit[2]);
                b1 = Integer.parseInt(lineSplit[3]);
                colorList.add(new Color(r1, g1, b1, a));
                newValues.add(v1);
                double v2 = Double.parseDouble(lineSplit[4]);
                int r2 = Integer.parseInt(lineSplit[5]);
                int g2 = Integer.parseInt(lineSplit[6]);
                int b2 = Integer.parseInt(lineSplit[7]);
                colorList.add(new Color(r2, g2, b2, a));
                newValues.add(v2);
                continue;
            }
            if (lineSplit.length != 4) continue;
            if (newValues == null) {
                newValues = new ArrayList();
            }
            double v1 = Double.parseDouble(lineSplit[0]);
            r1 = Integer.parseInt(lineSplit[1]);
            g1 = Integer.parseInt(lineSplit[2]);
            b1 = Integer.parseInt(lineSplit[3]);
            colorList.add(new Color(r1, g1, b1, a));
            newValues.add(v1);
        }
        this.colors = colorList.toArray(new Color[0]);
        if (newValues != null) {
            this.values = new double[newValues.size()];
            for (int i = 0; i < newValues.size(); ++i) {
                this.values[i] = (Double)newValues.get(i);
            }
        }
    }

    public static Color interpolateColor(Color color1, Color color2, float fraction) {
        float int2Float = 0.003921569f;
        fraction = Math.min(fraction, 1.0f);
        fraction = Math.max(fraction, 0.0f);
        float r1 = (float)color1.getRed() * int2Float;
        float g1 = (float)color1.getGreen() * int2Float;
        float b1 = (float)color1.getBlue() * int2Float;
        float a1 = (float)color1.getAlpha() * int2Float;
        float r2 = (float)color2.getRed() * int2Float;
        float g2 = (float)color2.getGreen() * int2Float;
        float b2 = (float)color2.getBlue() * int2Float;
        float a2 = (float)color2.getAlpha() * int2Float;
        float deltaR = r2 - r1;
        float deltaG = g2 - g1;
        float deltaB = b2 - b1;
        float deltaA = a2 - a1;
        float red = r1 + deltaR * fraction;
        float green = g1 + deltaG * fraction;
        float blue = b1 + deltaB * fraction;
        float alpha = a1 + deltaA * fraction;
        red = Math.min(red, 1.0f);
        red = Math.max(red, 0.0f);
        green = Math.min(green, 1.0f);
        green = Math.max(green, 0.0f);
        blue = Math.min(blue, 1.0f);
        blue = Math.max(blue, 0.0f);
        alpha = Math.min(alpha, 1.0f);
        alpha = Math.max(alpha, 0.0f);
        return new Color(red, green, blue, alpha);
    }
}

