/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.colors;

import java.awt.Color;

public class ColorUtilities {
    public static Color colorFromRbgString(String rbgString) {
        String[] split = rbgString.contains(",") ? rbgString.split(",") : rbgString.split(" ");
        if (split.length < 3 || split.length > 4) {
            throw new IllegalArgumentException("Color string has to be of type r,g,b.");
        }
        int r = (int)Double.parseDouble(split[0].trim());
        int g = (int)Double.parseDouble(split[1].trim());
        int b = (int)Double.parseDouble(split[2].trim());
        Color c = null;
        if (split.length == 4) {
            int a = (int)Double.parseDouble(split[3].trim());
            c = new Color(r, g, b, a);
        } else {
            c = new Color(r, g, b);
        }
        return c;
    }

    public static String asHexWithAlpha(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int a = color.getAlpha();
        String hex = String.format("#%02x%02x%02x%02x", r, g, b, a);
        return hex;
    }

    public static String asHex(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        String hex = String.format("#%02x%02x%02x", r, g, b);
        return hex;
    }

    public static Color fromHex(String hex) {
        int total;
        int length;
        if (((String)hex).startsWith("#")) {
            hex = ((String)hex).substring(1);
        }
        if ((length = ((String)hex).length()) < (total = 6)) {
            String token = hex;
            int tokenLength = token.length();
            for (int i = 0; i < total; i += tokenLength) {
                hex = (String)hex + token;
            }
        }
        int index = 0;
        String r = ((String)hex).substring(index, index + 2);
        String g = ((String)hex).substring(index + 2, index + 4);
        String b = ((String)hex).substring(index + 4, index + total);
        return new Color(Integer.valueOf(r, 16), Integer.valueOf(g, 16), Integer.valueOf(b, 16));
    }

    public static Color makeTransparent(Color color, int alpha) {
        Color transparentColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        return transparentColor;
    }
}

