/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.colors;

import java.awt.Color;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.hortonmachine.gears.utils.SldUtilities;
import org.hortonmachine.gears.utils.colors.ColorUtilities;
import org.hortonmachine.gears.utils.colors.DefaultTables;
import org.hortonmachine.gears.utils.colors.EColorTables;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.gears.utils.math.NumericsUtilities;
import org.opengis.filter.expression.Expression;
import org.opengis.style.ColorMap;

public class RasterStyleUtilities {
    private static StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);

    public static void dumpRasterStyle(String path, double min, double max, double[] values, Color[] colors, double opacity) throws Exception {
        String styleStr = RasterStyleUtilities.createRasterStyleString(min, max, values, colors, opacity);
        FileUtilities.writeFile(styleStr, new File(path));
    }

    private static String createRasterStyleString(double min, double max, double[] values, Color[] colors, double opacity) throws Exception {
        Style newStyle = RasterStyleUtilities.createRasterStyle(min, max, values, colors, opacity);
        String styleStr = SldUtilities.styleToString(newStyle);
        return styleStr;
    }

    private static Style createRasterStyle(double min, double max, double[] values, Color[] colors, double opacity) {
        StyleBuilder sB = new StyleBuilder(sf);
        RasterSymbolizer rasterSym = sf.createRasterSymbolizer();
        int colorsNum = colors.length;
        boolean hasAllValues = false;
        if (values != null) {
            hasAllValues = true;
        }
        double interval = (max - min) / (double)(colorsNum - 1);
        double runningValue = min;
        org.geotools.styling.ColorMap colorMap = sf.createColorMap();
        Expression whiteColorExpr = sB.colorExpression(Color.white);
        Expression novalExpr = sB.literalExpression(-9999);
        Expression zeroOpacityExpr = sB.literalExpression(0);
        ColorMapEntry novalueEntry = sf.createColorMapEntry();
        novalueEntry.setQuantity(novalExpr);
        novalueEntry.setColor(whiteColorExpr);
        novalueEntry.setOpacity(zeroOpacityExpr);
        colorMap.addColorMapEntry(novalueEntry);
        for (int i = 0; i < colors.length - 1; ++i) {
            ColorMapEntry entry;
            double end;
            double start;
            Color fromColor = colors[i];
            Color toColor = colors[i + 1];
            if (hasAllValues) {
                start = values[i];
                end = values[i + 1];
            } else {
                start = runningValue;
                end = runningValue += interval;
            }
            Expression opacityExpr = sB.literalExpression(opacity);
            if (i == 0) {
                Expression fromColorExpr = sB.colorExpression(fromColor);
                Expression fromExpr = sB.literalExpression(start);
                entry = sf.createColorMapEntry();
                entry.setQuantity(fromExpr);
                entry.setColor(fromColorExpr);
                entry.setOpacity(opacityExpr);
                colorMap.addColorMapEntry(entry);
            }
            if (NumericsUtilities.dEq(start, end)) continue;
            Expression toColorExpr = sB.colorExpression(toColor);
            Expression toExpr = sB.literalExpression(end);
            entry = sf.createColorMapEntry();
            entry.setQuantity(toExpr);
            entry.setOpacity(opacityExpr);
            entry.setColor(toColorExpr);
            colorMap.addColorMapEntry(entry);
        }
        rasterSym.setColorMap((ColorMap)colorMap);
        rasterSym.setOpacity(sB.literalExpression(opacity));
        Style newStyle = SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{rasterSym});
        return newStyle;
    }

    public static String createQGISRasterStyle(String colorTableName, double min, double max, double[] values, int labelDecimals) throws Exception {
        boolean isCategories = false;
        ArrayList<Color> colorList = new ArrayList<Color>();
        String tableString = new DefaultTables().getTableString(colorTableName);
        if (tableString == null) {
            return null;
        }
        String[] split = tableString.split("\n");
        ArrayList<Double> newValues = null;
        for (String line : split) {
            int b1;
            int g1;
            int r1;
            if (line.startsWith("#")) continue;
            String[] lineSplit = line.trim().split("\\s+");
            if (lineSplit.length == 3) {
                int r = Integer.parseInt(lineSplit[0]);
                int g = Integer.parseInt(lineSplit[1]);
                int b = Integer.parseInt(lineSplit[2]);
                colorList.add(new Color(r, g, b));
                continue;
            }
            if (lineSplit.length == 8) {
                if (newValues == null) {
                    newValues = new ArrayList<Double>();
                }
                double v1 = Double.parseDouble(lineSplit[0]);
                r1 = Integer.parseInt(lineSplit[1]);
                g1 = Integer.parseInt(lineSplit[2]);
                b1 = Integer.parseInt(lineSplit[3]);
                colorList.add(new Color(r1, g1, b1));
                newValues.add(v1);
                double v2 = Double.parseDouble(lineSplit[4]);
                int r2 = Integer.parseInt(lineSplit[5]);
                int g2 = Integer.parseInt(lineSplit[6]);
                int b2 = Integer.parseInt(lineSplit[7]);
                colorList.add(new Color(r2, g2, b2));
                newValues.add(v2);
                continue;
            }
            if (lineSplit.length != 4) continue;
            if (newValues == null) {
                newValues = new ArrayList();
            }
            double v1 = Double.parseDouble(lineSplit[0]);
            r1 = Integer.parseInt(lineSplit[1]);
            g1 = Integer.parseInt(lineSplit[2]);
            b1 = Integer.parseInt(lineSplit[3]);
            colorList.add(new Color(r1, g1, b1));
            newValues.add(v1);
            isCategories = true;
        }
        Color[] colorsArray = colorList.toArray(new Color[0]);
        if (newValues != null) {
            values = new double[newValues.size()];
            for (int i = 0; i < newValues.size(); ++i) {
                values[i] = (Double)newValues.get(i);
            }
        }
        if (isCategories) {
            return RasterStyleUtilities.getQgisStyleCategories(min, max, values, colorsArray, labelDecimals);
        }
        return RasterStyleUtilities.getQgisStyleContinuous(min, max, values, colorsArray, labelDecimals);
    }

    private static String getQgisStyleCategories(double min, double max, double[] values, Color[] colors, int labelDecimals) throws Exception {
        Object fPattern = "0.#################";
        if (labelDecimals >= 0) {
            fPattern = "0.";
            for (int i = 0; i < labelDecimals; ++i) {
                fPattern = (String)fPattern + "#";
            }
        }
        DecimalFormat f = new DecimalFormat((String)fPattern);
        String ind = "\t";
        StringBuilder sb = new StringBuilder();
        sb.append("<qgis>\n");
        sb.append(ind).append("<pipe>\n");
        sb.append(ind).append(ind).append("<rasterrenderer band=\"1\" type=\"paletted\" alphaBand=\"-1\" opacity=\"1\" nodataColor=\"\">\n");
        sb.append(ind).append(ind).append(ind).append("<colorPalette>\n");
        for (int i = 0; i < colors.length; ++i) {
            double value = values[i];
            sb.append(ind).append(ind).append(ind).append(ind);
            String label = f.format(value);
            String color = ColorUtilities.asHex(colors[i]);
            sb.append("<paletteEntry value=\"" + value + "\" alpha=\"255\" color=\"" + color + "\" label=\"" + label + "\"/>\n");
        }
        sb.append(ind).append(ind).append(ind).append("</colorPalette>\n");
        sb.append(ind).append(ind).append("</rasterrenderer>\n");
        sb.append(ind).append("</pipe>\n");
        sb.append("</qgis>\n");
        return sb.toString();
    }

    private static String getQgisStyleContinuous(double min, double max, double[] values, Color[] colors, int labelDecimals) throws Exception {
        double delta = (max - min) / (double)(colors.length - 1);
        if (values == null) {
            values = new double[colors.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = min + delta * (double)i;
            }
        }
        Object fPattern = "0.#################";
        if (labelDecimals >= 0) {
            fPattern = "0.";
            for (int i = 0; i < labelDecimals; ++i) {
                fPattern = (String)fPattern + "#";
            }
        }
        DecimalFormat f = new DecimalFormat((String)fPattern);
        String ind = "\t";
        StringBuilder sb = new StringBuilder();
        sb.append("<qgis>\n");
        sb.append(ind).append("<pipe>\n");
        sb.append(ind).append(ind).append("<rasterrenderer band=\"1\" type=\"singlebandpseudocolor\"").append(" classificationMax=\"").append(max).append("\"").append(" classificationMin=\"").append(min).append("\"").append(" alphaBand=\"-1\" opacity=\"1\" nodataColor=\"\">\n");
        sb.append(ind).append(ind).append(ind).append("<rastershader>\n");
        sb.append(ind).append(ind).append(ind).append(ind).append("<colorrampshader ").append(" minimumValue=\"").append(min).append("\"").append(" maximumValue=\"").append(max).append("\"").append(" colorRampType=\"INTERPOLATED\"").append(" classificationMode=\"1\"").append(" clip=\"0\"").append(">\n");
        for (int i = 0; i < values.length; ++i) {
            sb.append(ind).append(ind).append(ind).append(ind).append(ind);
            String label = f.format(values[i]);
            String color = ColorUtilities.asHex(colors[i]);
            sb.append("<item color=\"" + color + "\" value=\"" + values[i] + "\" label=\"" + label + "\" alpha=\"255\"/>\n");
        }
        sb.append(ind).append(ind).append(ind).append(ind).append("</colorrampshader>\n");
        sb.append(ind).append(ind).append(ind).append("</rastershader>\n");
        sb.append(ind).append(ind).append("</rasterrenderer>\n");
        sb.append(ind).append("</pipe>\n");
        sb.append("</qgis>\n");
        return sb.toString();
    }

    public static Style createDefaultRasterStyle() {
        RasterSymbolizer rasterSym = sf.createRasterSymbolizer();
        Style newStyle = SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{rasterSym});
        return newStyle;
    }

    public static Style createStyleForColortable(String colorTableName, double min, double max, double opacity) throws Exception {
        return RasterStyleUtilities.createStyleForColortable(colorTableName, min, max, null, opacity);
    }

    public static Style createStyleForColortable(String colorTableName, double min, double max, double[] values, double opacity) throws Exception {
        ArrayList<Color> colorList = new ArrayList<Color>();
        String tableString = new DefaultTables().getTableString(colorTableName);
        if (tableString == null) {
            return null;
        }
        String[] split = tableString.split("\n");
        ArrayList<Double> newValues = null;
        for (String line : split) {
            int b1;
            int g1;
            int r1;
            if (line.startsWith("#")) continue;
            String[] lineSplit = line.trim().split("\\s+");
            if (lineSplit.length == 3) {
                int r = Integer.parseInt(lineSplit[0]);
                int g = Integer.parseInt(lineSplit[1]);
                int b = Integer.parseInt(lineSplit[2]);
                colorList.add(new Color(r, g, b));
                continue;
            }
            if (lineSplit.length == 8) {
                if (newValues == null) {
                    newValues = new ArrayList<Double>();
                }
                double v1 = Double.parseDouble(lineSplit[0]);
                r1 = Integer.parseInt(lineSplit[1]);
                g1 = Integer.parseInt(lineSplit[2]);
                b1 = Integer.parseInt(lineSplit[3]);
                colorList.add(new Color(r1, g1, b1));
                newValues.add(v1);
                double v2 = Double.parseDouble(lineSplit[4]);
                int r2 = Integer.parseInt(lineSplit[5]);
                int g2 = Integer.parseInt(lineSplit[6]);
                int b2 = Integer.parseInt(lineSplit[7]);
                colorList.add(new Color(r2, g2, b2));
                newValues.add(v2);
                continue;
            }
            if (lineSplit.length != 4) continue;
            if (newValues == null) {
                newValues = new ArrayList();
            }
            double v1 = Double.parseDouble(lineSplit[0]);
            r1 = Integer.parseInt(lineSplit[1]);
            g1 = Integer.parseInt(lineSplit[2]);
            b1 = Integer.parseInt(lineSplit[3]);
            colorList.add(new Color(r1, g1, b1));
            newValues.add(v1);
        }
        Color[] colorsArray = colorList.toArray(new Color[0]);
        if (newValues != null) {
            values = new double[newValues.size()];
            for (int i = 0; i < newValues.size(); ++i) {
                values[i] = (Double)newValues.get(i);
            }
        }
        return RasterStyleUtilities.createRasterStyle(min, max, values, colorsArray, opacity);
    }

    public static String styleToString(Style style) throws Exception {
        String styleStr = SldUtilities.styleToString(style);
        return styleStr;
    }

    public static void main(String[] args) throws Exception {
        double[] values = new double[]{0.0, 360.0};
        String createStyleForColortable = RasterStyleUtilities.styleToString(RasterStyleUtilities.createStyleForColortable(EColorTables.elev.name(), 73.835, 144.889, 0.8));
        System.out.println(createStyleForColortable);
    }
}

