/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.coverage;

import it.geosolutions.jaiext.range.NoDataContainer;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterFactory;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.hortonmachine.gears.libs.exceptions.ModelsIOException;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.monitor.DummyProgressMonitor;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.coverage.ProfilePoint;
import org.hortonmachine.gears.utils.coverage.RenderedSampleDimension;
import org.hortonmachine.gears.utils.features.FastLiteShape;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.hortonmachine.gears.utils.math.NumericsUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.linearref.LengthIndexedLine;
import org.locationtech.jts.operation.union.CascadedPolygonUnion;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class CoverageUtilities {
    public static final String NORTH = "NORTH";
    public static final String SOUTH = "SOUTH";
    public static final String WEST = "WEST";
    public static final String EAST = "EAST";
    public static final String XRES = "XRES";
    public static final String YRES = "YRES";
    public static final String ROWS = "ROWS";
    public static final String COLS = "COLS";

    public static RandomIter getRandomIterator(GridCoverage2D coverage) {
        RenderedImage renderedImage = coverage.getRenderedImage();
        RandomIter iter = RandomIterFactory.create((RenderedImage)renderedImage, null);
        return iter;
    }

    public static WritableRandomIter getWritableRandomIterator(int width, int height) {
        WritableRaster pitRaster = CoverageUtilities.createWritableRaster(width, height, null, null, null);
        WritableRandomIter iter = RandomIterFactory.createWritable((WritableRaster)pitRaster, null);
        return iter;
    }

    public static WritableRandomIter getWritableRandomIterator(WritableRaster raster) {
        WritableRandomIter iter = RandomIterFactory.createWritable((WritableRaster)raster, null);
        return iter;
    }

    public static GridCoverage2D getGridCoverage(GridCoverage2DReader reader, double north, double south, double east, double west, double xRes, double yRes, CoordinateReferenceSystem crs) throws Exception {
        GeneralParameterValue[] readGeneralParameterValues = CoverageUtilities.createGridGeometryGeneralParameter(xRes, yRes, north, south, east, west, crs);
        GridCoverage2D readGC = reader.read(readGeneralParameterValues);
        return readGC;
    }

    public static WritableRaster createWritableRaster(int width, int height, Class<?> dataClass, SampleModel sampleModel, Object value) {
        WritableRaster raster;
        block27: {
            int dataType = 5;
            if (dataClass != null) {
                if (dataClass.isAssignableFrom(Integer.class)) {
                    dataType = 3;
                } else if (dataClass.isAssignableFrom(Float.class)) {
                    dataType = 4;
                } else if (dataClass.isAssignableFrom(Byte.class)) {
                    dataType = 0;
                } else if (dataClass.isAssignableFrom(Short.class)) {
                    dataType = 2;
                }
            }
            if (sampleModel == null) {
                sampleModel = new ComponentSampleModel(dataType, width, height, 1, width, new int[]{0});
            }
            raster = RasterFactory.createWritableRaster((SampleModel)sampleModel, null);
            if (value == null) break block27;
            if (value instanceof Double) {
                Double valueObj = (Double)value;
                double v = valueObj;
                double[] dArray = new double[sampleModel.getNumBands()];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = v;
                }
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        raster.setPixel(x, y, dArray);
                    }
                }
            } else if (value instanceof Integer) {
                Integer valueObj = (Integer)value;
                int v = valueObj;
                int[] dArray = new int[sampleModel.getNumBands()];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = v;
                }
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        raster.setPixel(x, y, dArray);
                    }
                }
            } else if (value instanceof Float) {
                Float valueObj = (Float)value;
                float v = valueObj.floatValue();
                float[] dArray = new float[sampleModel.getNumBands()];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = v;
                }
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        raster.setPixel(x, y, dArray);
                    }
                }
            } else {
                double v = ((Number)value).doubleValue();
                double[] dArray = new double[sampleModel.getNumBands()];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = v;
                }
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        raster.setPixel(x, y, dArray);
                    }
                }
            }
        }
        return raster;
    }

    public static GridCoverage2D createCoverageFromTemplate(GridCoverage2D template, Double value, WritableRaster[] writableRasterHolder) {
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(template);
        double west = regionMap.getWest();
        double south = regionMap.getSouth();
        double east = regionMap.getEast();
        double north = regionMap.getNorth();
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        ComponentSampleModel sampleModel = new ComponentSampleModel(5, cols, rows, 1, cols, new int[]{0});
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sampleModel, null);
        if (value != null) {
            double v = value;
            for (int y = 0; y < rows; ++y) {
                for (int x = 0; x < cols; ++x) {
                    raster.setSample(x, y, 0, v);
                }
            }
        }
        if (writableRasterHolder != null) {
            writableRasterHolder[0] = raster;
        }
        Envelope2D writeEnvelope = new Envelope2D(template.getCoordinateReferenceSystem(), west, south, east - west, north - south);
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
        GridCoverage2D coverage2D = factory.create((CharSequence)"newraster", raster, (Envelope)writeEnvelope);
        return coverage2D;
    }

    public static GridCoverage2D createSubCoverageFromTemplate(GridCoverage2D template, Envelope2D subregion, Double value, WritableRaster[] writableRasterHolder) {
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(template);
        double xRes = regionMap.getXres();
        double yRes = regionMap.getYres();
        double west = subregion.getMinX();
        double south = subregion.getMinY();
        double east = subregion.getMaxX();
        double north = subregion.getMaxY();
        int cols = (int)((east - west) / xRes);
        int rows = (int)((north - south) / yRes);
        ComponentSampleModel sampleModel = new ComponentSampleModel(5, cols, rows, 1, cols, new int[]{0});
        WritableRaster writableRaster = RasterFactory.createWritableRaster((SampleModel)sampleModel, null);
        if (value != null) {
            double v = value;
            for (int y = 0; y < rows; ++y) {
                for (int x = 0; x < cols; ++x) {
                    writableRaster.setSample(x, y, 0, v);
                }
            }
        }
        if (writableRasterHolder != null) {
            writableRasterHolder[0] = writableRaster;
        }
        Envelope2D writeEnvelope = new Envelope2D(template.getCoordinateReferenceSystem(), west, south, east - west, north - south);
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
        GridCoverage2D coverage2D = factory.create((CharSequence)"newraster", writableRaster, (Envelope)writeEnvelope);
        return coverage2D;
    }

    public static GridCoverage2D clipCoverage(GridCoverage2D coverage, ReferencedEnvelope envelope) throws Exception {
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(coverage);
        double xRes = regionMap.getXres();
        double yRes = regionMap.getYres();
        envelope = envelope.transform(coverage.getCoordinateReferenceSystem(), true);
        RegionMap subRegion = regionMap.toSubRegion((org.locationtech.jts.geom.Envelope)envelope);
        envelope = new ReferencedEnvelope(subRegion.toEnvelope(), coverage.getCoordinateReferenceSystem());
        double west = envelope.getMinX();
        double south = envelope.getMinY();
        double east = envelope.getMaxX();
        double north = envelope.getMaxY();
        int cols = (int)((east - west) / xRes);
        int rows = (int)((north - south) / yRes);
        ComponentSampleModel sampleModel = new ComponentSampleModel(5, cols, rows, 1, cols, new int[]{0});
        WritableRaster writableRaster = RasterFactory.createWritableRaster((SampleModel)sampleModel, null);
        Envelope2D writeEnvelope = new Envelope2D(coverage.getCoordinateReferenceSystem(), west, south, east - west, north - south);
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
        GridCoverage2D clippedCoverage = factory.create((CharSequence)"newraster", writableRaster, (Envelope)writeEnvelope);
        GridGeometry2D destGG = clippedCoverage.getGridGeometry();
        GridGeometry2D sourceGG = coverage.getGridGeometry();
        RandomIter iter = CoverageUtilities.getRandomIterator(coverage);
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                DirectPosition world = destGG.gridToWorld(new GridCoordinates2D(x, y));
                GridCoordinates2D sourceGrid = sourceGG.worldToGrid(world);
                double value = iter.getSampleDouble(sourceGrid.x, sourceGrid.y, 0);
                writableRaster.setSample(x, y, 0, value);
            }
        }
        iter.done();
        return clippedCoverage;
    }

    public static GridCoverage2D apply(GridCoverage2D coverage, DoubleUnaryOperator operator) throws Exception {
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(coverage);
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        double nv = HMConstants.getNovalue(coverage);
        WritableRaster outWR = CoverageUtilities.renderedImage2WritableRaster(coverage.getRenderedImage(), false);
        WritableRandomIter iter = RandomIterFactory.createWritable((WritableRaster)outWR, null);
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                double value = iter.getSampleDouble(x, y, 0);
                if (HMConstants.isNovalue(value, nv)) continue;
                double newValue = operator.applyAsDouble(value);
                iter.setSample(x, y, 0, newValue);
            }
        }
        iter.done();
        GridCoverage2D outCoverage = CoverageUtilities.buildCoverage("applied", outWR, (HashMap<String, Double>)regionMap, coverage.getCoordinateReferenceSystem());
        return outCoverage;
    }

    public static RegionMap getRegionParamsFromGridCoverage(GridCoverage2D gridCoverage) {
        RegionMap envelopeParams = new RegionMap();
        Envelope envelope = gridCoverage.getEnvelope();
        DirectPosition lowerCorner = envelope.getLowerCorner();
        double[] westSouth = lowerCorner.getCoordinate();
        DirectPosition upperCorner = envelope.getUpperCorner();
        double[] eastNorth = upperCorner.getCoordinate();
        GridGeometry2D gridGeometry = gridCoverage.getGridGeometry();
        GridEnvelope2D gridRange = gridGeometry.getGridRange2D();
        int height = gridRange.height;
        int width = gridRange.width;
        AffineTransform gridToCRS = (AffineTransform)gridGeometry.getGridToCRS();
        double xRes = XAffineTransform.getScaleX0((AffineTransform)gridToCRS);
        double yRes = XAffineTransform.getScaleY0((AffineTransform)gridToCRS);
        envelopeParams.put(NORTH, eastNorth[1]);
        envelopeParams.put(SOUTH, westSouth[1]);
        envelopeParams.put(WEST, westSouth[0]);
        envelopeParams.put(EAST, eastNorth[0]);
        envelopeParams.put(XRES, xRes);
        envelopeParams.put(YRES, yRes);
        envelopeParams.put(ROWS, Double.valueOf(height));
        envelopeParams.put(COLS, Double.valueOf(width));
        return envelopeParams;
    }

    public static RegionMap getRegionParamsFromImageMosaicReader(ImageMosaicReader reader) throws IOException {
        RegionMap envelopeParams = new RegionMap();
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        DirectPosition lowerCorner = envelope.getLowerCorner();
        double[] westSouth = lowerCorner.getCoordinate();
        DirectPosition upperCorner = envelope.getUpperCorner();
        double[] eastNorth = upperCorner.getCoordinate();
        GridEnvelope2D gridRange = (GridEnvelope2D)reader.getOriginalGridRange();
        int height = gridRange.height;
        int width = gridRange.width;
        double[][] resolutionLevels = reader.getResolutionLevels();
        double xRes = resolutionLevels[0][0];
        double yRes = resolutionLevels[0][1];
        envelopeParams.put(NORTH, eastNorth[1]);
        envelopeParams.put(SOUTH, westSouth[1]);
        envelopeParams.put(WEST, westSouth[0]);
        envelopeParams.put(EAST, eastNorth[0]);
        envelopeParams.put(XRES, xRes);
        envelopeParams.put(YRES, yRes);
        envelopeParams.put(ROWS, Double.valueOf(height));
        envelopeParams.put(COLS, Double.valueOf(width));
        return envelopeParams;
    }

    public static double[] getRegionArrayFromGridCoverage(GridCoverage2D gridCoverage) {
        Envelope envelope = gridCoverage.getEnvelope();
        DirectPosition lowerCorner = envelope.getLowerCorner();
        double[] westSouth = lowerCorner.getCoordinate();
        DirectPosition upperCorner = envelope.getUpperCorner();
        double[] eastNorth = upperCorner.getCoordinate();
        GridGeometry2D gridGeometry = gridCoverage.getGridGeometry();
        GridEnvelope2D gridRange = gridGeometry.getGridRange2D();
        int height = gridRange.height;
        int width = gridRange.width;
        AffineTransform gridToCRS = (AffineTransform)gridGeometry.getGridToCRS();
        double xRes = XAffineTransform.getScaleX0((AffineTransform)gridToCRS);
        double yRes = XAffineTransform.getScaleY0((AffineTransform)gridToCRS);
        double[] params = new double[]{eastNorth[1], westSouth[1], westSouth[0], eastNorth[0], xRes, yRes, width, height};
        return params;
    }

    public static int[] getRegionColsRows(GridCoverage2D gridCoverage) {
        GridGeometry2D gridGeometry = gridCoverage.getGridGeometry();
        GridEnvelope2D gridRange = gridGeometry.getGridRange2D();
        int height = gridRange.height;
        int width = gridRange.width;
        int[] params = new int[]{width, height};
        return params;
    }

    public static Polygon getRegionPolygon(GridCoverage2D gridCoverage) {
        Envelope2D env = gridCoverage.getEnvelope2D();
        Coordinate[] c = new Coordinate[]{new Coordinate(env.getMinX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMinY())};
        GeometryFactory gf = GeometryUtilities.gf();
        LinearRing linearRing = gf.createLinearRing(c);
        Polygon polygon = gf.createPolygon(linearRing, null);
        return polygon;
    }

    public static int[] getLoopColsRowsForSubregion(GridCoverage2D gridCoverage, Envelope2D subregion) throws Exception {
        GridGeometry2D gridGeometry = gridCoverage.getGridGeometry();
        GridEnvelope2D subRegionGrid = gridGeometry.worldToGrid(subregion);
        int minCol = subRegionGrid.x;
        int maxCol = subRegionGrid.x + subRegionGrid.width;
        int minRow = subRegionGrid.y;
        int maxRow = subRegionGrid.y + subRegionGrid.height;
        return new int[]{minCol, maxCol, minRow, maxRow};
    }

    public static RegionMap generalParameterValues2RegionParamsMap(GeneralParameterValue[] params) {
        GridGeometry2D gg = null;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                ParameterValue param = (ParameterValue)params[i];
                String name = param.getDescriptor().getName().getCode();
                if (!name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) continue;
                gg = (GridGeometry2D)param.getValue();
                break;
            }
        }
        if (gg == null) {
            throw new IllegalArgumentException("No gridgeometry present");
        }
        RegionMap regionParams = CoverageUtilities.gridGeometry2RegionParamsMap(gg);
        return regionParams;
    }

    public static RegionMap gridGeometry2RegionParamsMap(GridGeometry2D gridGeometry) {
        RegionMap envelopeParams = new RegionMap();
        Envelope2D envelope = gridGeometry.getEnvelope2D();
        DirectPosition lowerCorner = envelope.getLowerCorner();
        double[] westSouth = lowerCorner.getCoordinate();
        DirectPosition upperCorner = envelope.getUpperCorner();
        double[] eastNorth = upperCorner.getCoordinate();
        GridEnvelope2D gridRange = gridGeometry.getGridRange2D();
        int height = gridRange.height;
        int width = gridRange.width;
        AffineTransform gridToCRS = (AffineTransform)gridGeometry.getGridToCRS();
        double xRes = XAffineTransform.getScaleX0((AffineTransform)gridToCRS);
        double yRes = XAffineTransform.getScaleY0((AffineTransform)gridToCRS);
        envelopeParams.put(NORTH, eastNorth[1]);
        envelopeParams.put(SOUTH, westSouth[1]);
        envelopeParams.put(WEST, westSouth[0]);
        envelopeParams.put(EAST, eastNorth[0]);
        envelopeParams.put(XRES, xRes);
        envelopeParams.put(YRES, yRes);
        envelopeParams.put(ROWS, Double.valueOf(height));
        envelopeParams.put(COLS, Double.valueOf(width));
        return envelopeParams;
    }

    public static RegionMap makeRegionParamsMap(double north, double south, double west, double east, double xRes, double yRes, int width, int height) {
        RegionMap envelopeParams = new RegionMap();
        envelopeParams.put(NORTH, north);
        envelopeParams.put(SOUTH, south);
        envelopeParams.put(WEST, west);
        envelopeParams.put(EAST, east);
        envelopeParams.put(XRES, xRes);
        envelopeParams.put(YRES, yRes);
        envelopeParams.put(ROWS, Double.valueOf(height));
        envelopeParams.put(COLS, Double.valueOf(width));
        return envelopeParams;
    }

    public static GridGeometry2D gridGeometryFromRegionParams(HashMap<String, Double> envelopeParams, CoordinateReferenceSystem crs) {
        double west = envelopeParams.get(WEST);
        double south = envelopeParams.get(SOUTH);
        double east = envelopeParams.get(EAST);
        double north = envelopeParams.get(NORTH);
        int rows = envelopeParams.get(ROWS).intValue();
        int cols = envelopeParams.get(COLS).intValue();
        return CoverageUtilities.gridGeometryFromRegionValues(north, south, east, west, cols, rows, crs);
    }

    public static GridGeometry2D gridGeometryFromRegionValues(double north, double south, double east, double west, int cols, int rows, CoordinateReferenceSystem crs) {
        Envelope2D envelope = new Envelope2D(crs, west, south, east - west, north - south);
        GridEnvelope2D gridRange = new GridEnvelope2D(0, 0, cols, rows);
        GridGeometry2D gridGeometry2D = new GridGeometry2D((GridEnvelope)gridRange, (Envelope)envelope);
        return gridGeometry2D;
    }

    public static GeneralParameterValue[] createGridGeometryGeneralParameter(int width, int height, double north, double south, double east, double west, CoordinateReferenceSystem crs) {
        ReferencedEnvelope env;
        GeneralParameterValue[] readParams = new GeneralParameterValue[1];
        Parameter readGG = new Parameter((ParameterDescriptor)AbstractGridFormat.READ_GRIDGEOMETRY2D);
        GridEnvelope2D gridEnvelope = new GridEnvelope2D(0, 0, width, height);
        if (crs != null) {
            env = new ReferencedEnvelope(west, east, south, north, crs);
        } else {
            DirectPosition2D minDp = new DirectPosition2D(west, south);
            DirectPosition2D maxDp = new DirectPosition2D(east, north);
            env = new Envelope2D(minDp, maxDp);
        }
        GridGeometry2D gridGeometry = new GridGeometry2D((GridEnvelope)gridEnvelope, (Envelope)env);
        readGG.setValue((Object)gridGeometry);
        readParams[0] = readGG;
        return readParams;
    }

    public static GeneralParameterValue[] createGridGeometryGeneralParameter(RegionMap regionMap, CoordinateReferenceSystem crs) {
        ReferencedEnvelope env;
        GeneralParameterValue[] readParams = new GeneralParameterValue[1];
        Parameter readGG = new Parameter((ParameterDescriptor)AbstractGridFormat.READ_GRIDGEOMETRY2D);
        GridEnvelope2D gridEnvelope = new GridEnvelope2D(0, 0, regionMap.getCols(), regionMap.getRows());
        double north = regionMap.getNorth();
        double south = regionMap.getSouth();
        double east = regionMap.getEast();
        double west = regionMap.getWest();
        if (crs != null) {
            env = new ReferencedEnvelope(west, east, south, north, crs);
        } else {
            DirectPosition2D minDp = new DirectPosition2D(west, south);
            DirectPosition2D maxDp = new DirectPosition2D(east, north);
            env = new Envelope2D(minDp, maxDp);
        }
        readGG.setValue((Object)new GridGeometry2D((GridEnvelope)gridEnvelope, (Envelope)env));
        readParams[0] = readGG;
        return readParams;
    }

    public static GeneralParameterValue[] createGridGeometryGeneralParameter(double xres, double yres, double north, double south, double east, double west, CoordinateReferenceSystem crs) {
        int width;
        int height = (int)Math.round((north - south) / yres);
        if (height < 1) {
            height = 1;
        }
        if ((width = (int)Math.round((east - west) / xres)) < 1) {
            width = 1;
        }
        GeneralParameterValue[] generalParameter = CoverageUtilities.createGridGeometryGeneralParameter(width, height, north, south, east, west, crs);
        return generalParameter;
    }

    public static WritableRaster createWritableRasterFromMatrix(double[][] matrix, boolean matrixIsRowCol) {
        int height = matrix.length;
        int width = matrix[0].length;
        if (!matrixIsRowCol) {
            int tmp = height;
            height = width;
            width = tmp;
        }
        WritableRaster writableRaster = CoverageUtilities.createWritableRaster(width, height, null, null, -9999.0);
        WritableRandomIter rasterIter = RandomIterFactory.createWritable((WritableRaster)writableRaster, null);
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                if (matrixIsRowCol) {
                    if (HMConstants.isNovalue(matrix[row][col])) continue;
                    rasterIter.setSample(col, row, 0, matrix[row][col]);
                    continue;
                }
                if (HMConstants.isNovalue(matrix[col][row])) continue;
                rasterIter.setSample(col, row, 0, matrix[col][row]);
            }
        }
        rasterIter.done();
        return writableRaster;
    }

    public static WritableRaster createWritableRasterFromMatrix(float[][] matrix, boolean matrixIsRowCol) {
        int height = matrix.length;
        int width = matrix[0].length;
        if (!matrixIsRowCol) {
            int tmp = height;
            height = width;
            width = tmp;
        }
        WritableRaster writableRaster = CoverageUtilities.createWritableRaster(width, height, null, null, null);
        WritableRandomIter randomIter = RandomIterFactory.createWritable((WritableRaster)writableRaster, null);
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                if (matrixIsRowCol) {
                    randomIter.setSample(col, row, 0, matrix[row][col]);
                    continue;
                }
                randomIter.setSample(col, row, 0, matrix[col][row]);
            }
        }
        randomIter.done();
        return writableRaster;
    }

    public static WritableRaster createWritableRasterFromMatrix(int[][] matrix, boolean matrixIsRowCol) {
        int height = matrix.length;
        int width = matrix[0].length;
        if (!matrixIsRowCol) {
            int tmp = height;
            height = width;
            width = tmp;
        }
        WritableRaster writableRaster = CoverageUtilities.createWritableRaster(width, height, null, null, null);
        WritableRandomIter randomIter = RandomIterFactory.createWritable((WritableRaster)writableRaster, null);
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                if (matrixIsRowCol) {
                    randomIter.setSample(col, row, 0, matrix[row][col]);
                    continue;
                }
                randomIter.setSample(col, row, 0, matrix[col][row]);
            }
        }
        randomIter.done();
        return writableRaster;
    }

    public static WritableRaster createWritableRasterFromArray(int width, int height, int[] pixels) {
        WritableRaster writableRaster = CoverageUtilities.createWritableRaster(width, height, null, null, null);
        int index = 0;
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                double value = pixels[index];
                if (value == 0.0) {
                    value = -9999.0;
                }
                writableRaster.setSample(col, row, 0, value);
                ++index;
            }
        }
        return writableRaster;
    }

    public static GridCoverage2D buildCoverage(String name, double[][] dataMatrix, HashMap<String, Double> envelopeParams, CoordinateReferenceSystem crs, boolean matrixIsRowCol) {
        WritableRaster writableRaster = CoverageUtilities.createWritableRasterFromMatrix(dataMatrix, matrixIsRowCol);
        return CoverageUtilities.buildCoverageWithNovalue(name, writableRaster, envelopeParams, crs, -9999.0);
    }

    public static GridCoverage2D buildCoverageWithNovalue(String name, double[][] dataMatrix, HashMap<String, Double> envelopeParams, CoordinateReferenceSystem crs, boolean matrixIsRowCol, double novalue) {
        WritableRaster writableRaster = CoverageUtilities.createWritableRasterFromMatrix(dataMatrix, matrixIsRowCol);
        return CoverageUtilities.buildCoverageWithNovalue(name, writableRaster, envelopeParams, crs, novalue);
    }

    public static GridCoverage2D buildCoverage(String name, float[][] dataMatrix, HashMap<String, Double> envelopeParams, CoordinateReferenceSystem crs, boolean matrixIsRowCol) {
        WritableRaster writableRaster = CoverageUtilities.createWritableRasterFromMatrix(dataMatrix, matrixIsRowCol);
        return CoverageUtilities.buildCoverageWithNovalue(name, writableRaster, envelopeParams, crs, -9999.0);
    }

    public static GridCoverage2D buildCoverage(String name, int[][] dataMatrix, HashMap<String, Double> envelopeParams, CoordinateReferenceSystem crs, boolean matrixIsRowCol) {
        WritableRaster writableRaster = CoverageUtilities.createWritableRasterFromMatrix(dataMatrix, matrixIsRowCol);
        return CoverageUtilities.buildCoverageWithNovalue(name, writableRaster, envelopeParams, crs, -9999.0);
    }

    public static GridCoverage2D buildCoverageWithNovalue(String name, int[][] dataMatrix, HashMap<String, Double> envelopeParams, CoordinateReferenceSystem crs, boolean matrixIsRowCol, int novalue) {
        WritableRaster writableRaster = CoverageUtilities.createWritableRasterFromMatrix(dataMatrix, matrixIsRowCol);
        return CoverageUtilities.buildCoverageWithNovalue(name, writableRaster, envelopeParams, crs, (double)novalue);
    }

    public static GridCoverage2D buildCoverage(String name, RenderedImage renderedImage, HashMap<String, Double> envelopeParams, CoordinateReferenceSystem crs) {
        return CoverageUtilities.buildCoverageWithNovalue(name, renderedImage, envelopeParams, crs, -9999.0);
    }

    public static GridCoverage2D buildCoverageWithNovalue(String name, RenderedImage renderedImage, HashMap<String, Double> envelopeParams, CoordinateReferenceSystem crs, double novalue) {
        double west = envelopeParams.get(WEST);
        double south = envelopeParams.get(SOUTH);
        double east = envelopeParams.get(EAST);
        double north = envelopeParams.get(NORTH);
        Envelope2D writeEnvelope = new Envelope2D(crs, west, south, east - west, north - south);
        GridSampleDimension[] bands = RenderedSampleDimension.create(name, renderedImage.getData(), null, null, null, null, null);
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
        HashMap<String, NoDataContainer> properties = new HashMap<String, NoDataContainer>();
        NoDataContainer ndc = new NoDataContainer(novalue);
        properties.put("GC_NODATA", ndc);
        GridCoverage2D coverage2D = factory.create((CharSequence)name, renderedImage, (Envelope)writeEnvelope, bands, null, properties);
        return coverage2D;
    }

    public static GridCoverage2D buildCoverage(String name, WritableRaster writableRaster, HashMap<String, Double> envelopeParams, CoordinateReferenceSystem crs) {
        return CoverageUtilities.buildCoverageWithNovalue(name, writableRaster, envelopeParams, crs, -9999.0);
    }

    public static GridCoverage2D buildCoverageWithNovalue(String name, WritableRaster writableRaster, HashMap<String, Double> envelopeParams, CoordinateReferenceSystem crs, double novalue) {
        double west = envelopeParams.get(WEST);
        double south = envelopeParams.get(SOUTH);
        double east = envelopeParams.get(EAST);
        double north = envelopeParams.get(NORTH);
        Envelope2D writeEnvelope = new Envelope2D(crs, west, south, east - west, north - south);
        GridSampleDimension[] bands = RenderedSampleDimension.create(name, writableRaster, null, null, null, null, null);
        ColorModel model = bands[0].getColorModel(0, bands.length, writableRaster.getSampleModel().getDataType());
        BufferedImage image = new BufferedImage(model, writableRaster, false, null);
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
        HashMap<String, NoDataContainer> properties = new HashMap<String, NoDataContainer>();
        NoDataContainer ndc = new NoDataContainer(novalue);
        properties.put("GC_NODATA", ndc);
        GridCoverage2D coverage2D = factory.create((CharSequence)name, (RenderedImage)image, (Envelope)writeEnvelope, bands, null, properties);
        return coverage2D;
    }

    public static GridCoverage2D buildDummyCoverage() {
        HashMap<String, Double> envelopeParams = new HashMap<String, Double>();
        envelopeParams.put(NORTH, 1.0);
        envelopeParams.put(SOUTH, 0.0);
        envelopeParams.put(WEST, 0.0);
        envelopeParams.put(EAST, 1.0);
        envelopeParams.put(XRES, 1.0);
        envelopeParams.put(YRES, 1.0);
        envelopeParams.put(ROWS, 1.0);
        envelopeParams.put(COLS, 1.0);
        double[][] dataMatrix = new double[1][1];
        dataMatrix[0][0] = 0.0;
        WritableRaster writableRaster = CoverageUtilities.createWritableRasterFromMatrix(dataMatrix, true);
        return CoverageUtilities.buildCoverage("dummy", writableRaster, envelopeParams, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public static WritableRaster renderedImage2WritableRaster(RenderedImage renderedImage, boolean nullBorders) {
        int width = renderedImage.getWidth();
        int height = renderedImage.getHeight();
        Raster data = renderedImage.getData();
        WritableRaster writableRaster = data.createCompatibleWritableRaster();
        writableRaster.setDataElements(0, 0, data);
        if (nullBorders) {
            for (int c = 0; c < width; ++c) {
                writableRaster.setSample(c, 0, 0, -9999.0);
                writableRaster.setSample(c, height - 1, 0, -9999.0);
            }
            for (int r = 0; r < height; ++r) {
                writableRaster.setSample(0, r, 0, -9999.0);
                writableRaster.setSample(width - 1, r, 0, -9999.0);
            }
        }
        return writableRaster;
    }

    public static WritableRaster renderedImage2DoubleWritableRaster(RenderedImage renderedImage, boolean nullBorders) {
        int width = renderedImage.getWidth();
        int height = renderedImage.getHeight();
        Raster data = renderedImage.getData();
        WritableRaster writableRaster = CoverageUtilities.createWritableRaster(width, height, Double.class, null, null);
        writableRaster.setRect(data);
        if (nullBorders) {
            for (int c = 0; c < width; ++c) {
                writableRaster.setSample(c, 0, 0, -9999.0);
                writableRaster.setSample(c, height - 1, 0, -9999.0);
            }
            for (int r = 0; r < height; ++r) {
                writableRaster.setSample(0, r, 0, -9999.0);
                writableRaster.setSample(width - 1, r, 0, -9999.0);
            }
        }
        return writableRaster;
    }

    public static WritableRaster renderedImage2IntWritableRaster(RenderedImage renderedImage, boolean nullBorders) {
        int width = renderedImage.getWidth();
        int height = renderedImage.getHeight();
        Raster data = renderedImage.getData();
        WritableRaster writableRaster = CoverageUtilities.createWritableRaster(width, height, Integer.class, null, null);
        writableRaster.setRect(data);
        if (nullBorders) {
            for (int c = 0; c < width; ++c) {
                writableRaster.setSample(c, 0, 0, -9999);
                writableRaster.setSample(c, height - 1, 0, -9999);
            }
            for (int r = 0; r < height; ++r) {
                writableRaster.setSample(0, r, 0, -9999);
                writableRaster.setSample(width - 1, r, 0, -9999);
            }
        }
        return writableRaster;
    }

    public static WritableRaster renderedImage2ShortWritableRaster(RenderedImage renderedImage, boolean nullBorders) {
        int width = renderedImage.getWidth();
        int height = renderedImage.getHeight();
        Raster data = renderedImage.getData();
        WritableRaster writableRaster = CoverageUtilities.createWritableRaster(width, height, Short.class, null, null);
        writableRaster.setRect(data);
        if (nullBorders) {
            for (int c = 0; c < width; ++c) {
                writableRaster.setSample(c, 0, 0, -9999);
                writableRaster.setSample(c, height - 1, 0, -9999);
            }
            for (int r = 0; r < height; ++r) {
                writableRaster.setSample(0, r, 0, -9999);
                writableRaster.setSample(width - 1, r, 0, -9999);
            }
        }
        return writableRaster;
    }

    public static double[] renderedImage2DoubleArray(RenderedImage renderedImage) {
        return CoverageUtilities.renderedImage2DoubleArray(renderedImage, 0);
    }

    public static double[] renderedImage2DoubleArray(RenderedImage renderedImage, int bandNumber) {
        int width = renderedImage.getWidth();
        int height = renderedImage.getHeight();
        double[] values = new double[width * height];
        RandomIter imageIter = RandomIterFactory.create((RenderedImage)renderedImage, null);
        int index = 0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double sample = imageIter.getSampleDouble(x, y, bandNumber);
                values[index++] = sample;
            }
        }
        imageIter.done();
        return values;
    }

    public static int[] renderedImage2IntegerArray(RenderedImage renderedImage, double multiply) {
        int width = renderedImage.getWidth();
        int height = renderedImage.getHeight();
        int[] values = new int[width * height];
        RandomIter imageIter = RandomIterFactory.create((RenderedImage)renderedImage, null);
        int index = 0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                double sample = imageIter.getSampleDouble(x, y, 0);
                values[index++] = (int)(sample *= multiply);
            }
        }
        imageIter.done();
        return values;
    }

    public static byte[] renderedImage2ByteArray(RenderedImage renderedImage, boolean doRowsThenCols) {
        int width = renderedImage.getWidth();
        int height = renderedImage.getHeight();
        byte[] values = new byte[width * height];
        RandomIter imageIter = RandomIterFactory.create((RenderedImage)renderedImage, null);
        int index = 0;
        if (doRowsThenCols) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    double sample = imageIter.getSampleDouble(x, y, 0);
                    values[index++] = (byte)sample;
                }
            }
        } else {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    double sample = imageIter.getSampleDouble(x, y, 0);
                    values[index++] = (byte)sample;
                }
            }
        }
        imageIter.done();
        return values;
    }

    public static WritableRaster integerArray2WritableRaster(int[] array, double divide, int width, int height) {
        WritableRaster writableRaster = CoverageUtilities.createWritableRaster(width, height, null, null, null);
        int index = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                double value = (double)array[index++] / divide;
                writableRaster.setSample(x, y, 0, value);
            }
        }
        return writableRaster;
    }

    public static WritableRaster doubleArray2WritableRaster(double[] array, int width, int height) {
        WritableRaster writableRaster = CoverageUtilities.createWritableRaster(width, height, null, null, null);
        int index = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                writableRaster.setSample(x, y, 0, array[index++]);
            }
        }
        return writableRaster;
    }

    public static void setNovalueBorder(WritableRaster raster) {
        int width = raster.getWidth();
        int height = raster.getHeight();
        for (int c = 0; c < width; ++c) {
            raster.setSample(c, 0, 0, -9999.0);
            raster.setSample(c, height - 1, 0, -9999.0);
        }
        for (int r = 0; r < height; ++r) {
            raster.setSample(0, r, 0, -9999.0);
            raster.setSample(width - 1, r, 0, -9999.0);
        }
    }

    public static List<ProfilePoint> doProfile(GridCoverage2D coverage, Coordinate ... coordinates) throws Exception {
        GridGeometry2D gridGeometry = coverage.getGridGeometry();
        RenderedImage renderedImage = coverage.getRenderedImage();
        RandomIter iter = RandomIterFactory.create((RenderedImage)renderedImage, null);
        List<ProfilePoint> profilePointsList = CoverageUtilities.doProfile(iter, gridGeometry, coordinates);
        iter.done();
        return profilePointsList;
    }

    public static List<ProfilePoint> doProfile(RandomIter mapIter, GridGeometry2D gridGeometry, Coordinate ... coordinates) throws TransformException {
        ArrayList<ProfilePoint> profilePointsList = new ArrayList<ProfilePoint>();
        GridEnvelope2D gridRange = gridGeometry.getGridRange2D();
        int rows = gridRange.height;
        int cols = gridRange.width;
        AffineTransform gridToCRS = (AffineTransform)gridGeometry.getGridToCRS();
        double xres = XAffineTransform.getScaleX0((AffineTransform)gridToCRS);
        double yres = XAffineTransform.getScaleY0((AffineTransform)gridToCRS);
        double step = Math.min(xres, yres);
        LineString line = GeometryUtilities.gf().createLineString(coordinates);
        double lineLength = line.getLength();
        LengthIndexedLine indexedLine = new LengthIndexedLine((Geometry)line);
        for (double progressive = 0.0; progressive < lineLength + step; progressive += step) {
            Coordinate c = indexedLine.extractPoint(progressive);
            GridCoordinates2D gridCoords = gridGeometry.worldToGrid((DirectPosition)new DirectPosition2D(c.x, c.y));
            double value = -9999.0;
            if (CoverageUtilities.isInside(cols - 1, rows - 1, gridCoords)) {
                value = mapIter.getSampleDouble(gridCoords.x, gridCoords.y, 0);
            }
            ProfilePoint profilePoint = new ProfilePoint(progressive, value, c.x, c.y);
            profilePointsList.add(profilePoint);
        }
        return profilePointsList;
    }

    private static boolean isInside(int cols, int rows, GridCoordinates2D gridCoords) {
        return gridCoords.x >= 0 && gridCoords.x <= cols && gridCoords.y >= 0 && gridCoords.y <= rows;
    }

    public static Point2D gridToWorld(GridGeometry2D gridGeometry, int x, int y) throws InvalidGridGeometryException, TransformException {
        Point2D.Double worldPosition = new Point2D.Double(x, y);
        gridGeometry.getGridToCRS2D().transform((Point2D)worldPosition, (Point2D)worldPosition);
        return worldPosition;
    }

    public static WritableRaster replaceNovalue(RenderedImage renderedImage, double newValue) {
        WritableRaster tmpWR = (WritableRaster)renderedImage.getData();
        RandomIter pitTmpIterator = RandomIterFactory.create((RenderedImage)renderedImage, null);
        int height = renderedImage.getHeight();
        int width = renderedImage.getWidth();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (!HMConstants.isNovalue(pitTmpIterator.getSampleDouble(x, y, 0))) continue;
                tmpWR.setSample(x, y, 0, newValue);
            }
        }
        pitTmpIterator.done();
        return tmpWR;
    }

    public static ROI prepareROI(Geometry roi, AffineTransform mt2d) throws Exception {
        Geometry rasterSpaceGeometry = JTS.transform((Geometry)roi, (MathTransform)new AffineTransform2D(mt2d.createInverse()));
        Geometry simplifiedGeometry = DouglasPeuckerSimplifier.simplify((Geometry)rasterSpaceGeometry, (double)1.0);
        return new ROIShape((Shape)((Object)new FastLiteShape(simplifiedGeometry)));
    }

    public static boolean isGrass(String path) {
        File file = new File(path);
        File cellFolderFile = file.getParentFile();
        File mapsetFile = cellFolderFile.getParentFile();
        File windFile = new File(mapsetFile, "WIND");
        return cellFolderFile.getName().toLowerCase().equals("cell") && windFile.exists();
    }

    public static int[] colRowFromCoordinate(Coordinate coordinate, GridGeometry2D gridGeometry, Point point) {
        try {
            DirectPosition2D pos = new DirectPosition2D(coordinate.x, coordinate.y);
            GridCoordinates2D worldToGrid = gridGeometry.worldToGrid((DirectPosition)pos);
            if (point != null) {
                point.x = worldToGrid.x;
                point.y = worldToGrid.y;
            }
            return new int[]{worldToGrid.x, worldToGrid.y};
        }
        catch (InvalidGridGeometryException e) {
            e.printStackTrace();
        }
        catch (TransformException e) {
            e.printStackTrace();
        }
        point.x = Integer.MAX_VALUE;
        point.y = Integer.MAX_VALUE;
        return null;
    }

    public static Coordinate coordinateFromColRow(int col, int row, GridGeometry2D gridGeometry) {
        try {
            GridCoordinates2D pos = new GridCoordinates2D(col, row);
            DirectPosition gridToWorld = gridGeometry.gridToWorld(pos);
            double[] coord = gridToWorld.getCoordinate();
            return new Coordinate(coord[0], coord[1]);
        }
        catch (InvalidGridGeometryException e) {
            e.printStackTrace();
        }
        catch (TransformException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static GridCoverage2D coverageValuesMapper(GridCoverage2D valuesMap, GridCoverage2D maskMap) {
        RegionMap valuesRegionMap = CoverageUtilities.getRegionParamsFromGridCoverage(valuesMap);
        int cs = valuesRegionMap.getCols();
        int rs = valuesRegionMap.getRows();
        RegionMap maskRegionMap = CoverageUtilities.getRegionParamsFromGridCoverage(maskMap);
        int tmpcs = maskRegionMap.getCols();
        int tmprs = maskRegionMap.getRows();
        if (cs != tmpcs || rs != tmprs) {
            throw new IllegalArgumentException("The raster maps have to be of equal size to be mapped.");
        }
        RandomIter valuesIter = RandomIterFactory.create((RenderedImage)valuesMap.getRenderedImage(), null);
        RandomIter maskIter = RandomIterFactory.create((RenderedImage)maskMap.getRenderedImage(), null);
        WritableRaster writableRaster = CoverageUtilities.createWritableRaster(cs, rs, null, null, -9999.0);
        WritableRandomIter outIter = RandomIterFactory.createWritable((WritableRaster)writableRaster, null);
        for (int r = 0; r < rs; ++r) {
            for (int c = 0; c < cs; ++c) {
                double value;
                if (HMConstants.isNovalue(maskIter.getSampleDouble(c, r, 0)) || HMConstants.isNovalue(value = valuesIter.getSampleDouble(c, r, 0))) continue;
                outIter.setSample(c, r, 0, value);
            }
        }
        GridCoverage2D outCoverage = CoverageUtilities.buildCoverage("mapped", writableRaster, (HashMap<String, Double>)maskRegionMap, valuesMap.getCoordinateReferenceSystem());
        return outCoverage;
    }

    public static GridCoverage2D mergeCoverages(GridCoverage2D valuesMap, GridCoverage2D onMap) {
        RegionMap valuesRegionMap = CoverageUtilities.getRegionParamsFromGridCoverage(valuesMap);
        int cs = valuesRegionMap.getCols();
        int rs = valuesRegionMap.getRows();
        RegionMap onRegionMap = CoverageUtilities.getRegionParamsFromGridCoverage(onMap);
        int tmpcs = onRegionMap.getCols();
        int tmprs = onRegionMap.getRows();
        if (cs != tmpcs || rs != tmprs) {
            throw new IllegalArgumentException("The raster maps have to be of equal size to be mapped.");
        }
        RandomIter valuesIter = RandomIterFactory.create((RenderedImage)valuesMap.getRenderedImage(), null);
        WritableRaster outWR = CoverageUtilities.renderedImage2WritableRaster(onMap.getRenderedImage(), false);
        WritableRandomIter outIter = RandomIterFactory.createWritable((WritableRaster)outWR, null);
        for (int r = 0; r < rs; ++r) {
            for (int c = 0; c < cs; ++c) {
                double value = valuesIter.getSampleDouble(c, r, 0);
                if (HMConstants.isNovalue(value)) continue;
                outIter.setSample(c, r, 0, value);
            }
        }
        GridCoverage2D outCoverage = CoverageUtilities.buildCoverage("merged", outWR, (HashMap<String, Double>)onRegionMap, valuesMap.getCoordinateReferenceSystem());
        return outCoverage;
    }

    public static GridCoverage2D sumCoverages(GridCoverage2D gc1, GridCoverage2D gc2) {
        RegionMap gc1RegionMap = CoverageUtilities.getRegionParamsFromGridCoverage(gc1);
        int c1 = gc1RegionMap.getCols();
        int r1 = gc1RegionMap.getRows();
        RegionMap gc2RegionMap = CoverageUtilities.getRegionParamsFromGridCoverage(gc2);
        int c2 = gc2RegionMap.getCols();
        int r2 = gc2RegionMap.getRows();
        if (c1 != c2 || r1 != r2) {
            throw new IllegalArgumentException("The raster maps have to be of equal size to be mapped.");
        }
        RandomIter gc1Iter = RandomIterFactory.create((RenderedImage)gc1.getRenderedImage(), null);
        WritableRaster outWR = CoverageUtilities.renderedImage2WritableRaster(gc2.getRenderedImage(), false);
        WritableRandomIter gc2Iter = RandomIterFactory.createWritable((WritableRaster)outWR, null);
        double nv1 = HMConstants.getNovalue(gc1);
        for (int r = 0; r < r1; ++r) {
            for (int c = 0; c < c1; ++c) {
                double v1 = gc1Iter.getSampleDouble(c, r, 0);
                double v2 = gc2Iter.getSampleDouble(c, r, 0);
                if (HMConstants.isNovalue(v1, nv1)) continue;
                double newV = v1 + v2;
                gc2Iter.setSample(c, r, 0, newV);
            }
        }
        GridCoverage2D outCoverage = CoverageUtilities.buildCoverage("merged", outWR, (HashMap<String, Double>)gc2RegionMap, gc1.getCoordinateReferenceSystem());
        return outCoverage;
    }

    public static double[][] calculateHypsographic(GridCoverage2D elevationCoverage, int bins, IHMProgressMonitor pm) {
        if (pm == null) {
            pm = new DummyProgressMonitor();
        }
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(elevationCoverage);
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        double xres = regionMap.getXres();
        double yres = regionMap.getYres();
        RandomIter elevIter = CoverageUtilities.getRandomIterator(elevationCoverage);
        double maxRasterValue = Double.NEGATIVE_INFINITY;
        double minRasterValue = Double.POSITIVE_INFINITY;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                double value = elevIter.getSampleDouble(c, r, 0);
                if (HMConstants.isNovalue(value)) continue;
                maxRasterValue = Math.max(maxRasterValue, value);
                minRasterValue = Math.min(minRasterValue, value);
            }
        }
        double binWidth = (maxRasterValue - minRasterValue) / (double)bins;
        double[] pixelPerBinCount = new double[bins];
        double[] areaAtGreaterElevation = new double[bins];
        pm.beginTask("Performing calculation of hypsographic curve...", rows);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                double value = elevIter.getSampleDouble(c, r, 0);
                if (HMConstants.isNovalue(value)) continue;
                for (int k = 0; k < pixelPerBinCount.length; ++k) {
                    double thres = minRasterValue + (double)k * binWidth;
                    if (!(value >= thres)) continue;
                    pixelPerBinCount[k] = pixelPerBinCount[k] + 1.0;
                    areaAtGreaterElevation[k] = areaAtGreaterElevation[k] + yres * xres;
                }
            }
            pm.worked(1);
        }
        pm.done();
        double[][] hypso = new double[pixelPerBinCount.length][3];
        for (int j = 0; j < hypso.length; ++j) {
            hypso[j][0] = minRasterValue + (double)j * binWidth + binWidth / 2.0;
            hypso[j][1] = areaAtGreaterElevation[j] / 1000000.0;
        }
        return hypso;
    }

    public static double getValue(GridCoverage2D raster, int col, int row) {
        double[] values = null;
        try {
            values = raster.evaluate(new GridCoordinates2D(col, row), (double[])null);
        }
        catch (Exception e) {
            return -9999.0;
        }
        return values[0];
    }

    public static double getValue(GridCoverage2D raster, double easting, double northing) {
        double[] values = null;
        try {
            values = raster.evaluate((Point2D)new Point2D.Double(easting, northing), (double[])null);
        }
        catch (Exception e) {
            return -9999.0;
        }
        return values[0];
    }

    public static double getValue(GridCoverage2D raster, Coordinate coordinate) {
        return CoverageUtilities.getValue(raster, coordinate.x, coordinate.y);
    }

    public static GridCoverage2D invert(GridCoverage2D raster, double max) {
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(raster);
        int nCols = regionMap.getCols();
        int nRows = regionMap.getRows();
        RandomIter rasterIter = CoverageUtilities.getRandomIterator(raster);
        WritableRaster outWR = CoverageUtilities.createWritableRaster(nCols, nRows, null, null, -9999.0);
        WritableRandomIter outIter = RandomIterFactory.createWritable((WritableRaster)outWR, null);
        for (int r = 0; r < nRows; ++r) {
            for (int c = 0; c < nCols; ++c) {
                double value = rasterIter.getSampleDouble(c, r, 0);
                if (HMConstants.isNovalue(value)) continue;
                outIter.setSample(c, r, 0, max - value);
            }
        }
        GridCoverage2D invertedRaster = CoverageUtilities.buildCoverage("inverted", outWR, (HashMap<String, Double>)regionMap, raster.getCoordinateReferenceSystem());
        return invertedRaster;
    }

    public static boolean equals(WritableRaster wr1, WritableRaster wr2) {
        int w1 = wr1.getWidth();
        int h1 = wr1.getHeight();
        int w2 = wr2.getWidth();
        int h2 = wr2.getHeight();
        if (w1 != w2 || h1 != h2) {
            return false;
        }
        for (int c = 0; c < w1; ++c) {
            for (int r = 0; r < h1; ++r) {
                double v1 = wr1.getSampleDouble(c, r, 0);
                double v2 = wr2.getSampleDouble(c, r, 0);
                if (HMConstants.isNovalue(v1) && HMConstants.isNovalue(v2) || NumericsUtilities.dEq(v1, v2)) continue;
                return false;
            }
        }
        return true;
    }

    public static void writeWorldFiles(GridCoverage2D coverage, String outPath) throws Exception {
        String ext = ".tfw";
        if (outPath.toLowerCase().endsWith("tif") || outPath.toLowerCase().endsWith("tiff")) {
            ext = ".tfw";
        } else if (outPath.toLowerCase().endsWith("png")) {
            ext = ".pgw";
        } else if (outPath.toLowerCase().endsWith("jpg")) {
            ext = ".jgw";
        } else if (outPath.toLowerCase().endsWith("gif")) {
            ext = ".gfw";
        }
        RegionMap rm = CoverageUtilities.gridGeometry2RegionParamsMap(coverage.getGridGeometry());
        double dx = (rm.getEast() - rm.getWest()) / (double)rm.getCols();
        double dy = (rm.getNorth() - rm.getSouth()) / (double)rm.getRows();
        StringBuilder sb = new StringBuilder();
        sb.append(dx).append("\n");
        sb.append("0.00000000").append("\n");
        sb.append("0.00000000").append("\n");
        sb.append(-dy).append("\n");
        sb.append(rm.getWest()).append("\n");
        sb.append(rm.getNorth()).append("\n");
        File outFile = new File(outPath);
        String fileName = FileUtilities.getNameWithoutExtention(outFile);
        File folder = outFile.getParentFile();
        File tfwFile = new File(folder, fileName + ext);
        FileUtilities.writeFile(sb.toString(), tfwFile);
        File prjFile = new File(folder, fileName + ".prj");
        FileUtilities.writeFile(coverage.getCoordinateReferenceSystem().toWKT(), prjFile);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Polygon> gridcoverageToCellPolygons(GridCoverage2D coverage, Predicate<Coordinate> keepCoordinatePredicate, boolean doIncrementalMerge, IHMProgressMonitor pm) {
        if (pm == null) {
            pm = new DummyProgressMonitor();
        }
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(coverage);
        double west = regionMap.getWest();
        double north = regionMap.getNorth();
        double xres = regionMap.getXres();
        double yres = regionMap.getYres();
        int cols = regionMap.getCols();
        int rows = regionMap.getRows();
        int everyRows = 1000;
        GeometryFactory gf = GeometryUtilities.gf();
        RandomIter iter = CoverageUtilities.getRandomIterator(coverage);
        ArrayList<Polygon> bigPolygons = new ArrayList<Polygon>();
        ArrayList<Object> polygons = new ArrayList<Polygon>();
        pm.beginTask("Vectorizing raster cells...", rows);
        for (int r = 0; r < rows; ++r) {
            void var21_19;
            boolean bl = false;
            while (var21_19 < cols) {
                double w = west + xres * (double)var21_19;
                double e = w + xres;
                double n = north - yres * (double)r;
                double s = n - yres;
                if (keepCoordinatePredicate == null || keepCoordinatePredicate.test(new Coordinate(w + xres / 2.0, s + yres / 2.0))) {
                    Coordinate[] coords = new Coordinate[]{new Coordinate(w, n), new Coordinate(e, n), new Coordinate(e, s), new Coordinate(w, s), new Coordinate(w, n)};
                    LinearRing linearRing = gf.createLinearRing(coords);
                    Polygon polygon = gf.createPolygon(linearRing, null);
                    polygons.add(polygon);
                    double value = iter.getSampleDouble((int)var21_19, r, 0);
                    polygon.setUserData((Object)value);
                }
                ++var21_19;
            }
            if (doIncrementalMerge && (r > 0 && r % everyRows == 0 || r == rows - 1)) {
                Map<Integer, List<Geometry>> map = polygons.parallelStream().filter(poly -> ((Number)poly.getUserData()).doubleValue() != -9999.0).collect(Collectors.groupingBy(poly -> ((Number)poly.getUserData()).intValue()));
                pm.message(r + " of " + rows);
                polygons = new ArrayList();
                int size = map.size();
                int count = 0;
                for (Map.Entry<Integer, List<Geometry>> entry : map.entrySet()) {
                    if (++count % 10 == 0) {
                        pm.message("   -> " + count + " of " + size);
                    }
                    Integer basinId = entry.getKey();
                    List<Geometry> value = entry.getValue();
                    Geometry tmpGeom = CascadedPolygonUnion.union(value);
                    for (int i = 0; i < tmpGeom.getNumGeometries(); ++i) {
                        Polygon geometryN = (Polygon)tmpGeom.getGeometryN(i);
                        geometryN.setUserData((Object)basinId);
                        bigPolygons.add(geometryN);
                    }
                }
            }
            pm.worked(1);
        }
        pm.done();
        if (doIncrementalMerge) {
            polygons = new ArrayList();
            for (Geometry geometry : bigPolygons) {
                Object userData = geometry.getUserData();
                for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                    Polygon geometryN = (Polygon)geometry.getGeometryN(i);
                    geometryN.setUserData(userData);
                    polygons.add(geometryN);
                }
            }
        }
        return polygons;
    }

    public static List<Coordinate> extractPolygonOnCoverage(RandomIter coverageIterator, int cols, int rows, double xRes, GridGeometry2D gridGeometry, Polygon polygon, double defaultValue) throws Exception {
        GeometryFactory gf = GeometryUtilities.gf();
        PreparedGeometry preparedGeometry = PreparedGeometryFactory.prepare((Geometry)polygon);
        double delta = xRes / 4.0;
        ArrayList<Coordinate> coordinatesList = new ArrayList<Coordinate>();
        for (int r = 0; r < rows; ++r) {
            double[] westPos = gridGeometry.gridToWorld(new GridCoordinates2D(0, r)).getCoordinate();
            double[] eastPos = gridGeometry.gridToWorld(new GridCoordinates2D(cols - 1, r)).getCoordinate();
            Coordinate west = new Coordinate(westPos[0], westPos[1]);
            Coordinate east = new Coordinate(eastPos[0], eastPos[1]);
            LineString line = gf.createLineString(new Coordinate[]{west, east});
            if (!preparedGeometry.intersects((Geometry)line)) continue;
            Geometry internalLines = polygon.intersection((Geometry)line);
            int lineNums = internalLines.getNumGeometries();
            for (int l = 0; l < lineNums; ++l) {
                Coordinate[] coords = internalLines.getGeometryN(l).getCoordinates();
                if (coords.length == 2) {
                    for (int j = 0; j < coords.length; j += 2) {
                        DirectPosition2D endDP;
                        DirectPosition2D startDP;
                        Coordinate startC = new Coordinate(coords[j].x + delta, coords[j].y);
                        Coordinate endC = new Coordinate(coords[j + 1].x - delta, coords[j + 1].y);
                        if (startC.x < endC.x) {
                            startDP = new DirectPosition2D(startC.x, startC.x);
                            endDP = new DirectPosition2D(endC.x, endC.x);
                        } else {
                            startDP = new DirectPosition2D(endC.x, endC.x);
                            endDP = new DirectPosition2D(startC.x, startC.x);
                        }
                        GridCoordinates2D startGridCoord = gridGeometry.worldToGrid((DirectPosition)startDP);
                        GridCoordinates2D endGridCoord = gridGeometry.worldToGrid((DirectPosition)endDP);
                        for (int k = startGridCoord.x; k <= endGridCoord.x; ++k) {
                            double v = defaultValue;
                            if (coverageIterator != null) {
                                v = coverageIterator.getSampleDouble(k, r, 0);
                            }
                            double[] xy = gridGeometry.gridToWorld(new GridCoordinates2D(k, r)).getCoordinate();
                            Coordinate coordinate = new Coordinate(xy[0], xy[1], v);
                            coordinatesList.add(coordinate);
                        }
                    }
                    continue;
                }
                if (coords.length == 1) {
                    throw new ModelsIOException(MessageFormat.format("Found a cusp in: {0}/{1}", coords[0].x, coords[0].y), "FeatureUtilities");
                }
                throw new ModelsIOException(MessageFormat.format("Found intersection with more than 2 points in: {0}/{1}", coords[0].x, coords[0].y), "FeatureUtilities");
            }
        }
        return coordinatesList;
    }

    public static Double getNovalue(GridCoverage2D raster) {
        NoDataContainer noDataProperty = org.geotools.coverage.util.CoverageUtilities.getNoDataProperty((GridCoverage2D)raster);
        if (noDataProperty != null) {
            double noValue = noDataProperty.getAsSingleValue();
            return noValue;
        }
        return null;
    }
}

