/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.features;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.LiteShape;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;

public final class FastLiteShape
extends LiteShape {
    PreparedGeometry prepared;
    LiteCoordinateSequence pointCS;
    Point point;
    LiteCoordinateSequence rectCS;
    Polygon rect;

    public FastLiteShape(Geometry geom) {
        super(geom, new AffineTransform(), false);
        this.prepared = PreparedGeometryFactory.prepare((Geometry)geom);
        GeometryFactory gf = new GeometryFactory();
        this.pointCS = new LiteCoordinateSequence(1, 2);
        this.point = gf.createPoint((CoordinateSequence)this.pointCS);
        this.rectCS = new LiteCoordinateSequence(5, 2);
        this.rect = gf.createPolygon(gf.createLinearRing((CoordinateSequence)this.rectCS), null);
    }

    public boolean contains(double x, double y) {
        this.pointCS.setX(0, x);
        this.pointCS.setY(0, y);
        this.point.geometryChanged();
        boolean result = this.prepared.contains((Geometry)this.point);
        return result;
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(double x, double y, double w, double h) {
        this.updateRect(x, y, w, h);
        return this.prepared.contains((Geometry)this.rect);
    }

    private void updateRect(double x, double y, double w, double h) {
        this.rectCS.setX(0, x);
        this.rectCS.setY(0, y);
        this.rectCS.setX(1, x + w);
        this.rectCS.setY(1, y);
        this.rectCS.setX(2, x + w);
        this.rectCS.setY(2, y + h);
        this.rectCS.setX(3, x);
        this.rectCS.setY(3, y + h);
        this.rectCS.setX(4, x);
        this.rectCS.setY(4, y);
        this.rect.geometryChanged();
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean intersects(double x, double y, double w, double h) {
        this.updateRect(x, y, w, h);
        return this.prepared.intersects((Geometry)this.rect);
    }

    public boolean intersects(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }
}

