/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.features;

import java.util.ArrayList;
import java.util.List;
import org.hortonmachine.gears.utils.geometry.EGeometryType;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class FeatureMate {
    private final SimpleFeature feature;
    private Geometry geometry;
    private PreparedGeometry preparedGeometry;
    private Envelope envelope;

    public FeatureMate(SimpleFeature feature) {
        this.feature = feature;
    }

    public SimpleFeature getFeature() {
        return this.feature;
    }

    public void useBuffer(double buffer) {
        Geometry tmpGeometry = this.getGeometry();
        this.geometry = tmpGeometry.buffer(buffer);
    }

    public Geometry getGeometry() {
        if (this.geometry == null) {
            this.geometry = (Geometry)this.feature.getDefaultGeometry();
        }
        return this.geometry;
    }

    public Envelope getEnvelope() {
        if (this.envelope == null) {
            this.envelope = this.getGeometry().getEnvelopeInternal();
        }
        return this.envelope;
    }

    public List<String> getAttributesNames() {
        SimpleFeatureType featureType = this.feature.getFeatureType();
        List attributeDescriptors = featureType.getAttributeDescriptors();
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (AttributeDescriptor attributeDescriptor : attributeDescriptors) {
            String name = attributeDescriptor.getLocalName();
            attributeNames.add(name);
        }
        return attributeNames;
    }

    public <T> T getAttribute(String attrName, Class<T> adaptee) {
        Object attribute;
        if (attrName == null) {
            return null;
        }
        if (adaptee == null) {
            adaptee = String.class;
        }
        if ((attribute = this.feature.getAttribute(attrName)) == null) {
            return null;
        }
        if (attribute instanceof Number) {
            Number num = (Number)attribute;
            if (adaptee.isAssignableFrom(Double.class)) {
                return (T)adaptee.cast(num.doubleValue());
            }
            if (adaptee.isAssignableFrom(Float.class)) {
                return (T)adaptee.cast(Float.valueOf(num.floatValue()));
            }
            if (adaptee.isAssignableFrom(Integer.class)) {
                return (T)adaptee.cast(num.intValue());
            }
            if (adaptee.isAssignableFrom(Long.class)) {
                return (T)adaptee.cast(num.longValue());
            }
            if (adaptee.isAssignableFrom(String.class)) {
                return (T)adaptee.cast(num.toString());
            }
            throw new IllegalArgumentException();
        }
        if (attribute instanceof String) {
            if (adaptee.isAssignableFrom(Double.class)) {
                try {
                    Double parsed = Double.parseDouble((String)attribute);
                    return (T)adaptee.cast(parsed);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (adaptee.isAssignableFrom(Float.class)) {
                try {
                    Float parsed = Float.valueOf(Float.parseFloat((String)attribute));
                    return (T)adaptee.cast(parsed);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (adaptee.isAssignableFrom(Integer.class)) {
                try {
                    Integer parsed = Integer.parseInt((String)attribute);
                    return (T)adaptee.cast(parsed);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (adaptee.isAssignableFrom(String.class)) {
                return (T)adaptee.cast(attribute);
            }
            throw new IllegalArgumentException();
        }
        if (attribute instanceof Geometry) {
            return null;
        }
        throw new IllegalArgumentException("Can't adapt attribute of type: " + attribute.getClass().getCanonicalName());
    }

    public boolean intersects(Geometry geometry, boolean usePrepared) {
        if (!this.getEnvelope().intersects(geometry.getEnvelopeInternal())) {
            return false;
        }
        if (usePrepared) {
            if (this.preparedGeometry == null) {
                this.preparedGeometry = PreparedGeometryFactory.prepare((Geometry)this.getGeometry());
            }
            return this.preparedGeometry.intersects(geometry);
        }
        return this.getGeometry().intersects(geometry);
    }

    public boolean covers(Geometry geometry, boolean usePrepared) {
        if (!this.getEnvelope().covers(geometry.getEnvelopeInternal())) {
            return false;
        }
        if (usePrepared) {
            if (this.preparedGeometry == null) {
                this.preparedGeometry = PreparedGeometryFactory.prepare((Geometry)this.getGeometry());
            }
            return this.preparedGeometry.covers(geometry);
        }
        return this.getGeometry().covers(geometry);
    }

    public Geometry intersection(Geometry geometry) {
        return this.getGeometry().intersection(geometry);
    }

    public void convertToLine() throws IllegalArgumentException {
        EGeometryType geometryType = EGeometryType.forGeometry(this.getGeometry());
        switch (geometryType) {
            case MULTIPOLYGON: 
            case POLYGON: {
                Coordinate[] tmpCoords = this.geometry.getCoordinates();
                this.geometry = GeometryUtilities.gf().createLineString(tmpCoords);
                this.preparedGeometry = null;
                break;
            }
            case LINESTRING: 
            case MULTILINESTRING: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Points not supported");
            }
        }
    }

    public void convertToPoint() {
        EGeometryType geometryType = EGeometryType.forGeometry(this.getGeometry());
        switch (geometryType) {
            case MULTIPOLYGON: 
            case POLYGON: 
            case LINESTRING: 
            case MULTILINESTRING: {
                Coordinate[] tmpCoords = this.geometry.getCoordinates();
                this.geometry = GeometryUtilities.gf().createMultiPoint(tmpCoords);
                this.preparedGeometry = null;
                break;
            }
        }
    }

    public void resetGeometry() {
        this.geometry = null;
        this.preparedGeometry = null;
    }

    public String toString() {
        List<String> attributesNames = this.getAttributesNames();
        StringBuilder sb = new StringBuilder();
        sb.append("FeatureMate: [\n");
        sb.append("\t").append("the_geom").append(" = ").append(this.getGeometry()).append("\n");
        for (String name : attributesNames) {
            if (name.equals("the_geom")) continue;
            String attribute = this.getAttribute(name, String.class);
            sb.append("\t").append(name).append(" = ").append(attribute).append("\n");
        }
        sb.append("]\n");
        return sb.toString();
    }
}

