/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.files;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.hortonmachine.gears.libs.exceptions.ModelsIOException;
import org.hortonmachine.gears.utils.PreferencesHandler;

public class FileUtilities {
    public static void copyFile(String fromFile, String toFile) throws IOException {
        Files.copy(Paths.get(fromFile, new String[0]), Paths.get(toFile, new String[0]), new CopyOption[0]);
    }

    public static void copyFile(File in, File out) throws IOException {
        FileUtilities.copyFile(in.getAbsolutePath(), out.getAbsolutePath());
    }

    public static long getCreationTimestamp(String path) throws IOException {
        Path pathObj = Paths.get(path, new String[0]);
        BasicFileAttributes attr = Files.readAttributes(pathObj, BasicFileAttributes.class, new LinkOption[0]);
        return attr.creationTime().toMillis();
    }

    public static boolean deleteFileOrDir(File filehandle) throws IOException {
        boolean isdel;
        if (filehandle.isDirectory()) {
            Files.walkFileTree(Paths.get(filehandle.getAbsolutePath(), new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc != null) {
                        throw exc;
                    }
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        if (!(isdel = filehandle.delete())) {
            filehandle.deleteOnExit();
        }
        return isdel;
    }

    public static byte[] readFileToBytes(String filePath) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        byte[] bytes = Files.readAllBytes(path);
        return bytes;
    }

    public static String readInputStreamToString(InputStream inputStream) throws IOException {
        ArrayList<Byte> bytesList = new ArrayList<Byte>();
        byte b = 0;
        while ((b = (byte)inputStream.read()) != -1) {
            bytesList.add(b);
        }
        inputStream.close();
        byte[] bArray = new byte[bytesList.size()];
        for (int i = 0; i < bArray.length; ++i) {
            bArray[i] = (Byte)bytesList.get(i);
        }
        String file = new String(bArray);
        return file;
    }

    public static String readFile(String filePath) throws IOException {
        return FileUtilities.readFile(new File(filePath));
    }

    public static String readFile(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("The required projection file is not available: " + file.getAbsolutePath());
        }
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            StringBuilder sb = new StringBuilder(200);
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }

    public static List<String> readFileToLinesList(String filePath) throws IOException {
        return FileUtilities.readFileToLinesList(new File(filePath));
    }

    public static List<String> readFileToLinesList(File file) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
    }

    public static void writeFile(String text, File file) throws IOException {
        String shpCharset = PreferencesHandler.getShpCharset();
        if (shpCharset != null) {
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName(shpCharset)));){
                bw.write(text);
            }
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
            bw.write(text);
        }
    }

    public static void writeFile(List<String> lines, String filePath) throws IOException {
        FileUtilities.writeFile(lines, new File(filePath));
    }

    public static void writeFile(List<String> lines, File file) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
            for (String line : lines) {
                bw.write(line);
                bw.write("\n");
            }
        }
    }

    public static String replaceBackSlashes(String path) {
        return path.replaceAll("\\\\", "\\\\\\\\");
    }

    public static String replaceBackSlashesWithSlashes(String string) {
        if (string != null) {
            string = string.replaceAll("\\\\", "/").replaceAll("\\\\\\\\", "/");
        }
        return string;
    }

    public static String getNameWithoutExtention(File file) {
        String name = file.getName();
        int lastDot = name.lastIndexOf(".");
        if (lastDot == -1) {
            return name;
        }
        name = name.substring(0, lastDot);
        return name;
    }

    public static File substituteExtention(File file, String newExtention) {
        Object path = file.getAbsolutePath();
        int lastDot = ((String)path).lastIndexOf(".");
        path = lastDot == -1 ? (String)path + "." + newExtention : ((String)path).substring(0, lastDot) + "." + newExtention;
        return new File((String)path);
    }

    public static String getSafeFileName(String fileName) {
        String[] reservedWindows;
        char[] notAllowed = new char[]{'/', '>', '<', ':', '\"', '/', '\\', '|', '?', '*'};
        char escape = '_';
        int len = fileName.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch = fileName.charAt(i);
            boolean trapped = false;
            char[] cArray = notAllowed;
            int n = cArray.length;
            for (int j = 0; j < n; ++j) {
                char forbidden = cArray[j];
                if (ch != forbidden) continue;
                sb.append(escape);
                trapped = true;
                break;
            }
            if (trapped) continue;
            sb.append(ch);
        }
        Object newName = sb.toString();
        if (((String)(newName = ((String)newName).trim())).endsWith(".")) {
            newName = ((String)newName).substring(0, ((String)newName).length() - 1);
        }
        for (String reservedWin : reservedWindows = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"}) {
            if (!((String)newName).equals(reservedWin)) continue;
            newName = (String)newName + "_";
            break;
        }
        return newName;
    }

    public static LinkedHashMap<String, String> readFileToHashMap(String filePath, String separator, boolean valueFirst) throws IOException {
        if (separator == null) {
            separator = "=";
        }
        List<String> lines = FileUtilities.readFileToLinesList(filePath);
        LinkedHashMap<String, String> propertiesMap = new LinkedHashMap<String, String>();
        for (String line : lines) {
            String value;
            String key;
            if ((line = line.trim()).length() == 0 || !line.contains(separator)) continue;
            String[] lineSplit = line.split(separator);
            if (!valueFirst) {
                key = lineSplit[0].trim();
                value = "";
                if (lineSplit.length > 1) {
                    value = lineSplit[1].trim();
                }
                propertiesMap.put(key, value);
                continue;
            }
            if (lineSplit.length <= 1) continue;
            key = lineSplit[0].trim();
            value = lineSplit[1].trim();
            propertiesMap.put(value, key);
        }
        return propertiesMap;
    }

    public static File stringAsTmpFile(String string) throws Exception {
        File tempFile = File.createTempFile("jgt-", "txt");
        FileUtilities.writeFile(string, tempFile);
        return tempFile;
    }

    public static File stringListAsTmpFile(List<String> list) throws Exception {
        File tempFile = File.createTempFile("jgt-", "txt");
        FileUtilities.writeFile(list, tempFile);
        return tempFile;
    }

    public static File[] getFilesListByExtention(String folderPath, final String ext) {
        File[] files = new File(folderPath).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(ext);
            }
        });
        return files;
    }

    public static void folderCheckMakeOrDie(String path) throws ModelsIOException {
        if (path != null) {
            File file = new File(path);
            if (!file.exists() && !file.mkdirs()) {
                throw new ModelsIOException("Unable to create folder: " + path, "FileUtilities");
            }
        } else {
            throw new ModelsIOException("Cannot create folder on null path.", "FileUtilities");
        }
    }
}

