/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.geometry;

import org.hortonmachine.dbs.datatypes.ESpatialiteGeometryType;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;

public enum EGeometryType {
    POINT(Point.class, MultiPoint.class),
    MULTIPOINT(MultiPoint.class, MultiPoint.class),
    LINESTRING(LineString.class, MultiLineString.class),
    MULTILINESTRING(MultiLineString.class, MultiLineString.class),
    POLYGON(Polygon.class, MultiPolygon.class),
    MULTIPOLYGON(MultiPolygon.class, MultiPolygon.class),
    GEOMETRYCOLLECTION(GeometryCollection.class, GeometryCollection.class),
    UNKNOWN(null, null);

    private Class<?> clazz;
    private Class<?> multiClazz;

    private EGeometryType(Class<?> clazz, Class<?> multiClazz) {
        this.clazz = clazz;
        this.multiClazz = multiClazz;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Class<?> getMultiClazz() {
        return this.multiClazz;
    }

    public static EGeometryType forClass(Class<?> clazz) {
        if (POINT.getClazz().isAssignableFrom(clazz)) {
            return POINT;
        }
        if (MULTIPOINT.getClazz().isAssignableFrom(clazz)) {
            return MULTIPOINT;
        }
        if (LINESTRING.getClazz().isAssignableFrom(clazz)) {
            return LINESTRING;
        }
        if (MULTILINESTRING.getClazz().isAssignableFrom(clazz)) {
            return MULTILINESTRING;
        }
        if (POLYGON.getClazz().isAssignableFrom(clazz)) {
            return POLYGON;
        }
        if (MULTIPOLYGON.getClazz().isAssignableFrom(clazz)) {
            return MULTIPOLYGON;
        }
        if (GEOMETRYCOLLECTION.getClazz().isAssignableFrom(clazz)) {
            return GEOMETRYCOLLECTION;
        }
        return null;
    }

    public boolean isMulti() {
        switch (this) {
            case MULTILINESTRING: 
            case MULTIPOINT: 
            case MULTIPOLYGON: {
                return true;
            }
        }
        return false;
    }

    public boolean isCompatibleWith(EGeometryType geometryType) {
        switch (geometryType) {
            case LINESTRING: {
                return this == LINESTRING;
            }
            case MULTILINESTRING: {
                return this == LINESTRING || this == MULTILINESTRING;
            }
            case POINT: {
                return this == POINT;
            }
            case MULTIPOINT: {
                return this == POINT || this == MULTIPOINT;
            }
            case POLYGON: {
                return this == POLYGON;
            }
            case MULTIPOLYGON: {
                return this == POLYGON || this == MULTIPOLYGON;
            }
        }
        return false;
    }

    public static EGeometryType forGeometry(Geometry geometry) {
        if (geometry instanceof LineString) {
            return LINESTRING;
        }
        if (geometry instanceof MultiLineString) {
            return MULTILINESTRING;
        }
        if (geometry instanceof Point) {
            return POINT;
        }
        if (geometry instanceof MultiPoint) {
            return MULTIPOINT;
        }
        if (geometry instanceof Polygon) {
            return POLYGON;
        }
        if (geometry instanceof MultiPolygon) {
            return MULTIPOLYGON;
        }
        if (geometry instanceof GeometryCollection) {
            return GEOMETRYCOLLECTION;
        }
        return null;
    }

    public static EGeometryType forGeometryType(GeometryType geometryType) {
        Class binding = geometryType.getBinding();
        if (binding == LineString.class) {
            return LINESTRING;
        }
        if (binding == MultiLineString.class) {
            return MULTILINESTRING;
        }
        if (binding == Point.class) {
            return POINT;
        }
        if (binding == MultiPoint.class) {
            return MULTIPOINT;
        }
        if (binding == Polygon.class) {
            return POLYGON;
        }
        if (binding == MultiPolygon.class) {
            return MULTIPOLYGON;
        }
        return null;
    }

    public static EGeometryType forGeometryDescriptor(GeometryDescriptor geometryDescriptor) {
        return EGeometryType.forGeometryType(geometryDescriptor.getType());
    }

    public static EGeometryType forWktName(String wktName) {
        if (wktName.equalsIgnoreCase(POINT.name())) {
            return POINT;
        }
        if (wktName.equalsIgnoreCase(MULTIPOINT.name())) {
            return MULTIPOINT;
        }
        if (wktName.equalsIgnoreCase(LINESTRING.name())) {
            return LINESTRING;
        }
        if (wktName.equalsIgnoreCase(MULTILINESTRING.name())) {
            return MULTILINESTRING;
        }
        if (wktName.equalsIgnoreCase(POLYGON.name())) {
            return POLYGON;
        }
        if (wktName.equalsIgnoreCase(MULTIPOLYGON.name())) {
            return MULTIPOLYGON;
        }
        if (wktName.equalsIgnoreCase(GEOMETRYCOLLECTION.name())) {
            return GEOMETRYCOLLECTION;
        }
        return UNKNOWN;
    }

    public static boolean isLine(Geometry geometry) {
        return geometry instanceof LineString || geometry instanceof MultiLineString;
    }

    public static boolean isLine(GeometryDescriptor geometryDescriptor) {
        GeometryType type = geometryDescriptor.getType();
        Class binding = type.getBinding();
        return binding == MultiLineString.class || binding == LineString.class;
    }

    public static boolean isPolygon(Geometry geometry) {
        return geometry instanceof Polygon || geometry instanceof MultiPolygon;
    }

    public static boolean isPolygon(GeometryDescriptor geometryDescriptor) {
        GeometryType type = geometryDescriptor.getType();
        Class binding = type.getBinding();
        return binding == MultiPolygon.class || binding == Polygon.class;
    }

    public static boolean isPoint(Geometry geometry) {
        return geometry instanceof Point || geometry instanceof MultiPoint;
    }

    public static boolean isPoint(GeometryDescriptor geometryDescriptor) {
        GeometryType type = geometryDescriptor.getType();
        Class binding = type.getBinding();
        return binding == MultiPoint.class || binding == Point.class;
    }

    public ESpatialiteGeometryType toSpatialiteGeometryType() {
        switch (this) {
            case LINESTRING: {
                return ESpatialiteGeometryType.LINESTRING_XY;
            }
            case MULTILINESTRING: {
                return ESpatialiteGeometryType.MULTILINESTRING_XY;
            }
            case POINT: {
                return ESpatialiteGeometryType.POINT_XY;
            }
            case MULTIPOINT: {
                return ESpatialiteGeometryType.MULTIPOINT_XY;
            }
            case POLYGON: {
                return ESpatialiteGeometryType.POLYGON_XY;
            }
            case MULTIPOLYGON: {
                return ESpatialiteGeometryType.MULTIPOLYGON_XY;
            }
            case GEOMETRYCOLLECTION: {
                return ESpatialiteGeometryType.GEOMETRYCOLLECTION_XY;
            }
        }
        return null;
    }
}

