/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.images;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.gce.grassraster.GrassCoverageReader;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.GridReaderLayer;
import org.geotools.map.MapContent;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.WebMapServer;
import org.geotools.ows.wms.map.WMSLayer;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.hortonmachine.gears.io.rasterreader.OmsRasterReader;
import org.hortonmachine.gears.libs.monitor.DummyProgressMonitor;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.gears.utils.RegionMap;
import org.hortonmachine.gears.utils.SldUtilities;
import org.hortonmachine.gears.utils.colors.ColorUtilities;
import org.hortonmachine.gears.utils.coverage.CoverageUtilities;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.hortonmachine.gears.utils.geometry.GeometryUtilities;
import org.hortonmachine.gears.utils.images.EPaperFormat;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class ImageGenerator {
    private String wmsURL = null;
    private List<String> featurePaths = new ArrayList<String>();
    private List<String> featureFilter = new ArrayList<String>();
    private List<String> coveragePaths = new ArrayList<String>();
    private List<GridGeometry2D> coverageRegions = new ArrayList<GridGeometry2D>();
    private StyleFactory sf;
    private IHMProgressMonitor monitor = new DummyProgressMonitor();
    private List<org.geotools.map.Layer> layers = new ArrayList<org.geotools.map.Layer>();
    private List<org.geotools.map.Layer> synchronizedLayers = null;
    private MapContent content;
    private StreamingRenderer renderer;
    private File shapesFile;
    private CoordinateReferenceSystem forceCrs;

    public ImageGenerator(IHMProgressMonitor monitor, CoordinateReferenceSystem forceCrs) {
        this.forceCrs = forceCrs;
        if (monitor != null) {
            this.monitor = monitor;
        }
        this.sf = CommonFactoryFinder.getStyleFactory(null);
    }

    public void addCoveragePath(String coveragePath) {
        if (!this.coveragePaths.contains(coveragePath)) {
            this.coveragePaths.add(coveragePath);
        }
    }

    public void addCoverageRegion(GridGeometry2D coverageRegion) {
        if (!this.coverageRegions.contains(coverageRegion)) {
            this.coverageRegions.add(coverageRegion);
        }
    }

    public void setWMS(String wmsURL) {
        this.wmsURL = wmsURL;
    }

    public void addFeaturePath(String featurePath, String filter) {
        if (!this.featurePaths.contains(featurePath)) {
            this.featurePaths.add(featurePath);
            if (filter == null) {
                filter = "";
            }
            this.featureFilter.add(filter);
        }
    }

    public void addShapesPath(String shapesPath) {
        this.shapesFile = new File(shapesPath);
    }

    public ReferencedEnvelope setLayers() throws Exception {
        GridCoverageLayer layer;
        Style style;
        File styleFile;
        ReferencedEnvelope maxExtent = null;
        if (this.wmsURL != null) {
            String[] split = this.wmsURL.split("#");
            WebMapServer server = new WebMapServer(new URL(split[0]));
            Layer wmsLayer = this.getWMSLayer(server, split[1]);
            WMSLayer layer2 = new WMSLayer(server, wmsLayer);
            this.layers.add((org.geotools.map.Layer)layer2);
            ReferencedEnvelope originalEnvelope = layer2.getBounds();
            if (originalEnvelope != null) {
                if (maxExtent == null) {
                    maxExtent = new ReferencedEnvelope(originalEnvelope.getCoordinateReferenceSystem());
                }
                this.expandToIncludeEnvelope(maxExtent, (org.opengis.geometry.Envelope)originalEnvelope);
            }
        }
        this.monitor.beginTask("Reading raster maps...", this.coveragePaths.size());
        for (int r = 0; r < this.coveragePaths.size(); ++r) {
            String coveragePath = this.coveragePaths.get(r);
            GridGeometry2D region = null;
            if (this.coverageRegions != null && this.coverageRegions.size() == this.coveragePaths.size()) {
                region = this.coverageRegions.get(r);
            }
            File file = new File(coveragePath);
            GridCoverage2D raster = null;
            AbstractGridCoverage2DReader reader = null;
            try {
                try {
                    AbstractGridFormat format = GridFormatFinder.findFormat((Object)file);
                    reader = format.getReader((Object)file);
                    if (reader instanceof GrassCoverageReader) {
                        reader = null;
                    }
                }
                catch (Exception format) {
                    // empty catch block
                }
                if (reader == null) {
                    if (region == null) {
                        raster = OmsRasterReader.readRaster(coveragePath);
                    } else {
                        RegionMap regionMap = CoverageUtilities.gridGeometry2RegionParamsMap(region);
                        double n = regionMap.getNorth();
                        double s = regionMap.getSouth();
                        double w = regionMap.getWest();
                        double e = regionMap.getEast();
                        double xres = regionMap.getXres();
                        double yres = regionMap.getYres();
                        OmsRasterReader rreader = new OmsRasterReader();
                        rreader.file = coveragePath;
                        rreader.pNorth = n;
                        rreader.pSouth = s;
                        rreader.pWest = w;
                        rreader.pEast = e;
                        rreader.pXres = xres;
                        rreader.pYres = yres;
                        rreader.process();
                        raster = rreader.outRaster;
                    }
                }
            }
            catch (Exception e) {
                this.monitor.errorMessage(e.getLocalizedMessage());
                this.monitor.errorMessage("Trying to find other coverage source...");
                AbstractGridFormat format = GridFormatFinder.findFormat((Object)file);
                reader = format.getReader((Object)file);
            }
            styleFile = FileUtilities.substituteExtention(file, "sld");
            style = styleFile.exists() ? SldUtilities.getStyleFromFile(styleFile) : SldUtilities.getStyleFromRasterFile(styleFile);
            if (raster != null) {
                layer = new GridCoverageLayer(raster, style);
                this.layers.add((org.geotools.map.Layer)layer);
                org.opengis.geometry.Envelope envelope = raster.getEnvelope();
                if (maxExtent == null) {
                    maxExtent = new ReferencedEnvelope(envelope.getCoordinateReferenceSystem());
                }
                this.expandToIncludeEnvelope(maxExtent, envelope);
            }
            if (reader != null) {
                layer = new GridReaderLayer((GridCoverage2DReader)reader, style);
                this.layers.add((org.geotools.map.Layer)layer);
                GeneralEnvelope envelope = reader.getOriginalEnvelope();
                if (maxExtent == null) {
                    maxExtent = new ReferencedEnvelope(envelope.getCoordinateReferenceSystem());
                }
                this.expandToIncludeEnvelope(maxExtent, (org.opengis.geometry.Envelope)envelope);
            }
            this.monitor.worked(1);
        }
        this.monitor.done();
        this.monitor.beginTask("Reading vector maps...", this.featurePaths.size());
        for (int i = 0; i < this.featurePaths.size(); ++i) {
            String featurePath = this.featurePaths.get(i);
            String filter = this.featureFilter.get(i);
            FileDataStore store = FileDataStoreFinder.getDataStore((File)new File(featurePath));
            SimpleFeatureSource featureSource = store.getFeatureSource();
            SimpleFeatureCollection featureCollection = filter.length() == 0 ? featureSource.getFeatures() : featureSource.getFeatures(ECQL.toFilter((String)filter));
            styleFile = FileUtilities.substituteExtention(new File(featurePath), "sld");
            style = styleFile.exists() ? SldUtilities.getStyleFromFile(styleFile) : SLD.createSimpleStyle((FeatureType)featureSource.getSchema());
            layer = new FeatureLayer((FeatureCollection)featureCollection, style);
            this.layers.add((org.geotools.map.Layer)layer);
            if (maxExtent == null) {
                maxExtent = new ReferencedEnvelope(((SimpleFeatureType)featureCollection.getSchema()).getCoordinateReferenceSystem());
            }
            this.expandToIncludeEnvelope(maxExtent, (org.opengis.geometry.Envelope)featureCollection.getBounds());
            this.monitor.worked(1);
        }
        this.synchronizedLayers = Collections.synchronizedList(this.layers);
        this.monitor.done();
        return maxExtent;
    }

    private void expandToIncludeEnvelope(ReferencedEnvelope maxExtent, org.opengis.geometry.Envelope envelope) {
        ReferencedEnvelope tmpExtent = new ReferencedEnvelope(envelope.getCoordinateReferenceSystem());
        DirectPosition ll = envelope.getLowerCorner();
        double[] coordinate = ll.getCoordinate();
        tmpExtent.expandToInclude(new Coordinate(coordinate[0], coordinate[1]));
        DirectPosition ur = envelope.getUpperCorner();
        coordinate = ur.getCoordinate();
        tmpExtent.expandToInclude(new Coordinate(coordinate[0], coordinate[1]));
        try {
            ReferencedEnvelope transformed = tmpExtent.transform(maxExtent.getCoordinateReferenceSystem(), true);
            maxExtent.expandToInclude((Envelope)transformed);
        }
        catch (FactoryException | TransformException e) {
            e.printStackTrace();
        }
    }

    private Layer getWMSLayer(WebMapServer server, String layerName) {
        for (Layer layer : server.getCapabilities().getLayerList()) {
            if (!layerName.equals(layer.getName())) continue;
            return layer;
        }
        throw new IllegalArgumentException("Could not find layer " + layerName);
    }

    private synchronized void checkMapContent() {
        if (this.content == null) {
            this.content = new MapContent();
            this.content.setTitle("dump");
            for (org.geotools.map.Layer layer : this.layers) {
                this.content.addLayer(layer);
            }
            this.renderer = new StreamingRenderer();
            this.renderer.setMapContent(this.content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage drawImage(ReferencedEnvelope ref, int imageWidth, int imageHeight, double buffer) {
        this.checkMapContent();
        if (buffer > 0.0) {
            ref.expandBy(buffer, buffer);
        }
        Rectangle2D.Double refRect = new Rectangle2D.Double(ref.getMinX(), ref.getMinY(), ref.getWidth(), ref.getHeight());
        Rectangle2D.Double imageRect = new Rectangle2D.Double(0.0, 0.0, imageWidth, imageHeight);
        GeometryUtilities.scaleToRatio(imageRect, refRect, false);
        ReferencedEnvelope newRef = new ReferencedEnvelope((Rectangle2D)refRect, ref.getCoordinateReferenceSystem());
        Rectangle imageBounds = new Rectangle(0, 0, imageWidth, imageHeight);
        BufferedImage dumpImage = new BufferedImage(imageWidth, imageHeight, 1);
        Graphics2D g2d = dumpImage.createGraphics();
        g2d.fillRect(0, 0, imageWidth, imageHeight);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        StreamingRenderer streamingRenderer = this.renderer;
        synchronized (streamingRenderer) {
            this.renderer.paint(g2d, imageBounds, newRef);
        }
        return dumpImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawImage(Graphics2D g2d, ReferencedEnvelope ref, int imageWidth, int imageHeight, double buffer) {
        this.checkMapContent();
        if (buffer > 0.0) {
            ref.expandBy(buffer, buffer);
        }
        Rectangle2D.Double refRect = new Rectangle2D.Double(ref.getMinX(), ref.getMinY(), ref.getWidth(), ref.getHeight());
        Rectangle2D.Double imageRect = new Rectangle2D.Double(0.0, 0.0, imageWidth, imageHeight);
        GeometryUtilities.scaleToRatio(imageRect, refRect, false);
        ReferencedEnvelope newRef = new ReferencedEnvelope((Rectangle2D)refRect, ref.getCoordinateReferenceSystem());
        Rectangle imageBounds = new Rectangle(0, 0, imageWidth, imageHeight);
        Color white = Color.white;
        g2d.setColor(new Color(white.getRed(), white.getGreen(), white.getBlue(), 0));
        g2d.fillRect(0, 0, imageWidth, imageHeight);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        StreamingRenderer streamingRenderer = this.renderer;
        synchronized (streamingRenderer) {
            this.content.getViewport().setBounds(newRef);
            this.renderer.paint(g2d, imageBounds, newRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage drawImageWithNewMapContent(ReferencedEnvelope ref, int imageWidth, int imageHeight, double buffer) {
        double delta;
        double envH;
        double envW;
        MapContent content = new MapContent();
        content.setTitle("dump");
        if (this.forceCrs != null) {
            content.getViewport().setCoordinateReferenceSystem(this.forceCrs);
            content.getViewport().setBounds(ref);
        }
        List<org.geotools.map.Layer> list = this.synchronizedLayers;
        synchronized (list) {
            for (org.geotools.map.Layer layer : this.synchronizedLayers) {
                content.addLayer(layer);
            }
        }
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(content);
        if (buffer > 0.0) {
            ref = new ReferencedEnvelope(ref);
            ref.expandBy(buffer, buffer);
        }
        if ((envW = ref.getWidth()) < (envH = ref.getHeight())) {
            double newEnvW = envH * (double)imageWidth / (double)imageHeight;
            delta = newEnvW - envW;
            ref.expandBy(delta / 2.0, 0.0);
        } else {
            double newEnvH = envW * (double)imageHeight / (double)imageWidth;
            delta = newEnvH - envH;
            ref.expandBy(0.0, delta / 2.0);
        }
        Rectangle imageBounds = new Rectangle(0, 0, imageWidth, imageHeight);
        BufferedImage dumpImage = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics2D g2d = dumpImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderer.paint(g2d, imageBounds, ref);
        return dumpImage;
    }

    public void dispose() {
        if (this.content != null) {
            this.content.dispose();
        }
    }

    public void dumpPngImage(String imagePath, ReferencedEnvelope bounds, int imageWidth, int imageHeight, double buffer, int[] rgbCheck) throws IOException {
        BufferedImage dumpImage = this.drawImageWithNewMapContent(bounds, imageWidth, imageHeight, buffer);
        boolean dumpIt = true;
        if (rgbCheck != null) {
            boolean bl = dumpIt = !this.isAllOfCheckColor(rgbCheck, dumpImage);
        }
        if (dumpIt) {
            ImageIO.write((RenderedImage)dumpImage, "png", new File(imagePath));
        }
    }

    public void dumpJpgImage(String imagePath, ReferencedEnvelope bounds, int imageWidth, int imageHeight, double buffer, int[] rgbCheck) throws IOException {
        BufferedImage dumpImage = this.drawImageWithNewMapContent(bounds, imageWidth, imageHeight, buffer);
        boolean dumpIt = true;
        if (rgbCheck != null) {
            boolean bl = dumpIt = !this.isAllOfCheckColor(rgbCheck, dumpImage);
        }
        if (dumpIt) {
            ImageIO.write((RenderedImage)dumpImage, "jpg", new File(imagePath));
        }
    }

    public BufferedImage getImageWithCheck(ReferencedEnvelope bounds, int imageWidth, int imageHeight, double buffer, int[] rgbCheck) throws IOException {
        BufferedImage dumpImage = this.drawImageWithNewMapContent(bounds, imageWidth, imageHeight, buffer);
        boolean dumpIt = true;
        if (rgbCheck != null) {
            boolean bl = dumpIt = !this.isAllOfCheckColor(rgbCheck, dumpImage);
        }
        if (dumpIt) {
            return dumpImage;
        }
        return null;
    }

    private boolean isAllOfCheckColor(int[] rgbCheck, BufferedImage dumpImage) {
        WritableRaster raster = dumpImage.getRaster();
        for (int i = 0; i < raster.getWidth(); ++i) {
            for (int j = 0; j < raster.getHeight(); ++j) {
                int[] value = raster.getPixel(i, j, (int[])null);
                if (value[0] == rgbCheck[0] && value[1] == rgbCheck[1] && value[2] == rgbCheck[2]) continue;
                return false;
            }
        }
        return true;
    }

    public void dumpPngImageForScaleAndPaper(String imagePath, ReferencedEnvelope bounds, double scale, EPaperFormat paperFormat, Double dpi, BufferedImage legend, int legendX, int legendY, String scalePrefix, float scaleSize, int scaleX, int scaleY) throws Exception {
        if (dpi == null) {
            dpi = 72.0;
        }
        Coordinate centre = bounds.centre();
        double boundsXExtension = (double)paperFormat.width() / 1000.0 * scale;
        double boundsYExtension = (double)paperFormat.height() / 1000.0 * scale;
        Coordinate ll = new Coordinate(centre.x - boundsXExtension / 2.0, centre.y - boundsYExtension / 2.0);
        Coordinate ur = new Coordinate(centre.x + boundsXExtension / 2.0, centre.y + boundsYExtension / 2.0);
        Envelope tmpEnv = new Envelope(ll, ur);
        bounds = new ReferencedEnvelope(tmpEnv, bounds.getCoordinateReferenceSystem());
        int imageWidth = (int)((double)paperFormat.width() / 25.4 * dpi);
        int imageHeight = (int)((double)paperFormat.height() / 25.4 * dpi);
        BufferedImage dumpImage = this.drawImage(bounds, imageWidth, imageHeight, 0.0);
        Graphics2D graphics = (Graphics2D)dumpImage.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.shapesFile != null && this.shapesFile.exists()) {
            this.applyShapes(graphics);
        }
        if (legend != null) {
            graphics.drawImage(legend, null, legendX, legendY);
        }
        if (scalePrefix != null) {
            Font scaleFont = graphics.getFont().deriveFont(scaleSize);
            graphics.setFont(scaleFont);
            FontMetrics fontMetrics = graphics.getFontMetrics(scaleFont);
            String scaleString = scalePrefix + "1:" + (int)scale;
            Rectangle2D stringBounds = fontMetrics.getStringBounds(scaleString, graphics);
            double width = stringBounds.getWidth();
            double height = stringBounds.getHeight();
            graphics.setColor(Color.white);
            double border = 5.0;
            graphics.fillRect(scaleX, (int)((double)scaleY - height + 2.0 * border), (int)(width + 3.0 * border), (int)(height + 2.0 * border));
            graphics.setColor(Color.black);
            graphics.drawString(scaleString, scaleX + 5, scaleY);
        }
        ImageIO.write((RenderedImage)dumpImage, "png", new File(imagePath));
    }

    public void dump2Graphics2D(Graphics2D graphics2d, ReferencedEnvelope bounds, double scale, EPaperFormat paperFormat, Double dpi, BufferedImage legend, int legendX, int legendY, String scalePrefix, float scaleSize, int scaleX, int scaleY) throws Exception {
        if (dpi == null) {
            dpi = 72.0;
        }
        Coordinate centre = bounds.centre();
        double boundsXExtension = (double)paperFormat.width() / 1000.0 * scale;
        double boundsYExtension = (double)paperFormat.height() / 1000.0 * scale;
        Coordinate ll = new Coordinate(centre.x - boundsXExtension / 2.0, centre.y - boundsYExtension / 2.0);
        Coordinate ur = new Coordinate(centre.x + boundsXExtension / 2.0, centre.y + boundsYExtension / 2.0);
        Envelope tmpEnv = new Envelope(ll, ur);
        bounds = new ReferencedEnvelope(tmpEnv, bounds.getCoordinateReferenceSystem());
        int imageWidth = (int)((double)paperFormat.width() / 25.4 * dpi);
        int imageHeight = (int)((double)paperFormat.height() / 25.4 * dpi);
        this.drawImage(graphics2d, bounds, imageWidth, imageHeight, 0.0);
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.shapesFile != null && this.shapesFile.exists()) {
            this.applyShapes(graphics2d);
        }
        if (legend != null) {
            graphics2d.drawImage(legend, null, legendX, legendY);
        }
        if (scalePrefix != null) {
            Font scaleFont = graphics2d.getFont().deriveFont(scaleSize);
            graphics2d.setFont(scaleFont);
            FontMetrics fontMetrics = graphics2d.getFontMetrics(scaleFont);
            String scaleString = scalePrefix + "1:" + (int)scale;
            Rectangle2D stringBounds = fontMetrics.getStringBounds(scaleString, graphics2d);
            double width = stringBounds.getWidth();
            double height = stringBounds.getHeight();
            graphics2d.setColor(Color.white);
            double border = 5.0;
            graphics2d.fillRect(scaleX, (int)((double)scaleY - height + 2.0 * border), (int)(width + 3.0 * border), (int)(height + 2.0 * border));
            graphics2d.setColor(Color.black);
            graphics2d.drawString(scaleString, scaleX + 5, scaleY);
        }
    }

    private void applyShapes(Graphics2D graphics) throws Exception {
        Stream<String> lines = Files.lines(Paths.get(this.shapesFile.toURI())).distinct().filter(l -> l.trim().length() != 0);
        lines.forEach(l -> {
            if (l.startsWith("text")) {
                String[] split = l.split(";");
                int x = Integer.parseInt(split[1]);
                int y = Integer.parseInt(split[2]);
                String msg = split[3];
                Color color = ColorUtilities.colorFromRbgString(split[4]);
                int size = Integer.parseInt(split[5]);
                graphics.setColor(color);
                graphics.setFont(new Font("Arial", 0, size));
                graphics.drawString(msg, x, y);
            } else if (l.startsWith("box")) {
                String[] split = l.split(";");
                int x = Integer.parseInt(split[1]);
                int y = Integer.parseInt(split[2]);
                int w = Integer.parseInt(split[3]);
                int h = Integer.parseInt(split[4]);
                int strokeWidth = Integer.parseInt(split[5]);
                Color colorFill = ColorUtilities.colorFromRbgString(split[6]);
                Color colorStroke = ColorUtilities.colorFromRbgString(split[7]);
                graphics.setColor(colorFill);
                graphics.fillRect(x, y, w, h);
                BasicStroke stroke = new BasicStroke(strokeWidth);
                graphics.setStroke(stroke);
                graphics.setColor(colorStroke);
                graphics.drawRect(x, y, w, h);
            } else if (l.startsWith("roundedbox")) {
                String[] split = l.split(";");
                int x = Integer.parseInt(split[1]);
                int y = Integer.parseInt(split[2]);
                int w = Integer.parseInt(split[3]);
                int h = Integer.parseInt(split[4]);
                int round = Integer.parseInt(split[5]);
                int strokeWidth = Integer.parseInt(split[6]);
                Color colorFill = ColorUtilities.colorFromRbgString(split[7]);
                Color colorStroke = ColorUtilities.colorFromRbgString(split[8]);
                graphics.setColor(colorFill);
                graphics.fillRoundRect(x, y, w, h, round, round);
                BasicStroke stroke = new BasicStroke(strokeWidth);
                graphics.setStroke(stroke);
                graphics.setColor(colorStroke);
                graphics.drawRoundRect(x, y, w, h, round, round);
            }
        });
    }
}

