/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.images;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Hashtable;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.processing.Operations;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.parameter.Parameter;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ImageUtilities {
    public static BufferedImage scaleImage(BufferedImage image, int newSize) throws Exception {
        int height;
        int width;
        int imageHeight;
        int imageWidth = image.getWidth();
        if (imageWidth > (imageHeight = image.getHeight())) {
            width = newSize;
            height = imageHeight * width / imageWidth;
        } else {
            height = newSize;
            width = height * imageWidth / imageHeight;
        }
        BufferedImage resizedImage = new BufferedImage(width, height, 1);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(image, 0, 0, width, height, null);
        g.dispose();
        return resizedImage;
    }

    public static BufferedImage rotateImageByDegrees(BufferedImage img, double angle) {
        double rads = Math.toRadians(angle);
        double sin = Math.abs(Math.sin(rads));
        double cos = Math.abs(Math.cos(rads));
        int w = img.getWidth();
        int h = img.getHeight();
        int newWidth = (int)Math.floor((double)w * cos + (double)h * sin);
        int newHeight = (int)Math.floor((double)h * cos + (double)w * sin);
        BufferedImage rotated = new BufferedImage(newWidth, newHeight, 2);
        Graphics2D g2d = rotated.createGraphics();
        AffineTransform at = new AffineTransform();
        at.translate((newWidth - w) / 2, (newHeight - h) / 2);
        int x = w / 2;
        int y = h / 2;
        at.rotate(rads, x, y);
        g2d.setTransform(at);
        g2d.drawImage((Image)img, 0, 0, null);
        g2d.setColor(Color.RED);
        g2d.drawRect(0, 0, newWidth - 1, newHeight - 1);
        g2d.dispose();
        return rotated;
    }

    public static BufferedImage imageFromReader(AbstractGridCoverage2DReader reader, int cols, int rows, double w, double e, double s, double n, CoordinateReferenceSystem resampleCrs) throws IOException {
        CoordinateReferenceSystem sourceCrs = reader.getCoordinateReferenceSystem();
        GeneralParameterValue[] readParams = new GeneralParameterValue[1];
        Parameter readGG = new Parameter((ParameterDescriptor)AbstractGridFormat.READ_GRIDGEOMETRY2D);
        GridEnvelope2D gridEnvelope = new GridEnvelope2D(0, 0, cols, rows);
        DirectPosition2D minDp = new DirectPosition2D(sourceCrs, w, s);
        DirectPosition2D maxDp = new DirectPosition2D(sourceCrs, e, n);
        Envelope2D env = new Envelope2D(minDp, maxDp);
        readGG.setValue((Object)new GridGeometry2D((GridEnvelope)gridEnvelope, (Envelope)env));
        readParams[0] = readGG;
        GridCoverage2D gridCoverage2D = reader.read(readParams);
        if (gridCoverage2D == null) {
            return null;
        }
        if (resampleCrs != null) {
            gridCoverage2D = (GridCoverage2D)Operations.DEFAULT.resample((Coverage)gridCoverage2D, resampleCrs);
        }
        RenderedImage image = gridCoverage2D.getRenderedImage();
        return ImageUtilities.rendereImage2BufferedImage(image);
    }

    public static BufferedImage makeColorTransparent(BufferedImage bufferedImageToProcess, final Color colorToMakeTransparent) {
        RGBImageFilter filter = new RGBImageFilter(){
            public int markerRGB;
            {
                this.markerRGB = colorToMakeTransparent.getRGB() | 0xFF000000;
            }

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(bufferedImageToProcess.getSource(), filter);
        Image image = Toolkit.getDefaultToolkit().createImage(ip);
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return bufferedImage;
    }

    public static boolean isAllOneColor(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int previousRgb = 0;
        boolean isFirst = true;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int rgb = image.getRGB(x, y);
                if (isFirst) {
                    isFirst = false;
                } else if (rgb != previousRgb) {
                    return false;
                }
                previousRgb = rgb;
            }
        }
        return true;
    }

    public static boolean areEqual(BufferedImage img1, BufferedImage img2) {
        if (img1.getWidth() == img2.getWidth() && img1.getHeight() == img2.getHeight()) {
            for (int x = 0; x < img1.getWidth(); ++x) {
                for (int y = 0; y < img1.getHeight(); ++y) {
                    if (img1.getRGB(x, y) == img2.getRGB(x, y)) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public static BufferedImage rendereImage2BufferedImage(RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            return (BufferedImage)renderedImage;
        }
        ColorModel cm = renderedImage.getColorModel();
        int width = renderedImage.getWidth();
        int height = renderedImage.getHeight();
        WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        String[] keys = renderedImage.getPropertyNames();
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                properties.put(keys[i], renderedImage.getProperty(keys[i]));
            }
        }
        BufferedImage result = new BufferedImage(cm, raster, isAlphaPremultiplied, properties);
        renderedImage.copyData(raster);
        return result;
    }
}

