/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.images;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.hortonmachine.gears.utils.files.FileUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class LineChartGenerator {
    private XYSeriesCollection collection = new XYSeriesCollection();
    private final String xLabel;
    private final String yLabel;
    private static final int IMAGEWIDTH = 500;
    private static final int IMAGEHEIGHT = 300;
    private double max = Double.NEGATIVE_INFINITY;
    private double min = Double.POSITIVE_INFINITY;
    private final String title;

    public LineChartGenerator(String title, String xLabel, String yLabel) {
        this.title = title;
        this.xLabel = xLabel;
        this.yLabel = yLabel;
    }

    public void addDatasetMatrix(double[][] data, String seriesName) {
        int i;
        XYSeries series = new XYSeries((Comparable)((Object)seriesName));
        for (i = 0; i < data.length; ++i) {
            this.max = Math.max(this.max, data[i][1]);
            this.min = Math.min(this.min, data[i][1]);
        }
        for (i = 0; i < data.length; ++i) {
            series.add(data[i][0], data[i][1]);
        }
        this.collection.addSeries(series);
    }

    public void dumpChart(File chartFile, boolean autoRange, boolean withLegend, int imageWidth, int imageHeight) throws IOException {
        JFreeChart chart = ChartFactory.createXYLineChart((String)this.title, (String)this.xLabel, (String)this.yLabel, (XYDataset)this.collection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)withLegend, (boolean)false, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        NumberAxis yAxis = (NumberAxis)plot.getRangeAxis();
        yAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits());
        if (autoRange) {
            double delta = (this.max - this.min) * 0.1;
            yAxis.setRange(this.min - delta, this.max + delta);
        }
        if (!chartFile.getName().endsWith(".png")) {
            chartFile = FileUtilities.substituteExtention(chartFile, "png");
        }
        if (imageWidth == -1) {
            imageWidth = 500;
        }
        if (imageHeight == -1) {
            imageHeight = 300;
        }
        BufferedImage bufferedImage = chart.createBufferedImage(imageWidth, imageHeight);
        ImageIO.write((RenderedImage)bufferedImage, "png", chartFile);
    }
}

