/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.images;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.hortonmachine.dbs.geopackage.GeopackageCommonDb;
import org.hortonmachine.dbs.utils.MercatorUtils;
import org.hortonmachine.gears.utils.images.ImageUtilities;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class TileUtilities {
    public static final Color transparent = new Color(255, 255, 255, 0);

    public static BufferedImage getTileFromDifferentZoomlevel(GeopackageCommonDb gpkgDb, String tableName, int x, int y, int zoom, int tileSize, int otherZoomLevel) throws Exception {
        if (otherZoomLevel > zoom) {
            List tilesAtHigherZoom = MercatorUtils.getTilesAtHigherZoom((int)x, (int)y, (int)zoom, (int)otherZoomLevel, (int)tileSize);
            int delta = otherZoomLevel - zoom;
            int splits = (int)Math.pow(2.0, delta);
            int size = splits * tileSize;
            BufferedImage finalImage = new BufferedImage(size, size, 2);
            Graphics2D g2d = (Graphics2D)finalImage.getGraphics();
            int runningX = 0;
            int runningY = 0;
            boolean hasOne = false;
            for (int[] zxy2 : tilesAtHigherZoom) {
                byte[] tile2 = gpkgDb.getTile(tableName, zxy2[1], zxy2[2], zxy2[0]);
                if (tile2 != null) {
                    hasOne = true;
                    ByteArrayInputStream bais = new ByteArrayInputStream(tile2);
                    BufferedImage img = ImageIO.read(bais);
                    int imageX = runningX * tileSize;
                    int imageY = runningY * tileSize;
                    g2d.drawImage((Image)img, imageX, imageY, null);
                }
                if (++runningX != splits) continue;
                runningX = 0;
                ++runningY;
            }
            if (hasOne) {
                return ImageUtilities.scaleImage(finalImage, tileSize);
            }
        } else {
            Envelope swEnv = MercatorUtils.tileBounds4326((int)x, (int)y, (int)zoom);
            Coordinate centre = swEnv.centre();
            double swx2 = swEnv.getMaxX();
            double swx1 = swEnv.getMinX();
            double swy2 = swEnv.getMaxY();
            double swy1 = swEnv.getMinY();
            int[] zxy3 = MercatorUtils.getTileNumber((double)centre.y, (double)centre.x, (int)otherZoomLevel);
            byte[] tileBytes = gpkgDb.getTile(tableName, zxy3[1], zxy3[2], zxy3[0]);
            if (tileBytes != null) {
                ByteArrayInputStream bais = new ByteArrayInputStream(tileBytes);
                BufferedImage img = ImageIO.read(bais);
                Envelope wEnv = MercatorUtils.tileBounds4326((int)zxy3[1], (int)zxy3[2], (int)zxy3[0]);
                double wx2 = wEnv.getMaxX();
                double wx1 = wEnv.getMinX();
                double wy2 = wEnv.getMaxY();
                double wy1 = wEnv.getMinY();
                double dx = (wx2 - wx1) / (double)tileSize;
                int px1 = (int)Math.round((swx1 - wx1) / dx);
                int px2 = (int)Math.round((swx2 - wx1) / dx);
                double dy = (wy2 - wy1) / (double)(-tileSize);
                int py1 = (int)Math.round((swy2 - wy1) / dy + (double)tileSize);
                int py2 = (int)Math.round((swy1 - wy1) / dy + (double)tileSize);
                BufferedImage finalImage = new BufferedImage(tileSize, tileSize, 2);
                Graphics2D g2d = (Graphics2D)finalImage.getGraphics();
                g2d.drawImage(img, 0, 0, tileSize, tileSize, px1, py1, px2, py2, null);
                g2d.dispose();
                return finalImage;
            }
        }
        return null;
    }
}

