/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.images;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.imageio.ImageIO;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.StyleImpl;
import org.geotools.ows.wms.WMSCapabilities;
import org.geotools.ows.wms.WMSUtils;
import org.geotools.ows.wms.WebMapServer;
import org.geotools.ows.wms.request.GetMapRequest;
import org.geotools.ows.wms.response.GetMapResponse;
import org.geotools.referencing.CRS;
import org.hortonmachine.gears.utils.StringUtilities;
import org.opengis.geometry.Envelope;

public class WmsWrapper {
    private WebMapServer wms = null;
    private WMSCapabilities capabilities;

    public WmsWrapper(String urlString) throws Exception {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.wms = new WebMapServer(url);
    }

    public WMSCapabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = this.wms.getCapabilities();
        }
        return this.capabilities;
    }

    public Layer[] getLayers() {
        Layer[] layers = WMSUtils.getNamedLayers((WMSCapabilities)this.capabilities);
        return layers;
    }

    public List<String> getFormats() {
        return this.getCapabilities().getRequest().getGetMap().getFormats();
    }

    public Layer getLayer(String name) {
        Layer[] layers;
        for (Layer layer : layers = this.getLayers()) {
            if (!layer.getName().equals(name)) continue;
            return layer;
        }
        return null;
    }

    public void printInfo() {
        WMSCapabilities capabilities = this.getCapabilities();
        String serverName = capabilities.getService().getName();
        String serverTitle = capabilities.getService().getTitle();
        System.out.println("Capabilities retrieved from server: " + serverName + " (" + serverTitle + ")");
        Layer[] layers = this.getLayers();
        for (int i = 0; i < layers.length; ++i) {
            System.out.println("=================================================================");
            System.out.println("Layer: (" + i + ")" + layers[i].getName());
            System.out.println("       " + layers[i].getTitle());
            System.out.println("       " + layers[i].getChildren().length);
            Map boundingBoxes = layers[i].getBoundingBoxes();
            System.out.println("-----------------------------------------------------------------");
            System.out.println("Supported CRS and bounds: ");
            for (Map.Entry item : boundingBoxes.entrySet()) {
                String epsg = (String)item.getKey();
                CRSEnvelope crsEnv = (CRSEnvelope)item.getValue();
                System.out.println("\t" + epsg + ": " + crsEnv);
            }
            System.out.println("-----------------------------------------------------------------");
            List styles = layers[i].getStyles();
            System.out.println("Styles:");
            for (StyleImpl elem : styles) {
                System.out.println("  Name:" + elem.getName() + "  Title:" + elem.getTitle());
            }
        }
    }

    public BufferedImage getImage(GetMapRequest request) throws Exception {
        GetMapResponse response = this.wms.issueRequest(request);
        InputStream inputStream = response.getInputStream();
        BufferedImage image = ImageIO.read(inputStream);
        return image;
    }

    public String getMessage(GetMapRequest request) throws Exception {
        GetMapResponse response = this.wms.issueRequest(request);
        InputStream inputStream = response.getInputStream();
        Scanner scanner = StringUtilities.streamToScanner(inputStream, "\n");
        StringBuilder sb = new StringBuilder();
        while (scanner.hasNext()) {
            sb.append(scanner.next()).append("\n");
        }
        return sb.toString();
    }

    public URL getUrl(GetMapRequest request) {
        URL finalURL = request.getFinalURL();
        return finalURL;
    }

    public GetMapRequest getMapRequest(Layer layer, String format, String srs, int imageWidth, int imageHeight, ReferencedEnvelope bbox, String version, StyleImpl style) throws Exception {
        GetMapRequest request = this.wms.createGetMapRequest();
        if (imageWidth < 0) {
            imageWidth = 256;
        }
        if (imageHeight < 0) {
            imageHeight = 256;
        }
        if (format == null) {
            format = "image/png";
        }
        request.setFormat(format);
        request.setDimensions(imageWidth, imageHeight);
        request.setTransparent(true);
        request.setSRS(srs);
        if (version != null) {
            request.setVersion(version);
        }
        request.setBBox((Envelope)bbox);
        if (style != null) {
            request.addLayer(layer, style);
        } else {
            request.addLayer(layer);
        }
        return request;
    }

    public static void main(String[] args) throws Exception {
        Layer[] layers;
        String url = "https://gis.stmk.gv.at/arcgis/services/OGD/als_schummerung/MapServer/WmsServer?request=GetCapabilities&service=WMS";
        String wmscode = "EPSG:4326";
        int width = 1000;
        int height = 1000;
        String outputImage = "/home/hydrologis/TMP/VIENNA/wms.png";
        WmsWrapper ww = new WmsWrapper(url);
        ww.printInfo();
        for (Layer layer : layers = ww.getLayers()) {
            String name = layer.getName();
            if (!name.equals("Digitales_Oberflaechenmodell_DOM")) continue;
            CRSEnvelope latLonBoundingBox = layer.getLatLonBoundingBox();
            double w = latLonBoundingBox.getMinX();
            double e = latLonBoundingBox.getMaxX();
            double s = latLonBoundingBox.getMinY();
            double n = latLonBoundingBox.getMaxY();
            ReferencedEnvelope env = new ReferencedEnvelope(w, e, s, n, CRS.decode((String)"EPSG:4326"));
            ReferencedEnvelope wmsEnv = env.transform(CRS.decode((String)wmscode), false);
            BufferedImage image = ww.getImage(ww.getMapRequest(layer, null, wmscode, width, height, wmsEnv, null, null));
            String format = "jpg";
            if (outputImage.toLowerCase().endsWith("png")) {
                format = "png";
            }
            ImageIO.write((RenderedImage)image, format, new File(outputImage));
            break;
        }
    }
}

