/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.images;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.StyleImpl;
import org.geotools.ows.wmts.WebMapTileServer;
import org.geotools.ows.wmts.model.WMTSCapabilities;
import org.geotools.ows.wmts.model.WMTSLayer;
import org.geotools.ows.wmts.request.GetTileRequest;

public class WmtsWrapper {
    private WebMapTileServer wmts = null;
    private WMTSCapabilities capabilities;

    public WmtsWrapper(String urlString) {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            this.wmts = new WebMapTileServer(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    public WMTSCapabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = this.wmts.getCapabilities();
        }
        return this.capabilities;
    }

    public WMTSLayer[] getLayers() {
        List layerList = this.capabilities.getLayerList();
        WMTSLayer[] layers = layerList.toArray(new WMTSLayer[0]);
        return layers;
    }

    public Layer getLayer(String name) {
        WMTSLayer[] layers;
        for (WMTSLayer layer : layers = this.getLayers()) {
            if (!layer.getName().equals(name)) continue;
            return layer;
        }
        return null;
    }

    public void printInfo() {
        WMTSCapabilities capabilities = this.getCapabilities();
        String serverName = capabilities.getService().getName();
        String serverTitle = capabilities.getService().getTitle();
        System.out.println("Capabilities retrieved from server: " + serverName + " (" + serverTitle + ")");
        WMTSLayer[] layers = this.getLayers();
        for (int i = 0; i < layers.length; ++i) {
            System.out.println("=================================================================");
            System.out.println("Layer: (" + i + ")" + layers[i].getName());
            System.out.println("       " + layers[i].getTitle());
            System.out.println("       " + layers[i].getChildren().length);
            Map boundingBoxes = layers[i].getBoundingBoxes();
            System.out.println("-----------------------------------------------------------------");
            System.out.println("Supported CRS and bounds: ");
            for (Map.Entry item : boundingBoxes.entrySet()) {
                String epsg = (String)item.getKey();
                CRSEnvelope crsEnv = (CRSEnvelope)item.getValue();
                System.out.println("\t" + epsg + ": " + crsEnv);
            }
            System.out.println("-----------------------------------------------------------------");
            List styles = layers[i].getStyles();
            System.out.println("Styles:");
            for (StyleImpl elem : styles) {
                System.out.println("  Name:" + elem.getName() + "  Title:" + elem.getTitle());
            }
        }
    }

    public BufferedImage getImage(WMTSLayer layer, String format, String srs, int imageWidth, int imageHeight, ReferencedEnvelope bbox, String version) throws Exception {
        GetTileRequest request = this.wmts.createGetTileRequest();
        request.setLayer(layer);
        return null;
    }

    public static void main(String[] args) throws Exception {
        WMTSLayer[] layers;
        String url = "https://idt2.regione.veneto.it/gwc/service/wmts?request=GetCapabilities";
        String wmscode = "EPSG:4326";
        int width = 1000;
        int height = 1000;
        String outputImage = "/home/hydrologis/TMP/VIENNA/wms.png";
        WmtsWrapper ww = new WmtsWrapper(url);
        ww.printInfo();
        for (WMTSLayer layer : layers = ww.getLayers()) {
            String string = layer.getName();
        }
    }
}

