/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.math;

import java.util.ArrayList;
import java.util.List;

public class NumericsUtilities {
    private static double MACHINE_D_EPSILON;
    private static float MACHINE_F_EPSILON;
    public static final double D_TOLERANCE;
    public static final float F_TOLERANCE;
    public static final double RADTODEG = 57.29577951308232;
    private static final double[] LANCZOS;
    private static final double HALF_LOG_2_PI;

    public static double getMachineDEpsilon() {
        return MACHINE_D_EPSILON;
    }

    public static float machineFEpsilon() {
        return MACHINE_F_EPSILON;
    }

    public static boolean dEq(double a, double b) {
        if (Double.isNaN(a) && Double.isNaN(b)) {
            return true;
        }
        double diffAbs = Math.abs(a - b);
        return a == b ? true : (diffAbs < D_TOLERANCE ? true : diffAbs / Math.max(Math.abs(a), Math.abs(b)) < D_TOLERANCE);
    }

    public static boolean dEq(double a, double b, double epsilon) {
        if (Double.isNaN(a) && Double.isNaN(b)) {
            return true;
        }
        double diffAbs = Math.abs(a - b);
        return a == b ? true : (diffAbs < epsilon ? true : diffAbs / Math.max(Math.abs(a), Math.abs(b)) < epsilon);
    }

    public static boolean fEq(float a, float b) {
        if (Float.isNaN(a) && Float.isNaN(b)) {
            return true;
        }
        float diffAbs = Math.abs(a - b);
        return a == b ? true : (diffAbs < F_TOLERANCE ? true : diffAbs / Math.max(Math.abs(a), Math.abs(b)) < F_TOLERANCE);
    }

    public static boolean fEq(float a, float b, float epsilon) {
        if (Float.isNaN(a) && Float.isNaN(b)) {
            return true;
        }
        float diffAbs = Math.abs(a - b);
        return a == b ? true : (diffAbs < epsilon ? true : diffAbs / Math.max(Math.abs(a), Math.abs(b)) < epsilon);
    }

    public static <T extends Number> T isNumber(String value, Class<T> adaptee) {
        if (value == null) {
            return null;
        }
        if (adaptee == null) {
            adaptee = Double.class;
        }
        if (adaptee.isAssignableFrom(Double.class)) {
            try {
                Double parsed = Double.parseDouble(value);
                return (T)((Number)adaptee.cast(parsed));
            }
            catch (Exception e) {
                return null;
            }
        }
        if (adaptee.isAssignableFrom(Float.class)) {
            try {
                Float parsed = Float.valueOf(Float.parseFloat(value));
                return (T)((Number)adaptee.cast(parsed));
            }
            catch (Exception e) {
                return null;
            }
        }
        if (adaptee.isAssignableFrom(Integer.class)) {
            try {
                Integer parsed = Integer.parseInt(value);
                return (T)((Number)adaptee.cast(parsed));
            }
            catch (Exception e) {
                try {
                    Integer parsed = (int)Double.parseDouble(value);
                    return (T)((Number)adaptee.cast(parsed));
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public static double pythagoras(double d1, double d2) {
        return Math.sqrt(Math.pow(d1, 2.0) + Math.pow(d2, 2.0));
    }

    public static boolean isBetween(double value, double ... ranges) {
        boolean even = true;
        for (int i = 0; i < ranges.length; ++i) {
            if (even ? value < ranges[i] : value > ranges[i]) {
                return false;
            }
            even = !even;
        }
        return true;
    }

    public static double logGamma(double x) {
        double ret;
        if (Double.isNaN(x) || x <= 0.0) {
            ret = Double.NaN;
        } else {
            double g = 4.7421875;
            double sum = 0.0;
            for (int i = LANCZOS.length - 1; i > 0; --i) {
                sum += LANCZOS[i] / (x + (double)i);
            }
            double tmp = x + g + 0.5;
            ret = (x + 0.5) * Math.log(tmp) - tmp + HALF_LOG_2_PI + Math.log((sum += LANCZOS[0]) / x);
        }
        return ret;
    }

    public static double gamma(double x) {
        return Math.exp(NumericsUtilities.logGamma(x));
    }

    public static double normalize(double max, double min, double value, double normMax) {
        return normMax / (1.0 + (max - value) / (value - min));
    }

    public static List<int[]> getNegativeRanges(double[] x) {
        int firstNegative = -1;
        int lastNegative = -1;
        ArrayList<int[]> rangeList = new ArrayList<int[]>();
        for (int i = 0; i < x.length; ++i) {
            double xValue = x[i];
            if (firstNegative == -1 && xValue < 0.0) {
                firstNegative = i;
            } else if (firstNegative != -1 && lastNegative == -1 && xValue > 0.0) {
                lastNegative = i - 1;
            }
            if (i == x.length - 1 && firstNegative != -1 && lastNegative == -1) {
                lastNegative = i;
            }
            if (firstNegative == -1 || lastNegative == -1) continue;
            rangeList.add(new int[]{firstNegative, lastNegative});
            firstNegative = -1;
            lastNegative = -1;
        }
        return rangeList;
    }

    public static double[] range2Bins(double min, double max, int binsNum) {
        double delta = (max - min) / (double)binsNum;
        double[] bins = new double[binsNum + 1];
        int count = 0;
        double running = min;
        for (int i = 0; i < binsNum; ++i) {
            bins[count] = running;
            running += delta;
            ++count;
        }
        bins[binsNum] = max;
        return bins;
    }

    public static double[] range2Bins(double min, double max, double step, boolean doLastEqual) {
        double intervalsDouble = (max - min) / step;
        int intervals = (int)intervalsDouble;
        double rest = intervalsDouble - (double)intervals;
        if (rest > D_TOLERANCE) {
            ++intervals;
        }
        double[] bins = new double[intervals + 1];
        int count = 0;
        double running = min;
        for (int i = 0; i < intervals; ++i) {
            bins[count] = running;
            running += step;
            ++count;
        }
        bins[intervals] = doLastEqual ? running : max;
        return bins;
    }

    static {
        float fTmp = 0.5f;
        double dTmp = 0.5;
        while (1.0f + fTmp > 1.0f) {
            fTmp /= 2.0f;
        }
        while (1.0 + dTmp > 1.0) {
            dTmp /= 2.0;
        }
        MACHINE_D_EPSILON = dTmp;
        MACHINE_F_EPSILON = fTmp;
        D_TOLERANCE = MACHINE_D_EPSILON * 10.0;
        F_TOLERANCE = MACHINE_F_EPSILON * 10.0f;
        LANCZOS = new double[]{0.9999999999999971, 57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};
        HALF_LOG_2_PI = 0.5 * Math.log(Math.PI * 2);
    }
}

