/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.math.integration;

import org.hortonmachine.gears.libs.modules.ModelsEngine;
import org.hortonmachine.gears.utils.math.integration.IntegrableFunction;
import org.hortonmachine.gears.utils.math.integration.SimpsonIntegral;

public class ConvolutionDiffusionDischarge
extends SimpsonIntegral
implements IntegrableFunction {
    double[][] q = null;
    private double D = 0.0;
    private double t = 0.0;
    private double dist = 0.0;
    private double c = 0.0;

    public ConvolutionDiffusionDischarge(double lowerintegrationlimit, double upperintegrationlimit, int maximalsteps, double integrationaccuracy, double[][] discharge, double diffusionparam, double time, double distance, double celerity) {
        this.lowerlimit = lowerintegrationlimit;
        this.upperlimit = upperintegrationlimit;
        this.maxsteps = maximalsteps;
        this.accuracy = integrationaccuracy;
        this.strapezoid = 0.0;
        this.q = discharge;
        this.D = diffusionparam;
        this.t = time;
        this.c = celerity;
        this.dist = distance;
    }

    public void updateTime(int newt) {
        this.t = newt;
    }

    @Override
    public double integrate() {
        return this.simpson();
    }

    @Override
    protected double equation(double tau) {
        double result = this.t <= tau ? 0.0 : (tau > this.q[this.q.length - 1][0] ? 0.0 : 1.0 / Math.sqrt(Math.PI * 4 * this.D * Math.pow(this.t - tau, 3.0)) * ModelsEngine.widthInterpolate(this.q, tau, 0, 1) * this.dist / Math.exp(Math.pow(this.dist - this.c * (this.t - tau), 2.0) / (4.0 * this.D * (this.t - tau))));
        return result;
    }
}

