/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.math.integration;

import org.hortonmachine.gears.libs.modules.ModelsEngine;
import org.hortonmachine.gears.utils.math.integration.IntegrableFunction;
import org.hortonmachine.gears.utils.math.integration.SimpsonIntegral;

public class ConvolutionDiffusionWidth
extends SimpsonIntegral
implements IntegrableFunction {
    private double[][] ampi_diffusion = null;
    private double D = 0.0;
    private double t = 0.0;

    public ConvolutionDiffusionWidth(double lowerintegrationlimit, double upperintegrationlimit, int maximalsteps, double integrationaccuracy, double[][] ampiFunction, double diffusionparam, double time) {
        this.lowerlimit = lowerintegrationlimit;
        this.upperlimit = upperintegrationlimit;
        this.maxsteps = maximalsteps;
        this.accuracy = integrationaccuracy;
        this.strapezoid = 0.0;
        this.ampi_diffusion = ampiFunction;
        this.D = diffusionparam;
        this.t = time;
    }

    public void updateTime(int newt) {
        this.t = newt;
    }

    @Override
    public double integrate() {
        return this.simpson();
    }

    @Override
    protected double equation(double x) {
        double result = x > this.ampi_diffusion[this.ampi_diffusion.length - 1][0] ? 0.0 : 1.0 / Math.sqrt(Math.PI * 4 * this.D * Math.pow(this.t, 3.0)) * ModelsEngine.widthInterpolate(this.ampi_diffusion, x, 0, 1) * x / Math.exp(Math.pow(x - this.t, 2.0) / (4.0 * this.D * this.t));
        return result;
    }
}

