/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.math.integration;

import org.hortonmachine.gears.utils.math.integration.IntegrableFunction;
import org.hortonmachine.gears.utils.math.integration.SimpsonIntegral;
import org.hortonmachine.gears.utils.math.interpolation.LinearListInterpolator;

public class ConvolutionExponential
extends SimpsonIntegral
implements IntegrableFunction {
    private double k = 0.0;
    private final LinearListInterpolator timeDischargeInterpolator;

    public ConvolutionExponential(double lowerintegrationlimit, double upperintegrationlimit, int maximalsteps, double integrationaccuracy, double invasoConstant, LinearListInterpolator timeDischargeInterpolator) {
        this.lowerlimit = lowerintegrationlimit;
        this.upperlimit = upperintegrationlimit;
        this.maxsteps = maximalsteps;
        this.accuracy = integrationaccuracy;
        this.timeDischargeInterpolator = timeDischargeInterpolator;
        this.strapezoid = 0.0;
        this.k = invasoConstant;
    }

    @Override
    protected double equation(double time) {
        double d = 1.0 / this.k * Math.exp(-(this.upperlimit - time) / this.k) * this.timeDischargeInterpolator.linearInterpolateY(time);
        return d;
    }

    @Override
    public double integrate() {
        return this.simpson();
    }
}

