/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.math.integration;

import org.hortonmachine.gears.libs.modules.ModelsEngine;
import org.hortonmachine.gears.utils.math.integration.IntegrableFunction;
import org.hortonmachine.gears.utils.math.integration.SimpsonIntegral;

public class ConvolutionExponentialPeakflow
extends SimpsonIntegral
implements IntegrableFunction {
    private double k = 0.0;
    private double t = 0.0;
    private final double[][] ampi_sub;

    public ConvolutionExponentialPeakflow(double lowerintegrationlimit, double upperintegrationlimit, int maximalsteps, double integrationaccuracy, double[][] ampifunction, double invasoConstant, double time) {
        this.lowerlimit = lowerintegrationlimit;
        this.upperlimit = upperintegrationlimit;
        this.maxsteps = maximalsteps;
        this.accuracy = integrationaccuracy;
        this.ampi_sub = ampifunction;
        this.strapezoid = 0.0;
        this.k = invasoConstant;
        this.t = time;
    }

    @Override
    protected double equation(double time) {
        double d = 1.0 / this.k * Math.exp(-this.t / this.k) * ModelsEngine.widthInterpolate(this.ampi_sub, time, 0, 1);
        return d;
    }

    @Override
    public double integrate() {
        return this.simpson();
    }
}

