/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.math.interpolation;

import java.util.List;
import org.hortonmachine.gears.utils.math.interpolation.Interpolator;

public class LeastSquaresInterpolator
implements Interpolator {
    private int n;
    private double[][] data;
    private double a0;
    private double a1;
    private double sumX;
    private double sumY;
    private double sumXX;
    private double sumXY;
    private boolean coefsValid;

    public LeastSquaresInterpolator(List<Double> xList, List<Double> yList) {
        int i;
        this.data = new double[xList.size()][xList.size()];
        for (i = 0; i < xList.size(); ++i) {
            this.data[i][0] = xList.get(i);
            this.data[i][1] = yList.get(i);
        }
        for (i = 0; i < this.data.length; ++i) {
            this.addPoint(this.data[i]);
        }
    }

    private void addPoint(double[] dataPoint) {
        if (this.n >= this.data.length) {
            return;
        }
        this.sumX += dataPoint[0];
        this.sumY += dataPoint[1];
        this.sumXX += dataPoint[0] * dataPoint[0];
        this.sumXY += dataPoint[0] * dataPoint[1];
        ++this.n;
        this.coefsValid = false;
    }

    @Override
    public double getInterpolated(double x) {
        if (this.n < 2) {
            return -9999.0;
        }
        this.validateCoefficients();
        return this.a0 + this.a1 * x;
    }

    private void validateCoefficients() {
        if (this.coefsValid) {
            return;
        }
        if (this.n >= 2) {
            double xBar = this.sumX / (double)this.n;
            double yBar = this.sumY / (double)this.n;
            this.a1 = ((double)this.n * this.sumXY - this.sumX * this.sumY) / ((double)this.n * this.sumXX - this.sumX * this.sumX);
            this.a0 = yBar - this.a1 * xBar;
        } else {
            this.a1 = Double.NaN;
            this.a0 = Double.NaN;
        }
        this.coefsValid = true;
    }

    public double getA0() {
        this.validateCoefficients();
        return this.a0;
    }

    public double getA1() {
        this.validateCoefficients();
        return this.a1;
    }

    public double getSumX() {
        return this.sumX;
    }

    public double getSumY() {
        return this.sumY;
    }

    public double getSumXX() {
        return this.sumXX;
    }

    public double getSumXY() {
        return this.sumXY;
    }
}

