/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.math.interpolation;

import org.hortonmachine.gears.utils.math.NumericsUtilities;
import org.hortonmachine.gears.utils.math.interpolation.Interpolator;

public class LinearArrayInterpolator
implements Interpolator {
    private final double[] xList;
    private final double[] yList;
    private boolean isInverse = false;

    public LinearArrayInterpolator(double[] xList, double[] yList) {
        if (xList.length != yList.length) {
            throw new IllegalArgumentException("The arrays have to be of the same length.");
        }
        this.xList = xList;
        this.yList = yList;
    }

    public double linearInterpolateY(double xValue) {
        double first = this.xList[0];
        double last = this.xList[this.xList.length - 1];
        if (first <= last) {
            if (xValue < this.xList[0] || xValue > this.xList[this.xList.length - 1]) {
                return Double.NaN;
            }
            this.isInverse = false;
        } else {
            if (xValue > this.xList[0] || xValue < this.xList[this.xList.length - 1]) {
                return Double.NaN;
            }
            this.isInverse = true;
        }
        for (int i = 0; i < this.xList.length; ++i) {
            double x2 = this.xList[i];
            if (NumericsUtilities.dEq(x2, xValue)) {
                return this.yList[i];
            }
            if (!(!this.isInverse && x2 > xValue) && (!this.isInverse || !(x2 < xValue))) continue;
            double x1 = this.xList[i - 1];
            double y1 = this.yList[i - 1];
            double y2 = this.yList[i];
            double y = (y2 - y1) * (xValue - x1) / (x2 - x1) + y1;
            return y;
        }
        return Double.NaN;
    }

    public double linearInterpolateX(double yValue) {
        double first = this.yList[0];
        double last = this.yList[this.yList.length - 1];
        if (first <= last) {
            if (yValue < this.yList[0] || yValue > this.yList[this.yList.length - 1]) {
                return Double.NaN;
            }
            this.isInverse = false;
        } else {
            if (yValue > this.yList[0] || yValue < this.yList[this.yList.length - 1]) {
                return Double.NaN;
            }
            this.isInverse = true;
        }
        for (int i = 0; i < this.yList.length; ++i) {
            double y2 = this.yList[i];
            if (NumericsUtilities.dEq(y2, yValue)) {
                return this.xList[i];
            }
            if (!(!this.isInverse && y2 > yValue) && (!this.isInverse || !(y2 < yValue))) continue;
            double y1 = this.yList[i - 1];
            double x1 = this.xList[i - 1];
            double x2 = this.xList[i];
            double x = (x2 - x1) * (yValue - y1) / (y2 - y1) + x1;
            return x;
        }
        return Double.NaN;
    }

    @Override
    public double getInterpolated(double x) {
        return this.linearInterpolateY(x);
    }
}

