/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.math.interpolation;

import java.util.List;
import org.hortonmachine.gears.utils.math.interpolation.Interpolator;

public class PolynomialInterpolator
implements Interpolator {
    private int n;
    private double[][] data;
    private double[][] dd;

    public PolynomialInterpolator(List<Double> xList, List<Double> yList) {
        int i;
        this.dd = new double[xList.size()][xList.size()];
        this.data = new double[xList.size()][xList.size()];
        for (i = 0; i < xList.size(); ++i) {
            this.data[i][0] = xList.get(i);
            this.data[i][1] = yList.get(i);
        }
        for (i = 0; i < this.data.length; ++i) {
            this.addPoint(this.data[i]);
        }
    }

    private void addPoint(double[] dataPoint) {
        if (this.n >= this.data.length) {
            return;
        }
        this.dd[this.n][0] = dataPoint[1];
        ++this.n;
        for (int order = 1; order < this.n; ++order) {
            int bottom = this.n - order - 1;
            double numerator = this.dd[bottom + 1][order - 1] - this.dd[bottom][order - 1];
            double denominator = this.data[bottom + order][0] - this.data[bottom][0];
            this.dd[bottom][order] = numerator / denominator;
        }
    }

    @Override
    public double getInterpolated(double x) {
        if (this.n < 2) {
            return -9999.0;
        }
        double y = this.dd[0][0];
        double xFactor = 1.0;
        for (int order = 1; order < this.n; ++order) {
            y += (xFactor *= x - this.data[order - 1][0]) * this.dd[0][order];
        }
        return y;
    }
}

