/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.math.interpolation.splines;

import java.util.ArrayList;
import java.util.List;
import org.hortonmachine.gears.utils.math.interpolation.splines.ControlCurve;
import org.locationtech.jts.geom.Coordinate;

public class Bezier
extends ControlCurve {
    final int STEPS = 12;

    private static double b(int i, double t) {
        switch (i) {
            case 0: {
                return (1.0 - t) * (1.0 - t) * (1.0 - t);
            }
            case 1: {
                return 3.0 * t * (1.0 - t) * (1.0 - t);
            }
            case 2: {
                return 3.0 * t * t * (1.0 - t);
            }
            case 3: {
                return t * t * t;
            }
        }
        return 0.0;
    }

    private Coordinate p(int i, double t) {
        double px = 0.0;
        double py = 0.0;
        for (int j = 0; j <= 3; ++j) {
            Coordinate c = (Coordinate)this.pts.get(i + j);
            px += Bezier.b(j, t) * c.x;
            py += Bezier.b(j, t) * c.y;
        }
        return new Coordinate(px, py);
    }

    @Override
    public List<Coordinate> getInterpolated() {
        ArrayList<Coordinate> coordList = new ArrayList<Coordinate>();
        Coordinate q = this.p(0, 0.0);
        coordList.add(q);
        for (int i = 0; i < this.pts.size() - 3; i += 3) {
            for (int j = 1; j <= 12; ++j) {
                q = this.p(i, (double)j / 12.0);
                coordList.add(q);
            }
        }
        return coordList;
    }
}

