/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.math.matrixes;

import org.hortonmachine.gears.utils.math.matrixes.ColumnVector;
import org.hortonmachine.gears.utils.math.matrixes.IdentityMatrix;
import org.hortonmachine.gears.utils.math.matrixes.LinearSystem;
import org.hortonmachine.gears.utils.math.matrixes.MatrixException;

public class InvertibleMatrix
extends LinearSystem {
    public InvertibleMatrix(int n) {
        super(n);
    }

    public InvertibleMatrix(double[][] values) {
        super(values);
    }

    public InvertibleMatrix inverse() throws MatrixException {
        InvertibleMatrix inverse = new InvertibleMatrix(this.nRows);
        IdentityMatrix identity = new IdentityMatrix(this.nRows);
        for (int c = 0; c < this.nCols; ++c) {
            ColumnVector col = this.solve(identity.getColumn(c), true);
            inverse.setColumn(col, c);
        }
        return inverse;
    }

    public double determinant() throws MatrixException {
        this.decompose();
        double determinant = (this.exchangeCount & 1) == 0 ? 1.0 : -1.0;
        for (int i = 0; i < this.nRows; ++i) {
            int pi = this.permutation[i];
            determinant *= this.LU.at(pi, i);
        }
        return determinant;
    }

    public double norm() {
        double sum = 0.0;
        for (int r = 0; r < this.nRows; ++r) {
            for (int c = 0; c < this.nCols; ++c) {
                double v = this.values[r][c];
                sum += v * v;
            }
        }
        return Math.sqrt(sum);
    }

    public double condition() throws MatrixException {
        return this.norm() * this.inverse().norm();
    }
}

