/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.math.matrixes;

import org.hortonmachine.gears.utils.math.matrixes.ColumnVector;
import org.hortonmachine.gears.utils.math.matrixes.MatrixException;
import org.hortonmachine.gears.utils.math.matrixes.RowVector;

public class Matrix {
    protected int nRows;
    protected int nCols;
    protected double[][] values;

    protected Matrix() {
    }

    public Matrix(int rowCount, int colCount) {
        this.nRows = rowCount > 0 ? rowCount : 1;
        this.nCols = colCount > 0 ? colCount : 1;
        this.values = new double[this.nRows][this.nCols];
    }

    public Matrix(double[][] values) {
        this.set(values);
    }

    public int rowCount() {
        return this.nRows;
    }

    public int columnCount() {
        return this.nCols;
    }

    public double at(int r, int c) throws MatrixException {
        if (r < 0 || r >= this.nRows || c < 0 || c >= this.nCols) {
            throw new MatrixException("Invalid index.");
        }
        return this.values[r][c];
    }

    public RowVector getRow(int r) throws MatrixException {
        if (r < 0 || r >= this.nRows) {
            throw new MatrixException("Invalid index.");
        }
        RowVector rv = new RowVector(this.nCols);
        for (int c = 0; c < this.nCols; ++c) {
            rv.values[0][c] = this.values[r][c];
        }
        return rv;
    }

    public ColumnVector getColumn(int c) throws MatrixException {
        if (c < 0 || c >= this.nCols) {
            throw new MatrixException("Invalid index.");
        }
        ColumnVector cv = new ColumnVector(this.nRows);
        for (int r = 0; r < this.nRows; ++r) {
            cv.values[r][0] = this.values[r][c];
        }
        return cv;
    }

    public double[][] values() {
        return this.values;
    }

    public double[][] copyValues2D() {
        double[][] v = new double[this.nRows][this.nCols];
        for (int r = 0; r < this.nRows; ++r) {
            for (int c = 0; c < this.nCols; ++c) {
                v[r][c] = this.values[r][c];
            }
        }
        return v;
    }

    public void set(int r, int c, double value) throws MatrixException {
        if (r < 0 || r >= this.nRows || c < 0 || c >= this.nCols) {
            throw new MatrixException("Invalid index.");
        }
        this.values[r][c] = value;
    }

    protected void set(double[][] values) {
        this.nRows = values.length;
        this.nCols = values[0].length;
        this.values = values;
        for (int r = 1; r < this.nRows; ++r) {
            this.nCols = Math.min(this.nCols, values[r].length);
        }
    }

    public void setRow(RowVector rv, int r) throws MatrixException {
        if (r < 0 || r >= this.nRows) {
            throw new MatrixException("Invalid index.");
        }
        if (this.nCols != rv.nCols) {
            throw new MatrixException("Invalid matrix dimensions.");
        }
        for (int c = 0; c < this.nCols; ++c) {
            this.values[r][c] = rv.values[0][c];
        }
    }

    public void setColumn(ColumnVector cv, int c) throws MatrixException {
        if (c < 0 || c >= this.nCols) {
            throw new MatrixException("Invalid index.");
        }
        if (this.nRows != cv.nRows) {
            throw new MatrixException("Invalid matrix dimensions.");
        }
        for (int r = 0; r < this.nRows; ++r) {
            this.values[r][c] = cv.values[r][0];
        }
    }

    public Matrix transpose() {
        double[][] tv = new double[this.nCols][this.nRows];
        for (int r = 0; r < this.nRows; ++r) {
            for (int c = 0; c < this.nCols; ++c) {
                tv[c][r] = this.values[r][c];
            }
        }
        return new Matrix(tv);
    }

    public Matrix add(Matrix m) throws MatrixException {
        if (this.nRows != m.nRows && this.nCols != m.nCols) {
            throw new MatrixException("Invalid matrix dimensions.");
        }
        double[][] sv = new double[this.nRows][this.nCols];
        for (int r = 0; r < this.nRows; ++r) {
            for (int c = 0; c < this.nCols; ++c) {
                sv[r][c] = this.values[r][c] + m.values[r][c];
            }
        }
        return new Matrix(sv);
    }

    public Matrix subtract(Matrix m) throws MatrixException {
        if (this.nRows != m.nRows && this.nCols != m.nCols) {
            throw new MatrixException("Invalid matrix dimensions.");
        }
        double[][] dv = new double[this.nRows][this.nCols];
        for (int r = 0; r < this.nRows; ++r) {
            for (int c = 0; c < this.nCols; ++c) {
                dv[r][c] = this.values[r][c] - m.values[r][c];
            }
        }
        return new Matrix(dv);
    }

    public Matrix multiply(double k) {
        double[][] pv = new double[this.nRows][this.nCols];
        for (int r = 0; r < this.nRows; ++r) {
            for (int c = 0; c < this.nCols; ++c) {
                pv[r][c] = k * this.values[r][c];
            }
        }
        return new Matrix(pv);
    }

    public Matrix multiply(Matrix m) throws MatrixException {
        if (this.nCols != m.nRows) {
            throw new MatrixException("Invalid matrix dimensions.");
        }
        double[][] pv = new double[this.nRows][m.nCols];
        for (int r = 0; r < this.nRows; ++r) {
            for (int c = 0; c < m.nCols; ++c) {
                double dot = 0.0;
                for (int k = 0; k < this.nCols; ++k) {
                    dot += this.values[r][k] * m.values[k][c];
                }
                pv[r][c] = dot;
            }
        }
        return new Matrix(pv);
    }

    public ColumnVector multiply(ColumnVector cv) throws MatrixException {
        if (this.nRows != cv.nRows) {
            throw new MatrixException("Invalid matrix dimensions.");
        }
        double[] pv = new double[this.nRows];
        for (int r = 0; r < this.nRows; ++r) {
            double dot = 0.0;
            for (int c = 0; c < this.nCols; ++c) {
                dot += this.values[r][c] * cv.values[c][0];
            }
            pv[r] = dot;
        }
        return new ColumnVector(pv);
    }

    public RowVector multiply(RowVector rv) throws MatrixException {
        if (this.nCols != rv.nCols) {
            throw new MatrixException("Invalid matrix dimensions.");
        }
        double[] pv = new double[this.nRows];
        for (int c = 0; c < this.nCols; ++c) {
            double dot = 0.0;
            for (int r = 0; r < this.nRows; ++r) {
                dot += rv.values[0][r] * this.values[r][c];
            }
            pv[c] = dot;
        }
        return new RowVector(pv);
    }
}

