/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.math.matrixes;

import org.hortonmachine.gears.utils.math.matrixes.Matrix;
import org.hortonmachine.gears.utils.math.matrixes.MatrixException;

public class RowVector
extends Matrix {
    public RowVector(int n) {
        super(1, n);
    }

    public RowVector(double[] values) {
        this.set(values);
    }

    private RowVector(Matrix m) {
        this.set(m);
    }

    public int size() {
        return this.nCols;
    }

    public double[] copyValues1D() {
        double[] v = new double[this.nCols];
        for (int c = 0; c < this.nCols; ++c) {
            v[c] = this.values[0][c];
        }
        return v;
    }

    public double at(int i) {
        return this.values[0][i];
    }

    private void set(Matrix m) {
        this.nRows = 1;
        this.nCols = m.nCols;
        this.values = m.values;
    }

    protected void set(double[] values) {
        this.nRows = 1;
        this.nCols = values.length;
        this.values = new double[1][];
        this.values[0] = values;
    }

    public void set(int i, double value) {
        this.values[0][i] = value;
    }

    public RowVector add(RowVector rv) throws MatrixException {
        return new RowVector(super.add(rv));
    }

    public RowVector subtract(RowVector rv) throws MatrixException {
        return new RowVector(super.subtract(rv));
    }

    public double norm() {
        double t = 0.0;
        for (int c = 0; c < this.nCols; ++c) {
            double v = this.values[0][c];
            t += v * v;
        }
        return Math.sqrt(t);
    }

    public void print() {
        for (int c = 0; c < this.nCols; ++c) {
            System.out.print("  " + this.values[0][c]);
        }
        System.out.println();
    }
}

