/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.math.matrixes;

import org.hortonmachine.gears.utils.math.matrixes.Matrix;
import org.hortonmachine.gears.utils.math.matrixes.MatrixException;

public class SquareMatrix
extends Matrix {
    public SquareMatrix(int n) {
        super(n, n);
    }

    private SquareMatrix(Matrix m) {
        this.set(m);
    }

    public SquareMatrix(double[][] values) {
        this.set(values);
    }

    private void set(Matrix m) {
        this.nRows = this.nCols = Math.min(m.nRows, m.nCols);
        this.values = m.values;
    }

    @Override
    protected void set(double[][] values) {
        super.set(values);
        this.nRows = this.nCols = Math.min(this.nRows, this.nCols);
    }

    public SquareMatrix add(SquareMatrix sm) throws MatrixException {
        return new SquareMatrix(super.add(sm));
    }

    public SquareMatrix subtract(SquareMatrix sm) throws MatrixException {
        return new SquareMatrix(super.subtract(sm));
    }

    public SquareMatrix multiply(SquareMatrix sm) throws MatrixException {
        return new SquareMatrix(super.multiply(sm));
    }
}

