/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.math.regressions;

import java.util.Arrays;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import org.hortonmachine.gears.utils.math.regressions.RegressionLine;

public abstract class OLSTrendLine
implements RegressionLine {
    private RealMatrix coef = null;
    private OLSMultipleLinearRegression ols;

    protected abstract double[] xVector(double var1);

    protected abstract boolean logY();

    @Override
    public void setValues(double[] y, double[] x) {
        int i;
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The numbers of y and x values must be equal (%d != %d)", y.length, x.length));
        }
        double[][] xData = new double[x.length][];
        for (i = 0; i < x.length; ++i) {
            xData[i] = this.xVector(x[i]);
        }
        if (this.logY()) {
            y = Arrays.copyOf(y, y.length);
            for (i = 0; i < x.length; ++i) {
                y[i] = Math.log(y[i]);
            }
        }
        this.ols = new OLSMultipleLinearRegression();
        this.ols.setNoIntercept(true);
        this.ols.newSampleData(y, (double[][])xData);
        this.coef = MatrixUtils.createColumnRealMatrix((double[])this.ols.estimateRegressionParameters());
    }

    @Override
    public double[] getRegressionParameters() {
        return this.ols.estimateRegressionParameters();
    }

    @Override
    public double[] getRegressionParametersErrors() {
        return this.ols.estimateRegressionParametersStandardErrors();
    }

    @Override
    public double getRSquared() {
        return this.ols.calculateRSquared();
    }

    @Override
    public double[] getResiduals() {
        return this.ols.estimateResiduals();
    }

    @Override
    public double predict(double x) {
        double yhat = this.coef.preMultiply(this.xVector(x))[0];
        if (this.logY()) {
            yhat = Math.exp(yhat);
        }
        return yhat;
    }
}

