/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.math.rootfinding;

import org.hortonmachine.gears.i18n.GearsMessageHandler;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;
import org.hortonmachine.gears.utils.math.functions.ISingleArgmentFunction;

public class RootFindingFunctions {
    private static GearsMessageHandler msg = GearsMessageHandler.getInstance();

    public static double bisectionRootFinding(ISingleArgmentFunction function, double bottomLimit, double upperLimit, double accuracy, double maxIterationNumber, IHMProgressMonitor pm) {
        double rtb;
        double dx;
        double fmid;
        double f = function.getValue(bottomLimit);
        if (f * (fmid = function.getValue(upperLimit)) >= 0.0) {
            pm.errorMessage(msg.message("trentoP.error.braketed"));
            throw new ArithmeticException(msg.message("trentoP.error.braketed"));
        }
        if (f < 0.0) {
            dx = upperLimit - bottomLimit;
            rtb = bottomLimit;
        } else {
            dx = bottomLimit - upperLimit;
            rtb = upperLimit;
        }
        long j = 1L;
        while ((double)j <= maxIterationNumber) {
            double xmid = rtb + (dx *= 0.5);
            fmid = function.getValue(xmid);
            if (fmid <= 0.0) {
                rtb = xmid;
            }
            if (Math.abs(dx) < accuracy || fmid == 0.0) {
                return rtb;
            }
            ++j;
        }
        pm.errorMessage(msg.message("trentoP.error.bisection"));
        throw new ArithmeticException(msg.message("trentoP.error.bisection"));
    }
}

