/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.optimizers.particleswarm;

import java.util.Arrays;
import java.util.Random;
import org.hortonmachine.gears.utils.optimizers.particleswarm.PSEngine;

public class Particle {
    private double[] locations = null;
    private double[] particleVelocities;
    private double[] particleLocalBests;
    private double particleBestFunction;
    private double[][] ranges;
    private double[] initialLocations;
    private double[] tmpLocations = null;
    private static Random rand = new Random(2L);

    public Particle(double[][] ranges) {
        int i;
        this.ranges = ranges;
        double[] r = new double[ranges.length];
        for (i = 0; i < r.length; ++i) {
            double value;
            double min = ranges[i][0];
            double max = ranges[i][1];
            double delta = max - min;
            double random = rand.nextDouble() - 1.0;
            double smallRand = 0.5 * delta * random;
            r[i] = value = min + delta / 2.0 + 0.8 * smallRand;
        }
        System.out.println("INIT PARTICLE WITH: " + Arrays.toString(r));
        this.locations = r;
        this.tmpLocations = new double[this.locations.length];
        this.initialLocations = new double[this.locations.length];
        System.arraycopy(this.locations, 0, this.initialLocations, 0, r.length);
        this.particleLocalBests = new double[this.locations.length];
        this.particleVelocities = new double[this.locations.length];
        for (i = 0; i < this.locations.length; ++i) {
            this.particleLocalBests[i] = this.locations[i];
            this.particleVelocities[i] = 0.0;
        }
    }

    public double[] getInitialLocations() {
        return this.initialLocations;
    }

    public double[] update(double w, double c1, double rand1, double c2, double rand2, double[] globalBest) {
        int i;
        for (i = 0; i < this.locations.length; ++i) {
            double tmpLocation;
            this.particleVelocities[i] = w * this.particleVelocities[i] + c1 * rand1 * (this.particleLocalBests[i] - this.locations[i]) + c2 * rand2 * (globalBest[i] - this.locations[i]);
            this.tmpLocations[i] = tmpLocation = this.locations[i] + this.particleVelocities[i];
        }
        if (!PSEngine.parametersInRange(this.tmpLocations, this.ranges)) {
            for (i = 0; i < this.tmpLocations.length; ++i) {
                double tmp;
                double min = this.ranges[i][0];
                double max = this.ranges[i][1];
                if (this.tmpLocations[i] > max) {
                    tmp = max - (this.tmpLocations[i] - max);
                    if (tmp < min) {
                        tmp = max;
                    }
                    this.locations[i] = tmp;
                    continue;
                }
                if (this.tmpLocations[i] < min) {
                    tmp = min + (min - this.tmpLocations[i]);
                    if (tmp > max) {
                        tmp = min;
                    }
                    this.locations[i] = tmp;
                    continue;
                }
                this.locations[i] = this.tmpLocations[i];
            }
            return null;
        }
        for (i = 0; i < this.locations.length; ++i) {
            this.locations[i] = this.tmpLocations[i];
        }
        return this.locations;
    }

    public double getParticleBestFunction() {
        return this.particleBestFunction;
    }

    public void setParticleBestFunction(double particleBestFunction) {
        this.particleBestFunction = particleBestFunction;
    }

    public void setParticleLocalBeststoCurrent() {
        for (int i = 0; i < this.locations.length; ++i) {
            this.particleLocalBests[i] = this.locations[i];
        }
    }
}

