/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.processes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.hortonmachine.gears.libs.exceptions.ModelsUserCancelException;
import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.utils.StringUtilities;
import org.hortonmachine.gears.utils.processes.ELogStyle;
import org.hortonmachine.gears.utils.processes.IProcessListener;
import org.hortonmachine.gears.utils.processes.SystemoutProcessListener;
import org.joda.time.DateTime;

public class CommandExecutor {
    private static String nl = "\n";
    private List<IProcessListener> listeners = new ArrayList<IProcessListener>();
    private String[] arguments;
    private boolean isRunning;
    private Process process;

    public CommandExecutor(String command) {
        this.arguments = StringUtilities.parseCommand(command);
    }

    public CommandExecutor(String[] arguments) {
        this.arguments = arguments;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void exec() throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(this.arguments);
        this.printMessage("Process started: " + DateTime.now().toString(HMConstants.dateTimeFormatterYYYYMMDDHHMMSS), ELogStyle.COMMENT);
        this.process = processBuilder.start();
        this.isRunning = true;
        new Thread(this.arguments[0]){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader br = null;
                try {
                    String line;
                    InputStream is = CommandExecutor.this.process.getInputStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        CommandExecutor.this.printMessage(line, ELogStyle.NORMAL);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CommandExecutor.this.printException(e);
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    CommandExecutor.this.printMessage("Process finished: " + DateTime.now().toString(HMConstants.dateTimeFormatterYYYYMMDDHHMMSS), ELogStyle.COMMENT);
                    CommandExecutor.this.isRunning = false;
                    CommandExecutor.this.updateListenersForModuleStop();
                }
            }
        }.start();
        new Thread(this.arguments[0] + " -> Console printer"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader br = null;
                try {
                    String line;
                    String userCanceled = ModelsUserCancelException.class.getCanonicalName();
                    InputStream is = CommandExecutor.this.process.getErrorStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        if (line.startsWith(userCanceled)) {
                            line = "Process cancelled by user.";
                        }
                        CommandExecutor.this.printMessage(line, ELogStyle.ERROR);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CommandExecutor.this.printException(e);
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }.start();
    }

    public void waitToFinish() throws InterruptedException {
        this.process.waitFor();
    }

    public Process getProcess() {
        return this.process;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void addProcessListener(IProcessListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeProcessListener(IProcessListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private synchronized void printMessage(String message, ELogStyle style) {
        String[] split;
        for (String string : split = message.split(nl)) {
            for (IProcessListener listener : this.listeners) {
                listener.onMessage(string, style);
            }
        }
    }

    private void updateListenersForModuleStop() {
        for (IProcessListener listener : this.listeners) {
            listener.onProcessStopped();
        }
    }

    private void printException(Exception e) {
        this.printMessage(e.getLocalizedMessage(), ELogStyle.ERROR);
    }

    public void killProcess(Process process) {
        if (process != null) {
            process.destroy();
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String cmd = "echo $PATH";
        CommandExecutor exe = new CommandExecutor(cmd);
        exe.addProcessListener(new SystemoutProcessListener());
        exe.exec();
        exe.waitToFinish();
        System.out.println("DONE");
    }
}

