/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.sorting;

import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.gears.libs.monitor.IHMProgressMonitor;

public class QuickSortAlgorithm {
    private double[] valuesToSortDouble;
    private float[] valuesToSortFloat;
    private int number;
    private double[] valuesToFollowDouble;
    private float[] valuesToFollowFloat;
    private int[] valuesToFollowInt;
    private IHMProgressMonitor monitor;

    public QuickSortAlgorithm(IHMProgressMonitor monitor) {
        if (monitor != null) {
            this.monitor = monitor;
        }
    }

    public void sort(double[] values, double[] valuesToFollow) {
        this.valuesToSortDouble = values;
        this.valuesToFollowDouble = valuesToFollow;
        this.number = values.length;
        if (this.monitor != null) {
            this.monitor.beginTask("Sorting...", -1);
            this.monitor.worked(1);
        }
        this.quicksort(0, this.number - 1);
        if (this.monitor != null) {
            this.monitor.done();
        }
    }

    public void sort(float[] values, float[] valuesToFollow) {
        this.valuesToSortFloat = values;
        this.valuesToFollowFloat = valuesToFollow;
        this.number = values.length;
        if (this.monitor != null) {
            this.monitor.beginTask("Sorting...", -1);
            this.monitor.worked(1);
        }
        this.quicksortFloat(0, this.number - 1);
        if (this.monitor != null) {
            this.monitor.done();
        }
    }

    public void sort(double[] values, int[] valuesToFollow) {
        this.valuesToSortDouble = values;
        this.valuesToFollowInt = valuesToFollow;
        this.number = values.length;
        if (this.monitor != null) {
            this.monitor.beginTask("Sorting...", -1);
            this.monitor.worked(1);
        }
        this.quicksortInt(0, this.number - 1);
        if (this.monitor != null) {
            this.monitor.done();
        }
    }

    private void quicksort(int low, int high) {
        int i = low;
        int j = high;
        double pivot = this.valuesToSortDouble[low + high >>> 1];
        while (i <= j) {
            while (this.valuesToSortDouble[i] < pivot || HMConstants.isNovalue(this.valuesToSortDouble[i]) && !HMConstants.isNovalue(pivot)) {
                ++i;
            }
            while (this.valuesToSortDouble[j] > pivot || !HMConstants.isNovalue(this.valuesToSortDouble[j]) && HMConstants.isNovalue(pivot)) {
                --j;
            }
            if (i > j) continue;
            this.exchange(i, j);
            ++i;
            --j;
        }
        if (low < j) {
            this.quicksort(low, j);
        }
        if (i < high) {
            this.quicksort(i, high);
        }
    }

    private void quicksortFloat(int low, int high) {
        int i = low;
        int j = high;
        double pivot = this.valuesToSortFloat[low + high >>> 1];
        while (i <= j) {
            while ((double)this.valuesToSortFloat[i] < pivot || HMConstants.isNovalue(this.valuesToSortFloat[i]) && !HMConstants.isNovalue(pivot)) {
                ++i;
            }
            while ((double)this.valuesToSortFloat[j] > pivot || !HMConstants.isNovalue(this.valuesToSortFloat[j]) && HMConstants.isNovalue(pivot)) {
                --j;
            }
            if (i > j) continue;
            this.exchangeFloat(i, j);
            ++i;
            --j;
        }
        if (low < j) {
            this.quicksortFloat(low, j);
        }
        if (i < high) {
            this.quicksortFloat(i, high);
        }
    }

    private void quicksortInt(int low, int high) {
        int i = low;
        int j = high;
        double pivot = this.valuesToSortDouble[low + high >>> 1];
        while (i <= j) {
            while (this.valuesToSortDouble[i] < pivot || HMConstants.isNovalue(this.valuesToSortDouble[i]) && !HMConstants.isNovalue(pivot)) {
                ++i;
            }
            while (this.valuesToSortDouble[j] > pivot || !HMConstants.isNovalue(this.valuesToSortDouble[j]) && HMConstants.isNovalue(pivot)) {
                --j;
            }
            if (i > j) continue;
            this.exchangeDoubleInt(i, j);
            ++i;
            --j;
        }
        if (low < j) {
            this.quicksortInt(low, j);
        }
        if (i < high) {
            this.quicksortInt(i, high);
        }
    }

    private void exchange(int i, int j) {
        double temp = this.valuesToSortDouble[i];
        this.valuesToSortDouble[i] = this.valuesToSortDouble[j];
        this.valuesToSortDouble[j] = temp;
        if (this.valuesToFollowDouble != null) {
            double tempFollow = this.valuesToFollowDouble[i];
            this.valuesToFollowDouble[i] = this.valuesToFollowDouble[j];
            this.valuesToFollowDouble[j] = tempFollow;
        }
    }

    private void exchangeFloat(int i, int j) {
        float temp = this.valuesToSortFloat[i];
        this.valuesToSortFloat[i] = this.valuesToSortFloat[j];
        this.valuesToSortFloat[j] = temp;
        if (this.valuesToFollowFloat != null) {
            float tempFollow = this.valuesToFollowFloat[i];
            this.valuesToFollowFloat[i] = this.valuesToFollowFloat[j];
            this.valuesToFollowFloat[j] = tempFollow;
        }
    }

    private void exchangeDoubleInt(int i, int j) {
        double temp = this.valuesToSortDouble[i];
        this.valuesToSortDouble[i] = this.valuesToSortDouble[j];
        this.valuesToSortDouble[j] = temp;
        if (this.valuesToFollowInt != null) {
            int tempFollow = this.valuesToFollowInt[i];
            this.valuesToFollowInt[i] = this.valuesToFollowInt[j];
            this.valuesToFollowInt[j] = tempFollow;
        }
    }
}

