/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.sorting;

public class ShearSortAlgorithm {
    private int Log;
    private int Rows;
    private int Cols;

    public void parallelSort(double[] arrayToBeSorted, double[] arrayThatFollowsTheSort) throws Exception {
        int pow = 1;
        int div = 1;
        int i = 1;
        while (i * i <= arrayToBeSorted.length) {
            if (arrayToBeSorted.length % i == 0) {
                div = i;
            }
            ++i;
        }
        this.Rows = div;
        this.Cols = arrayToBeSorted.length / div;
        this.Log = 0;
        while (pow <= this.Rows) {
            pow *= 2;
            ++this.Log;
        }
        int[] h = new int[this.Rows];
        for (i = 0; i < this.Rows; ++i) {
            h[i] = i * this.Cols;
        }
        for (int k = 0; k < this.Log; ++k) {
            int i2;
            int j;
            for (j = 0; j < this.Cols / 2; ++j) {
                for (i2 = 0; i2 < this.Rows; ++i2) {
                    this.sortPart1(arrayToBeSorted, arrayThatFollowsTheSort, i2 * this.Cols, (i2 + 1) * this.Cols, 1, i2 % 2 == 0);
                }
                this.apause(h);
                for (i2 = 0; i2 < this.Rows; ++i2) {
                    this.sortPart2(arrayToBeSorted, arrayThatFollowsTheSort, i2 * this.Cols, (i2 + 1) * this.Cols, 1, i2 % 2 == 0);
                }
                this.apause(h);
            }
            for (j = 0; j < this.Rows / 2; ++j) {
                for (i2 = 0; i2 < this.Cols; ++i2) {
                    this.sortPart1(arrayToBeSorted, arrayThatFollowsTheSort, i2, this.Rows * this.Cols + i2, this.Cols, true);
                }
                this.apause(h);
                for (i2 = 0; i2 < this.Cols; ++i2) {
                    this.sortPart2(arrayToBeSorted, arrayThatFollowsTheSort, i2, this.Rows * this.Cols + i2, this.Cols, true);
                }
                this.apause(h);
            }
        }
        for (int j = 0; j < this.Cols / 2; ++j) {
            int i3;
            for (i3 = 0; i3 < this.Rows; ++i3) {
                this.sortPart1(arrayToBeSorted, arrayThatFollowsTheSort, i3 * this.Cols, (i3 + 1) * this.Cols, 1, true);
            }
            this.apause(h);
            for (i3 = 0; i3 < this.Rows; ++i3) {
                this.sortPart2(arrayToBeSorted, arrayThatFollowsTheSort, i3 * this.Cols, (i3 + 1) * this.Cols, 1, true);
            }
            this.apause(h);
        }
        for (i = 0; i < this.Rows; ++i) {
            h[i] = -1;
        }
        this.apause(h);
    }

    private void sortPart1(double[] arrayToSort, double[] arrayToFollowSort, int Lo, int Hi, int Nx, boolean Up) throws Exception {
        int j = Lo;
        while (j + Nx < Hi) {
            if (Up && arrayToSort[j] > arrayToSort[j + Nx] || !Up && arrayToSort[j] < arrayToSort[j + Nx]) {
                double T = arrayToSort[j];
                arrayToSort[j] = arrayToSort[j + Nx];
                arrayToSort[j + Nx] = T;
                if (arrayToFollowSort != null) {
                    double Tfollow = arrayToFollowSort[j];
                    arrayToFollowSort[j] = arrayToFollowSort[j + Nx];
                    arrayToFollowSort[j + Nx] = Tfollow;
                }
            }
            j += 2 * Nx;
        }
    }

    private void sortPart2(double[] arrayToSort, double[] arrayToFollowSort, int Lo, int Hi, int Nx, boolean Up) throws Exception {
        int j = Lo + Nx;
        while (j + Nx < Hi) {
            if (Up && arrayToSort[j] > arrayToSort[j + Nx] || !Up && arrayToSort[j] < arrayToSort[j + Nx]) {
                double T = arrayToSort[j];
                arrayToSort[j] = arrayToSort[j + Nx];
                arrayToSort[j + Nx] = T;
                if (arrayToFollowSort != null) {
                    double Tfollow = arrayToFollowSort[j];
                    arrayToFollowSort[j] = arrayToFollowSort[j + Nx];
                    arrayToFollowSort[j + Nx] = Tfollow;
                }
            }
            j += 2 * Nx;
        }
    }

    private void apause(int[] H) {
        try {
            Thread.sleep(40L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        ShearSortAlgorithm t = new ShearSortAlgorithm();
        double[] tmp1 = new double[]{2.5, 4.7, 1.3, 10.123, -0.3, -14.0, 123.6};
        double[] tmp2 = new double[]{2.0, 3.0, 1.0, 4.0, -0.3, -1.0, 5.0};
        try {
            t.parallelSort(tmp1, tmp2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < tmp2.length; ++i) {
            System.out.println(tmp1[i] + " " + tmp2[i]);
        }
    }
}

