/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.style;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.hortonmachine.gears.utils.style.RuleWrapper;
import org.hortonmachine.gears.utils.style.StyleWrapper;

public class FeatureTypeStyleWrapper {
    private FeatureTypeStyle featureTypeStyle;
    private List<RuleWrapper> rulesWrapperList = new ArrayList<RuleWrapper>();
    private final StyleWrapper parent;

    public FeatureTypeStyleWrapper(FeatureTypeStyle featureTypeStyle, StyleWrapper parent) {
        this.featureTypeStyle = featureTypeStyle;
        this.parent = parent;
        List rules = featureTypeStyle.rules();
        for (Rule rule : rules) {
            RuleWrapper ruleWrapper = new RuleWrapper(rule, this);
            this.rulesWrapperList.add(ruleWrapper);
        }
    }

    public StyleWrapper getParent() {
        return this.parent;
    }

    public FeatureTypeStyle getFeatureTypeStyle() {
        return this.featureTypeStyle;
    }

    public String getName() {
        Object name = this.featureTypeStyle.getName();
        if (name == null) {
            int indexOf = this.parent.getStyle().featureTypeStyles().indexOf(this.featureTypeStyle);
            name = "featureStyle_" + indexOf;
            this.featureTypeStyle.setName((String)name);
        }
        return name;
    }

    public void setName(String name) {
        this.featureTypeStyle.setName(name);
    }

    public List<RuleWrapper> getRulesWrapperList() {
        return Collections.unmodifiableList(this.rulesWrapperList);
    }

    public void removeRule(RuleWrapper remRule) {
        Rule rule = remRule.getRule();
        this.featureTypeStyle.rules().remove(rule);
        this.rulesWrapperList.remove(remRule);
    }

    public void addRule(RuleWrapper addRule) {
        Rule rule = addRule.getRule();
        this.featureTypeStyle.rules().add(rule);
        this.rulesWrapperList.add(addRule);
    }

    public void clear() {
        this.featureTypeStyle.rules().clear();
        this.rulesWrapperList.clear();
    }

    public void swap(int src, int dest) {
        List rules = this.featureTypeStyle.rules();
        if (src >= 0 && src < rules.size() && dest >= 0 && dest < rules.size()) {
            Collections.swap(rules, src, dest);
            Collections.swap(this.rulesWrapperList, src, dest);
        }
    }

    public String toString() {
        return this.getName();
    }
}

