/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.style;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.geotools.filter.function.FilterFunction_endPoint;
import org.geotools.filter.function.FilterFunction_startPoint;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.Symbolizer;
import org.hortonmachine.gears.utils.style.PointSymbolizerWrapper;
import org.hortonmachine.gears.utils.style.RuleWrapper;
import org.hortonmachine.gears.utils.style.StyleUtilities;
import org.hortonmachine.gears.utils.style.SymbolizerWrapper;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.style.GraphicalSymbol;

public class LineSymbolizerWrapper
extends SymbolizerWrapper {
    protected String strokeColor = "#000000";
    protected String strokeOpacity = "1";
    protected String strokeWidth = "1";
    protected Stroke stroke = StyleUtilities.createDefaultStroke();
    protected Graphic strokeGraphicStroke;
    protected String dash = "";
    protected String dashOffset = "0";
    protected String lineCap = "round";
    protected String lineJoin = "round";
    protected PointSymbolizerWrapper endPointStyle;
    protected PointSymbolizerWrapper startPointStyle;

    public LineSymbolizerWrapper(PolygonSymbolizer polygonSymbolizer, RuleWrapper parent) {
        super((Symbolizer)polygonSymbolizer, parent);
        this.initEndPointSymbolizers();
    }

    public LineSymbolizerWrapper(Symbolizer symbolizer, RuleWrapper parent) {
        super(symbolizer, parent);
        float[] dashArray;
        GraphicalSymbol graphicalSymbol;
        List graphicalSymbolsList;
        this.initEndPointSymbolizers();
        LineSymbolizer lineSymbolizer = (LineSymbolizer)symbolizer;
        Point2D offset = StyleUtilities.getOffset((Symbolizer)lineSymbolizer);
        if (offset != null) {
            this.xOffset = String.valueOf(offset.getX());
            this.yOffset = String.valueOf(offset.getY());
        } else {
            this.xOffset = "0";
            this.yOffset = "0";
        }
        Stroke strokeTmp = lineSymbolizer.getStroke();
        if (strokeTmp != null) {
            this.stroke = strokeTmp;
        } else {
            lineSymbolizer.setStroke((org.opengis.style.Stroke)this.stroke);
        }
        Expression color = this.stroke.getColor();
        if (color != null) {
            this.strokeColor = this.expressionToString(color);
        } else {
            this.stroke.setColor((Expression)StyleUtilities.ff.literal((Object)this.strokeColor));
        }
        Expression width = this.stroke.getWidth();
        if (width != null) {
            this.strokeWidth = this.expressionToString(width);
        } else {
            this.stroke.setWidth((Expression)StyleUtilities.ff.literal((Object)this.strokeWidth));
        }
        Expression opacity = this.stroke.getOpacity();
        if (opacity != null) {
            this.strokeOpacity = this.expressionToString(opacity);
        } else {
            this.stroke.setOpacity((Expression)StyleUtilities.ff.literal((Object)this.strokeOpacity));
        }
        this.strokeGraphicStroke = this.stroke.getGraphicStroke();
        if (this.strokeGraphicStroke != null && (graphicalSymbolsList = this.strokeGraphicStroke.graphicalSymbols()).size() > 0 && (graphicalSymbol = (GraphicalSymbol)graphicalSymbolsList.get(0)) instanceof ExternalGraphic) {
            this.strokeExternalGraphicStroke = (ExternalGraphic)graphicalSymbol;
        }
        this.dash = (dashArray = this.getDashArrayFloats()).length > 0 ? StyleUtilities.getDashString(dashArray) : "";
        this.dashOffset = (String)this.stroke.getDashOffset().evaluate(null, String.class);
        this.lineCap = (String)this.stroke.getLineCap().evaluate(null, String.class);
        this.lineJoin = (String)this.stroke.getLineJoin().evaluate(null, String.class);
    }

    private void initEndPointSymbolizers() {
        for (Symbolizer x : super.getParent().getRule().getSymbolizers()) {
            GraphicalSymbol gs;
            if (!(x instanceof PointSymbolizer)) continue;
            PointSymbolizer pnt = (PointSymbolizer)x;
            Expression ex = pnt.getGeometry();
            boolean endpnt = ex instanceof FilterFunction_endPoint;
            boolean startpnt = ex instanceof FilterFunction_startPoint;
            if (!endpnt && !startpnt || !((gs = (GraphicalSymbol)pnt.getGraphic().graphicalSymbols().get(0)) instanceof Mark)) continue;
            String name = (String)((Mark)gs).getWellKnownName().evaluate(null, String.class);
            if (!StyleUtilities.lineEndStyles.values().contains(name)) continue;
            if (endpnt) {
                this.endPointStyle = new PointSymbolizerWrapper((Symbolizer)pnt, super.getParent());
                continue;
            }
            if (!startpnt) continue;
            this.startPointStyle = new PointSymbolizerWrapper((Symbolizer)pnt, super.getParent());
        }
    }

    public PointSymbolizerWrapper getEndPointStyle() {
        return this.endPointStyle;
    }

    public PointSymbolizerWrapper getStartPointStyle() {
        return this.startPointStyle;
    }

    public void setEndPointStyle(String geomName, String wkgName, String size, String color) {
        this.endPointStyle = this.updateEndpointStyle(geomName, this.endPointStyle, wkgName, size, color, false);
    }

    public void setStartPointStyle(String geomName, String wkgName, String size, String color) {
        this.startPointStyle = this.updateEndpointStyle(geomName, this.startPointStyle, wkgName, size, color, true);
    }

    private PointSymbolizerWrapper updateEndpointStyle(String geomName, PointSymbolizerWrapper wrapper, String wkgName, String size, String color, boolean isStart) {
        if ((wkgName == null || wkgName.length() == 0) && wrapper != null) {
            this.getParent().getRule().symbolizers().remove(wrapper.getSymbolizer());
            return null;
        }
        if (wrapper == null) {
            PointSymbolizer p = StyleUtilities.sf.createPointSymbolizer();
            if (isStart) {
                p.setGeometry((Expression)StyleUtilities.ff.function("startPoint", new Expression[]{StyleUtilities.ff.property(geomName)}));
                p.getGraphic().setRotation((Expression)StyleUtilities.ff.add((Expression)StyleUtilities.ff.function("startAngle", new Expression[]{StyleUtilities.ff.property(geomName)}), (Expression)StyleUtilities.ff.literal(-180)));
            } else {
                p.setGeometry((Expression)StyleUtilities.ff.function("endPoint", new Expression[]{StyleUtilities.ff.property(geomName)}));
                p.getGraphic().setRotation((Expression)StyleUtilities.ff.function("endAngle", new Expression[]{StyleUtilities.ff.property(geomName)}));
            }
            wrapper = new PointSymbolizerWrapper((Symbolizer)p, this.getParent());
            this.getParent().getRule().symbolizers().add(wrapper.getSymbolizer());
        }
        wrapper.setMarkName(wkgName);
        wrapper.setStrokeColor(color);
        wrapper.setFillColor(color);
        wrapper.setSize(size, false);
        return wrapper;
    }

    public void clearGraphicStroke() {
        if (this.stroke == null) {
            return;
        }
        this.stroke.setGraphicStroke(null);
        this.strokeGraphicStroke = null;
    }

    public Graphic getStrokeGraphicStroke() {
        return this.strokeGraphicStroke;
    }

    public void setStrokeGraphicStroke(Graphic strokeGraphicStroke) {
        this.strokeGraphicStroke = strokeGraphicStroke;
        this.stroke.setGraphicStroke((org.opengis.style.Graphic)strokeGraphicStroke);
    }

    public void setStrokeWidth(String strokeWidth, boolean isProperty) {
        this.strokeWidth = strokeWidth;
        if (isProperty) {
            this.stroke.setWidth((Expression)StyleUtilities.ff.property(strokeWidth));
        } else {
            this.stroke.setWidth((Expression)StyleUtilities.ff.literal((Object)strokeWidth));
        }
    }

    public void setStrokeColor(String strokeColor, boolean isProperty) {
        this.strokeColor = strokeColor;
        if (isProperty) {
            this.stroke.setColor((Expression)StyleUtilities.ff.property(strokeColor));
        } else if (strokeColor != null) {
            this.stroke.setColor((Expression)StyleUtilities.ff.literal((Object)strokeColor));
        }
    }

    public void setStrokeOpacity(String strokeOpacity, boolean isProperty) {
        this.strokeOpacity = strokeOpacity;
        if (isProperty) {
            this.stroke.setOpacity((Expression)StyleUtilities.ff.property(strokeOpacity));
        } else {
            this.stroke.setOpacity((Expression)StyleUtilities.ff.literal((Object)strokeOpacity));
        }
        if (this.endPointStyle != null) {
            this.endPointStyle.setStrokeOpacity(strokeOpacity, isProperty);
            this.endPointStyle.setFillOpacity(strokeOpacity, isProperty);
        }
        if (this.startPointStyle != null) {
            this.startPointStyle.setStrokeOpacity(strokeOpacity, isProperty);
            this.startPointStyle.setFillOpacity(strokeOpacity, isProperty);
        }
    }

    public void setDash(String dash) {
        this.dash = dash;
        float[] dashArray = StyleUtilities.getDash(dash);
        if (dashArray == null) {
            this.stroke.dashArray().clear();
        } else {
            ArrayList<Literal> dashArrayExpr = new ArrayList<Literal>();
            for (float value : dashArray) {
                dashArrayExpr.add(StyleUtilities.ff.literal(value));
            }
            this.stroke.setDashArray(dashArrayExpr);
        }
    }

    private float[] getDashArrayFloats() {
        List dashArrayExpr = this.stroke.dashArray();
        if (dashArrayExpr == null) {
            return new float[0];
        }
        float[] dashArray = new float[dashArrayExpr.size()];
        int index = 0;
        for (Expression expression : dashArrayExpr) {
            if (!(expression instanceof Literal)) {
                throw new RuntimeException("Dash array is not literal: '" + expression + "'.");
            }
            Literal literal = (Literal)expression;
            dashArray[index] = ((Float)literal.evaluate(null, Float.class)).floatValue();
            ++index;
        }
        return dashArray;
    }

    public void setDashOffset(String dashOffset) {
        this.dashOffset = dashOffset;
        if (dashOffset != null && dashOffset.length() > 0) {
            this.stroke.setDashOffset((Expression)StyleUtilities.ff.literal((Object)dashOffset));
        }
    }

    public void setLineCap(String lineCap) {
        this.lineCap = lineCap;
        this.stroke.setLineCap((Expression)StyleUtilities.ff.literal((Object)lineCap));
    }

    public void setLineJoin(String lineJoin) {
        this.lineJoin = lineJoin;
        this.stroke.setLineJoin((Expression)StyleUtilities.ff.literal((Object)lineJoin));
    }

    public String getStrokeColor() {
        return this.strokeColor;
    }

    public String getStrokeOpacity() {
        return this.strokeOpacity;
    }

    public String getStrokeWidth() {
        return this.strokeWidth;
    }

    public String getDash() {
        return this.dash;
    }

    public String getDashOffset() {
        return this.dashOffset;
    }

    public String getLineCap() {
        return this.lineCap;
    }

    public String getLineJoin() {
        return this.lineJoin;
    }
}

