/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.style;

import java.awt.geom.Point2D;
import java.util.List;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Symbolizer;
import org.hortonmachine.gears.utils.style.LineSymbolizerWrapper;
import org.hortonmachine.gears.utils.style.RuleWrapper;
import org.hortonmachine.gears.utils.style.StyleUtilities;
import org.opengis.filter.expression.Expression;
import org.opengis.style.GraphicalSymbol;
import org.opengis.style.Stroke;

public class PolygonSymbolizerWrapper
extends LineSymbolizerWrapper {
    private Fill fill = StyleUtilities.createDefaultFill();
    private String fillColor = "#000000";
    private String fillOpacity = "1";
    private Graphic fillGraphicFill;
    private String wkMarkNameFill;
    private String wkMarkColorFill;
    private String wkMarkWidthFill;
    private String wkMarkSizeFill;
    private Mark mark;

    public PolygonSymbolizerWrapper(Symbolizer tmpSymbolizer, RuleWrapper parent) {
        super((PolygonSymbolizer)tmpSymbolizer, parent);
        List graphicalSymbolsList;
        float[] dashArray;
        GraphicalSymbol graphicalSymbol;
        List graphicalSymbolsList2;
        PolygonSymbolizer polygonSymbolizer = (PolygonSymbolizer)tmpSymbolizer;
        Point2D offset = StyleUtilities.getOffset((Symbolizer)polygonSymbolizer);
        if (offset != null) {
            this.xOffset = String.valueOf(offset.getX());
            this.yOffset = String.valueOf(offset.getY());
        } else {
            this.xOffset = "0";
            this.yOffset = "0";
        }
        org.geotools.styling.Stroke strokeTmp = polygonSymbolizer.getStroke();
        if (strokeTmp != null) {
            this.stroke = strokeTmp;
        } else {
            polygonSymbolizer.setStroke((Stroke)this.stroke);
        }
        Expression color = this.stroke.getColor();
        if (color != null) {
            this.strokeColor = this.expressionToString(color);
        } else {
            this.strokeColor = "#000000";
            this.stroke.setColor((Expression)StyleUtilities.ff.literal((Object)"#000000"));
        }
        Expression width = this.stroke.getWidth();
        if (width != null) {
            this.strokeWidth = this.expressionToString(width);
        } else {
            this.strokeWidth = "1";
            this.stroke.setWidth((Expression)StyleUtilities.ff.literal((Object)"1"));
        }
        Expression opacity = this.stroke.getOpacity();
        if (opacity != null) {
            this.strokeOpacity = this.expressionToString(opacity);
        } else {
            this.strokeOpacity = "1";
            this.stroke.setOpacity((Expression)StyleUtilities.ff.literal((Object)"1"));
        }
        this.strokeGraphicStroke = this.stroke.getGraphicStroke();
        if (this.strokeGraphicStroke != null && (graphicalSymbolsList2 = this.strokeGraphicStroke.graphicalSymbols()).size() > 0 && (graphicalSymbol = (GraphicalSymbol)graphicalSymbolsList2.get(0)) instanceof ExternalGraphic) {
            this.strokeExternalGraphicStroke = (ExternalGraphic)graphicalSymbol;
        }
        this.dash = (dashArray = this.stroke.getDashArray()) != null ? StyleUtilities.getDashString(dashArray) : "";
        this.dashOffset = (String)this.stroke.getDashOffset().evaluate(null, String.class);
        this.lineCap = (String)this.stroke.getLineCap().evaluate(null, String.class);
        this.lineJoin = (String)this.stroke.getLineJoin().evaluate(null, String.class);
        Fill fillTmp = polygonSymbolizer.getFill();
        if (fillTmp != null) {
            this.fill = fillTmp;
        } else {
            polygonSymbolizer.setFill((org.opengis.style.Fill)this.fill);
        }
        Expression fcolor = this.fill.getColor();
        if (fcolor != null) {
            this.fillColor = this.expressionToString(fcolor);
        } else {
            this.fill.setColor((Expression)StyleUtilities.ff.literal((Object)this.fillColor));
        }
        Expression fopacity = this.fill.getOpacity();
        if (fopacity != null) {
            this.fillOpacity = this.expressionToString(fopacity);
        } else {
            this.fill.setOpacity((Expression)StyleUtilities.ff.literal((Object)this.fillOpacity));
        }
        this.fillGraphicFill = this.fill.getGraphicFill();
        if (this.fillGraphicFill != null && (graphicalSymbolsList = this.fillGraphicFill.graphicalSymbols()).size() > 0) {
            GraphicalSymbol graphicalSymbol2 = (GraphicalSymbol)graphicalSymbolsList.get(0);
            if (graphicalSymbol2 instanceof ExternalGraphic) {
                this.fillExternalGraphicFill = (ExternalGraphic)graphicalSymbol2;
            } else if (graphicalSymbol2 instanceof Mark) {
                this.mark = (Mark)graphicalSymbol2;
                this.wkMarkNameFill = (String)this.mark.getWellKnownName().evaluate(null, String.class);
                org.geotools.styling.Stroke stroke = this.mark.getStroke();
                this.wkMarkColorFill = (String)stroke.getColor().evaluate(null, String.class);
                this.wkMarkWidthFill = (String)stroke.getWidth().evaluate(null, String.class);
                this.wkMarkSizeFill = (String)this.fillGraphicFill.getSize().evaluate(null, String.class);
            }
        }
    }

    private void checkFillExists() {
        if (this.fill == null) {
            if (this.fillColor == null) {
                this.fillColor = "#000000";
            }
            this.fill = StyleUtilities.sf.createFill((Expression)StyleUtilities.ff.literal((Object)this.fillColor));
            PolygonSymbolizer polygonSymbolizer = (PolygonSymbolizer)this.getSymbolizer();
            polygonSymbolizer.setFill((org.opengis.style.Fill)this.fill);
            this.fillGraphicFill = this.fill.getGraphicFill();
        }
    }

    private void checkMarkExists() {
        if (this.mark == null) {
            this.mark = StyleUtilities.sf.createMark();
            this.checkFillExists();
            if (this.fillGraphicFill == null) {
                this.fillGraphicFill = StyleUtilities.sf.createDefaultGraphic();
                this.fill.setGraphicFill((org.opengis.style.Graphic)this.fillGraphicFill);
            }
            this.fillGraphicFill.graphicalSymbols().clear();
            this.fillGraphicFill.graphicalSymbols().add(this.mark);
        }
    }

    public Graphic getFillGraphicFill() {
        return this.fillGraphicFill;
    }

    public void setFillGraphicFill(Graphic fillGraphicFill) {
        this.fillGraphicFill = fillGraphicFill;
        this.checkFillExists();
        this.fill.setGraphicFill((org.opengis.style.Graphic)fillGraphicFill);
    }

    protected void checkStrokeExists() {
        if (this.stroke == null) {
            if (this.strokeColor == null) {
                this.strokeColor = "#000000";
            }
            if (this.strokeWidth == null) {
                this.strokeWidth = "1";
            }
            this.stroke = StyleUtilities.sf.createStroke((Expression)StyleUtilities.ff.literal((Object)this.strokeColor), (Expression)StyleUtilities.ff.literal((Object)this.strokeWidth));
            PolygonSymbolizer polygonSymbolizer = (PolygonSymbolizer)this.getSymbolizer();
            polygonSymbolizer.setStroke((Stroke)this.stroke);
            this.strokeGraphicStroke = this.stroke.getGraphicStroke();
        }
    }

    public void setFillColor(String fillColor, boolean isProperty) {
        this.fillColor = fillColor;
        this.checkFillExists();
        this.fill.setGraphicFill(null);
        this.fillGraphicFill = null;
        if (isProperty) {
            this.fill.setColor((Expression)StyleUtilities.ff.property(fillColor));
        } else {
            this.fill.setColor((Expression)StyleUtilities.ff.literal((Object)fillColor));
        }
    }

    public void setFillOpacity(String fillOpacity, boolean isProperty) {
        this.fillOpacity = fillOpacity;
        this.checkFillExists();
        if (isProperty) {
            this.fill.setOpacity((Expression)StyleUtilities.ff.property(fillOpacity));
        } else {
            this.fill.setOpacity((Expression)StyleUtilities.ff.literal((Object)fillOpacity));
        }
    }

    public void clearGraphics() {
        this.wkMarkColorFill = null;
        this.wkMarkNameFill = null;
        this.wkMarkSizeFill = null;
        this.wkMarkWidthFill = null;
        if (this.fillGraphicFill != null) {
            this.fillGraphicFill.graphicalSymbols().clear();
        }
        this.mark = null;
    }

    public void setWkMarkNameFill(String wkMarkNameFill) {
        this.wkMarkNameFill = wkMarkNameFill;
        this.checkMarkExists();
        if (wkMarkNameFill != null) {
            this.mark.setWellKnownName((Expression)StyleUtilities.ff.literal((Object)wkMarkNameFill));
        }
    }

    public void setWkMarkColorFill(String wkMarkColorFill) {
        this.wkMarkColorFill = wkMarkColorFill;
        this.checkMarkExists();
        if (wkMarkColorFill != null) {
            org.geotools.styling.Stroke markStroke = this.mark.getStroke();
            markStroke.setColor((Expression)StyleUtilities.ff.literal((Object)wkMarkColorFill));
        }
    }

    public void setWkMarkWidthFill(String wkMarkWidthFill) {
        this.wkMarkWidthFill = wkMarkWidthFill;
        this.checkMarkExists();
        if (wkMarkWidthFill != null) {
            org.geotools.styling.Stroke markStroke = this.mark.getStroke();
            markStroke.setWidth((Expression)StyleUtilities.ff.literal((Object)wkMarkWidthFill));
        }
    }

    public void setWkMarkSizeFill(String wkMarkSizeFill) {
        this.wkMarkSizeFill = wkMarkSizeFill;
        this.checkFillExists();
        this.fillGraphicFill.setSize((Expression)StyleUtilities.ff.literal((Object)wkMarkSizeFill));
    }

    public String getFillColor() {
        return this.fillColor;
    }

    public String getFillOpacity() {
        return this.fillOpacity;
    }

    public String getWkMarkNameFill() {
        return this.wkMarkNameFill;
    }

    public String getWkMarkColorFill() {
        return this.wkMarkColorFill;
    }

    public String getWkMarkWidthFill() {
        return this.wkMarkWidthFill;
    }

    public String getWkMarkSizeFill() {
        return this.wkMarkSizeFill;
    }
}

