/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.style;

import java.util.ArrayList;
import java.util.List;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.hortonmachine.gears.utils.geometry.EGeometryType;
import org.hortonmachine.gears.utils.style.FeatureTypeStyleWrapper;
import org.hortonmachine.gears.utils.style.LineSymbolizerWrapper;
import org.hortonmachine.gears.utils.style.PointSymbolizerWrapper;
import org.hortonmachine.gears.utils.style.PolygonSymbolizerWrapper;
import org.hortonmachine.gears.utils.style.RasterSymbolizerWrapper;
import org.hortonmachine.gears.utils.style.StyleUtilities;
import org.hortonmachine.gears.utils.style.SymbolizerWrapper;
import org.hortonmachine.gears.utils.style.TextSymbolizerWrapper;

public class RuleWrapper {
    private Rule rule;
    private String name;
    private String maxScale;
    private String minScale;
    private List<SymbolizerWrapper> symbolizersWrapperList = new ArrayList<SymbolizerWrapper>();
    private final FeatureTypeStyleWrapper parent;

    public RuleWrapper(Rule rule, FeatureTypeStyleWrapper parent) {
        this.rule = rule;
        this.parent = parent;
        this.name = rule.getName();
        try {
            this.maxScale = String.valueOf(rule.getMaxScaleDenominator());
            this.minScale = String.valueOf(rule.getMinScaleDenominator());
        }
        catch (Exception e) {
            this.maxScale = "infinity";
            this.minScale = "0";
        }
        List symbolizers = rule.symbolizers();
        for (Symbolizer symbolizer : symbolizers) {
            SymbolizerWrapper wrapper = this.getWrapper(symbolizer);
            this.symbolizersWrapperList.add(wrapper);
        }
    }

    public FeatureTypeStyleWrapper getParent() {
        return this.parent;
    }

    public Rule getRule() {
        return this.rule;
    }

    private SymbolizerWrapper getWrapper(Symbolizer symbolizer) {
        SymbolizerWrapper symbolizerWrapper = null;
        if (symbolizer instanceof PointSymbolizer) {
            symbolizerWrapper = new PointSymbolizerWrapper(symbolizer, this);
        } else if (symbolizer instanceof LineSymbolizer) {
            symbolizerWrapper = new LineSymbolizerWrapper(symbolizer, this);
        } else if (symbolizer instanceof PolygonSymbolizer) {
            symbolizerWrapper = new PolygonSymbolizerWrapper(symbolizer, this);
        } else if (symbolizer instanceof TextSymbolizer) {
            symbolizerWrapper = new TextSymbolizerWrapper(symbolizer, this, this.getType());
        } else if (symbolizer instanceof RasterSymbolizer) {
            symbolizerWrapper = new RasterSymbolizerWrapper(symbolizer, this);
        }
        return symbolizerWrapper;
    }

    public EGeometryType getType() {
        SymbolizerWrapper geometrySymbolizersWrapper = this.getGeometrySymbolizersWrapper();
        if (geometrySymbolizersWrapper == null) {
            return null;
        }
        Symbolizer symbolizer = geometrySymbolizersWrapper.getSymbolizer();
        if (symbolizer instanceof PointSymbolizer) {
            return EGeometryType.POINT;
        }
        if (symbolizer instanceof LineSymbolizer) {
            return EGeometryType.LINESTRING;
        }
        if (symbolizer instanceof PolygonSymbolizer) {
            return EGeometryType.POLYGON;
        }
        if (symbolizer instanceof RasterSymbolizer) {
            throw new RuntimeException("Not implemented yet!");
        }
        return null;
    }

    public SymbolizerWrapper getGeometrySymbolizersWrapper() {
        for (SymbolizerWrapper symbolizerWrapper : this.symbolizersWrapperList) {
            if (symbolizerWrapper.isTextSymbolizer()) continue;
            return symbolizerWrapper;
        }
        return null;
    }

    public TextSymbolizerWrapper getTextSymbolizersWrapper() {
        for (SymbolizerWrapper symbolizerWrapper : this.symbolizersWrapperList) {
            if (!symbolizerWrapper.isTextSymbolizer()) continue;
            return (TextSymbolizerWrapper)symbolizerWrapper;
        }
        return null;
    }

    public void removeTextSymbolizersWrapper() {
        ArrayList<SymbolizerWrapper> removeSW = new ArrayList<SymbolizerWrapper>();
        ArrayList<Symbolizer> removeS = new ArrayList<Symbolizer>();
        List symbolizers = this.rule.symbolizers();
        for (SymbolizerWrapper symbolizerWrapper : this.symbolizersWrapperList) {
            if (!symbolizerWrapper.isTextSymbolizer()) continue;
            Symbolizer symbolizer = symbolizerWrapper.getSymbolizer();
            removeSW.add(symbolizerWrapper);
            removeS.add(symbolizer);
        }
        this.symbolizersWrapperList.removeAll(removeSW);
        symbolizers.removeAll(removeS);
    }

    public void removeSymbolizerWrapper(SymbolizerWrapper symbolizerWrapperToRem) {
        this.symbolizersWrapperList.remove(symbolizerWrapperToRem);
        List symbolizers = this.rule.symbolizers();
        symbolizers.remove(symbolizerWrapperToRem.getSymbolizer());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T addSymbolizer(Symbolizer newSymbolizer, Class<T> symbolizerClass) {
        void var3_14;
        Object var3_3 = null;
        if (newSymbolizer != null) {
            if (newSymbolizer instanceof PointSymbolizer) {
                PointSymbolizerWrapper pointSymbolizerWrapper = new PointSymbolizerWrapper(newSymbolizer, this);
            } else if (newSymbolizer instanceof LineSymbolizer) {
                LineSymbolizerWrapper lineSymbolizerWrapper = new LineSymbolizerWrapper(newSymbolizer, this);
            } else if (newSymbolizer instanceof PolygonSymbolizer) {
                PolygonSymbolizerWrapper polygonSymbolizerWrapper = new PolygonSymbolizerWrapper(newSymbolizer, this);
            } else if (newSymbolizer instanceof TextSymbolizer) {
                TextSymbolizerWrapper textSymbolizerWrapper = new TextSymbolizerWrapper(newSymbolizer, this, this.getType());
            } else {
                if (!(newSymbolizer instanceof RasterSymbolizer)) return null;
                RasterSymbolizerWrapper rasterSymbolizerWrapper = new RasterSymbolizerWrapper(newSymbolizer, this);
            }
        } else if (symbolizerClass.isAssignableFrom(PointSymbolizerWrapper.class)) {
            newSymbolizer = StyleUtilities.sf.createPointSymbolizer();
            PointSymbolizerWrapper pointSymbolizerWrapper = new PointSymbolizerWrapper(newSymbolizer, this);
        } else if (symbolizerClass.isAssignableFrom(LineSymbolizerWrapper.class)) {
            newSymbolizer = StyleUtilities.sf.createLineSymbolizer();
            LineSymbolizerWrapper lineSymbolizerWrapper = new LineSymbolizerWrapper(newSymbolizer, this);
        } else if (symbolizerClass.isAssignableFrom(PolygonSymbolizerWrapper.class)) {
            newSymbolizer = StyleUtilities.sf.createPolygonSymbolizer();
            PolygonSymbolizerWrapper polygonSymbolizerWrapper = new PolygonSymbolizerWrapper(newSymbolizer, this);
        } else if (symbolizerClass.isAssignableFrom(TextSymbolizerWrapper.class)) {
            newSymbolizer = StyleUtilities.sf.createTextSymbolizer();
            TextSymbolizerWrapper textSymbolizerWrapper = new TextSymbolizerWrapper(newSymbolizer, this, this.getType());
        } else {
            if (!symbolizerClass.isAssignableFrom(RasterSymbolizer.class)) return null;
            RasterSymbolizerWrapper rasterSymbolizerWrapper = new RasterSymbolizerWrapper(newSymbolizer, this);
        }
        this.rule.symbolizers().add(newSymbolizer);
        this.symbolizersWrapperList.add((SymbolizerWrapper)var3_14);
        return symbolizerClass.cast(var3_14);
    }

    public void clear() {
        this.rule.symbolizers().clear();
        this.symbolizersWrapperList.clear();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.rule.setName(name);
    }

    public String getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(String maxScale) {
        this.maxScale = maxScale;
        try {
            this.rule.setMaxScaleDenominator(Double.parseDouble(maxScale));
        }
        catch (Exception e) {
            this.rule.setMaxScaleDenominator(Double.POSITIVE_INFINITY);
        }
    }

    public String getMinScale() {
        return this.minScale;
    }

    public void setMinScale(String minScale) {
        this.minScale = minScale;
        try {
            this.rule.setMinScaleDenominator(Double.parseDouble(minScale));
        }
        catch (Exception e) {
            this.rule.setMinScaleDenominator(Double.parseDouble("0"));
        }
    }

    public String toString() {
        return this.name;
    }

    public RasterSymbolizerWrapper getRasterSymbolizer() {
        for (SymbolizerWrapper symbolizerWrapper : this.symbolizersWrapperList) {
            if (!(symbolizerWrapper instanceof RasterSymbolizerWrapper)) continue;
            return (RasterSymbolizerWrapper)symbolizerWrapper;
        }
        return null;
    }
}

