/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.style;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.IsEqualsToImpl;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.function.FilterFunction_offset;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.UserLayer;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.xml.styling.SLDParser;
import org.geotools.xml.styling.SLDTransformer;
import org.hortonmachine.dbs.utils.BasicStyle;
import org.hortonmachine.gears.utils.SldUtilities;
import org.hortonmachine.gears.utils.geometry.EGeometryType;
import org.hortonmachine.gears.utils.style.FeatureTypeStyleWrapper;
import org.hortonmachine.gears.utils.style.LineSymbolizerWrapper;
import org.hortonmachine.gears.utils.style.PointSymbolizerWrapper;
import org.hortonmachine.gears.utils.style.PolygonSymbolizerWrapper;
import org.hortonmachine.gears.utils.style.RuleWrapper;
import org.hortonmachine.gears.utils.style.StyleWrapper;
import org.hortonmachine.gears.utils.style.SymbolizerWrapper;
import org.hortonmachine.gears.utils.style.TextSymbolizerWrapper;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.style.Fill;
import org.opengis.style.GraphicalSymbol;

public class StyleUtilities {
    public static final String NONE = "- none -";
    public static final String DEFAULT_SIZE = "5";
    public static final String DEFAULT_WIDTH = "1";
    public static final String DEFAULT_ROTATION = "0";
    public static final String DEFAULT_OFFSET = "0";
    public static final String DEFAULT_OPACITY = "1";
    public static final String DEFAULT_COLOR = "#000000";
    public static final String DEFAULT_MINSCALE = "0";
    public static final String DEFAULT_MAXSCALE = "infinity";
    public static final int OFFSET_MAX = 1000;
    public static final int OFFSET_MIN = -1000;
    public static final int OFFSET_STEP = 10;
    public static final int DISPLACEMENT_MAX = 1000;
    public static final int DISPLACEMENT_MIN = -1000;
    public static final int DISPLACEMENT_STEP = 10;
    public static final String DEFAULT_GROUPNAME = "group ";
    public static final String DEFAULT_STYLENAME = "default style";
    public static final String SLD_EXTENTION = ".sld";
    public static final String[] wkMarkDefs = new String[]{"", "cross", "circle", "triangle", "X", "star", "arrow", "hatch", "square"};
    public static final String[] wkMarkNames = new String[]{"", "cross", "circle", "triangle", "X", "star", "arrow", "hatch", "square"};
    public static final String SHAPE_PREFIX = "shape://";
    public static final String[] shapeMarkDefs = new String[]{"", "shape://vertline", "shape://horline", "shape://slash", "shape://backslash", "shape://times", "shape://dot", "shape://plus"};
    public static final String[] shapeMarkNames = new String[]{"", "vertical lines", "horizontal lines", "diagonal lines", "inverse diagonal lines", "crossed diagonal lines", "dots", "plus"};
    public static final HashMap<String, String> markNamesToDef = new HashMap();
    public static final String[] lineCapNames;
    public static final String[] verticalPlacementNames;
    public static final String[] lineJoinNames;
    public static final HashMap<String, String> lineEndStyles;
    public static StyleFactory sf;
    public static FilterFactory ff;
    public static StyleBuilder sb;

    public static String[] getAllMarksArray() {
        Set<String> keySet = markNamesToDef.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public static StyledLayerDescriptor readStyle(File file) throws IOException {
        SLDParser stylereader = new SLDParser(sf, file);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        return sld;
    }

    public static List<ExternalGraphic> externalGraphicsFromRule(Rule rule) {
        ArrayList<ExternalGraphic> gList = new ArrayList<ExternalGraphic>();
        List symbolizers = rule.symbolizers();
        if (symbolizers.size() != 0) {
            for (Symbolizer symbolizer : symbolizers) {
                Stroke stroke;
                Graphic[] graphics = new Graphic[2];
                if (symbolizer instanceof PointSymbolizer) {
                    PointSymbolizer pointSymbolizer = (PointSymbolizer)symbolizer;
                    graphics[0] = pointSymbolizer.getGraphic();
                } else if (symbolizer instanceof LineSymbolizer) {
                    LineSymbolizer lineSymbolizer = (LineSymbolizer)symbolizer;
                    stroke = lineSymbolizer.getStroke();
                    graphics[0] = stroke.getGraphicStroke();
                } else if (symbolizer instanceof PolygonSymbolizer) {
                    org.geotools.styling.Fill fill;
                    PolygonSymbolizer polygonSymbolizer = (PolygonSymbolizer)symbolizer;
                    stroke = polygonSymbolizer.getStroke();
                    if (stroke != null) {
                        graphics[0] = stroke.getGraphicStroke();
                    }
                    if ((fill = polygonSymbolizer.getFill()) != null) {
                        graphics[1] = fill.getGraphicFill();
                    }
                }
                for (int i = 0; i < graphics.length; ++i) {
                    if (graphics[i] == null) continue;
                    for (GraphicalSymbol gs : graphics[i].graphicalSymbols()) {
                        if (gs == null || !(gs instanceof ExternalGraphic)) continue;
                        ExternalGraphic externalGraphic = (ExternalGraphic)gs;
                        gList.add(externalGraphic);
                    }
                }
            }
            return gList;
        }
        return Collections.emptyList();
    }

    public static List<ExternalGraphic> externalGraphicsFromGraphic(Graphic graphic) {
        ArrayList<ExternalGraphic> gList = new ArrayList<ExternalGraphic>();
        for (GraphicalSymbol gs : graphic.graphicalSymbols()) {
            if (gs == null || !(gs instanceof ExternalGraphic)) continue;
            ExternalGraphic externalGraphic = (ExternalGraphic)gs;
            gList.add(externalGraphic);
        }
        return gList;
    }

    public static Style createDefaultStyle(SimpleFeatureCollection featureCollection) {
        GeometryDescriptor geometryDescriptor = ((SimpleFeatureType)featureCollection.getSchema()).getGeometryDescriptor();
        Style style = null;
        if (EGeometryType.isPoint(geometryDescriptor)) {
            style = StyleUtilities.createDefaultPointStyle();
        } else if (EGeometryType.isLine(geometryDescriptor)) {
            style = StyleUtilities.createDefaultLineStyle();
        } else if (EGeometryType.isPolygon(geometryDescriptor)) {
            style = StyleUtilities.createDefaultPolygonStyle();
        }
        if (style != null) {
            style.setName(((SimpleFeatureType)featureCollection.getSchema()).getTypeName());
        }
        return style;
    }

    public static Style createDefaultPointStyle() {
        FeatureTypeStyle featureTypeStyle = sf.createFeatureTypeStyle();
        featureTypeStyle.rules().add(StyleUtilities.createDefaultPointRule());
        Style style = sf.createStyle();
        style.featureTypeStyles().add(featureTypeStyle);
        return style;
    }

    public static Rule createDefaultPointRule() {
        Graphic graphic = sf.createDefaultGraphic();
        Mark circleMark = sf.getCircleMark();
        circleMark.setFill((Fill)sf.createFill((Expression)ff.literal((Object)("#" + Integer.toHexString(Color.RED.getRGB() & 0xFFFFFF)))));
        circleMark.setStroke((org.opengis.style.Stroke)sf.createStroke((Expression)ff.literal((Object)("#" + Integer.toHexString(Color.BLACK.getRGB() & 0xFFFFFF))), (Expression)ff.literal((Object)"1")));
        graphic.graphicalSymbols().clear();
        graphic.graphicalSymbols().add(circleMark);
        graphic.setSize((Expression)ff.literal((Object)DEFAULT_SIZE));
        PointSymbolizer pointSymbolizer = sf.createPointSymbolizer();
        Rule rule = sf.createRule();
        rule.setName("New rule");
        rule.symbolizers().add(pointSymbolizer);
        pointSymbolizer.setGraphic((org.opengis.style.Graphic)graphic);
        return rule;
    }

    public static Style createDefaultPolygonStyle() {
        FeatureTypeStyle featureTypeStyle = sf.createFeatureTypeStyle();
        featureTypeStyle.rules().add(StyleUtilities.createDefaultPolygonRule());
        Style style = sf.createStyle();
        style.featureTypeStyles().add(featureTypeStyle);
        return style;
    }

    public static Rule createDefaultPolygonRule() {
        PolygonSymbolizer polygonSymbolizer = sf.createPolygonSymbolizer();
        org.geotools.styling.Fill fill = StyleUtilities.createDefaultFill();
        polygonSymbolizer.setFill((Fill)fill);
        polygonSymbolizer.setStroke((org.opengis.style.Stroke)StyleUtilities.createDefaultStroke());
        Rule rule = sf.createRule();
        rule.setName("New rule");
        rule.symbolizers().add(polygonSymbolizer);
        return rule;
    }

    public static org.geotools.styling.Fill createDefaultFill() {
        org.geotools.styling.Fill fill = sf.createFill((Expression)ff.literal((Object)("#" + Integer.toHexString(Color.RED.getRGB() & 0xFFFFFF))));
        fill.setOpacity((Expression)ff.literal(0.5));
        return fill;
    }

    public static Style createDefaultLineStyle() {
        FeatureTypeStyle featureTypeStyle = sf.createFeatureTypeStyle();
        featureTypeStyle.rules().add(StyleUtilities.createDefaultLineRule());
        Style style = sf.createStyle();
        style.featureTypeStyles().add(featureTypeStyle);
        return style;
    }

    public static Rule createDefaultLineRule() {
        LineSymbolizer lineSymbolizer = sf.createLineSymbolizer();
        lineSymbolizer.setStroke((org.opengis.style.Stroke)StyleUtilities.createDefaultStroke());
        Rule rule = sf.createRule();
        rule.setName("New rule");
        rule.symbolizers().add(lineSymbolizer);
        return rule;
    }

    public static Stroke createDefaultStroke() {
        return sf.createStroke((Expression)ff.literal((Object)("#" + Integer.toHexString(Color.BLACK.getRGB() & 0xFFFFFF))), (Expression)ff.literal(1));
    }

    public static PointSymbolizer pointSymbolizerFromRule(Rule rule) {
        List symbolizers = rule.symbolizers();
        PointSymbolizer pointSymbolizer = null;
        for (Symbolizer symbolizer : symbolizers) {
            if (!(symbolizer instanceof PointSymbolizer)) continue;
            pointSymbolizer = (PointSymbolizer)symbolizer;
            break;
        }
        if (pointSymbolizer == null) {
            throw new IllegalArgumentException();
        }
        return pointSymbolizer;
    }

    public static PolygonSymbolizer polygonSymbolizerFromRule(Rule rule) {
        List symbolizers = rule.symbolizers();
        PolygonSymbolizer polygonSymbolizer = null;
        for (Symbolizer symbolizer : symbolizers) {
            if (!(symbolizer instanceof PolygonSymbolizer)) continue;
            polygonSymbolizer = (PolygonSymbolizer)symbolizer;
            break;
        }
        if (polygonSymbolizer == null) {
            throw new IllegalArgumentException();
        }
        return polygonSymbolizer;
    }

    public static LineSymbolizer lineSymbolizerFromRule(Rule rule) {
        List symbolizers = rule.symbolizers();
        LineSymbolizer lineSymbolizer = null;
        for (Symbolizer symbolizer : symbolizers) {
            if (!(symbolizer instanceof LineSymbolizer)) continue;
            lineSymbolizer = (LineSymbolizer)symbolizer;
            break;
        }
        if (lineSymbolizer == null) {
            throw new IllegalArgumentException();
        }
        return lineSymbolizer;
    }

    public static void substituteMark(Rule rule, String wellKnownMarkName) {
        PointSymbolizer pointSymbolizer = StyleUtilities.pointSymbolizerFromRule(rule);
        Mark oldMark = SLD.mark((PointSymbolizer)pointSymbolizer);
        Graphic graphic = SLD.graphic((PointSymbolizer)pointSymbolizer);
        graphic.graphicalSymbols().clear();
        Mark mark = sf.createMark();
        mark.setWellKnownName((Expression)ff.literal((Object)wellKnownMarkName));
        if (oldMark != null) {
            mark.setFill((Fill)oldMark.getFill());
            mark.setStroke((org.opengis.style.Stroke)oldMark.getStroke());
        }
        graphic.graphicalSymbols().add(mark);
    }

    public static void substituteExternalGraphics(Rule rule, URL externalGraphicsUrl) {
        String urlString = externalGraphicsUrl.toString();
        String format = "";
        if (urlString.toLowerCase().endsWith(".png")) {
            format = "image/png";
        } else if (urlString.toLowerCase().endsWith(".jpg")) {
            format = "image/jpg";
        } else if (urlString.toLowerCase().endsWith(".svg")) {
            format = "image/svg+xml";
        } else {
            urlString = "";
            try {
                externalGraphicsUrl = new URL("file:");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        PointSymbolizer pointSymbolizer = StyleUtilities.pointSymbolizerFromRule(rule);
        Graphic graphic = SLD.graphic((PointSymbolizer)pointSymbolizer);
        graphic.graphicalSymbols().clear();
        ExternalGraphic exGraphic = sf.createExternalGraphic(externalGraphicsUrl, format);
        graphic.graphicalSymbols().add(exGraphic);
    }

    public static String getFormat(String path) {
        String format = "";
        if (path.toLowerCase().endsWith(".png")) {
            format = "image/png";
        } else if (path.toLowerCase().endsWith(".jpg")) {
            format = "image/jpg";
        } else if (path.toLowerCase().endsWith(".gif")) {
            format = "image/gif";
        } else if (path.toLowerCase().endsWith(".svg")) {
            format = "image/svg+xml";
        }
        return format;
    }

    public static String getExternalGraphicFormat(String name) {
        String format = "";
        if (name.toLowerCase().endsWith(".png")) {
            format = "image/png";
        } else if (name.toLowerCase().endsWith(".jpg")) {
            format = "image/jpg";
        } else if (name.toLowerCase().endsWith(".gif")) {
            format = "image/gif";
        } else if (name.toLowerCase().endsWith(".svg")) {
            format = "image/svg+xml";
        } else {
            return null;
        }
        return format;
    }

    public static void changeMarkSize(Rule rule, int newSize) {
        PointSymbolizer pointSymbolizer = StyleUtilities.pointSymbolizerFromRule(rule);
        Graphic graphic = SLD.graphic((PointSymbolizer)pointSymbolizer);
        graphic.setSize((Expression)ff.literal(newSize));
    }

    public static void changeRotation(Rule rule, int newRotation) {
        PointSymbolizer pointSymbolizer = StyleUtilities.pointSymbolizerFromRule(rule);
        Graphic graphic = SLD.graphic((PointSymbolizer)pointSymbolizer);
        graphic.setRotation((Expression)ff.literal(newRotation));
    }

    public static Point2D getOffset(Symbolizer symbolizer) {
        Expression geometry = symbolizer.getGeometry();
        if (geometry != null && geometry instanceof FilterFunction_offset) {
            FilterFunction_offset offsetFunction = (FilterFunction_offset)geometry;
            List parameters = offsetFunction.getParameters();
            Expression xOffsetExpr = (Expression)parameters.get(1);
            Expression yOffsetExpr = (Expression)parameters.get(2);
            Double xOffsetDouble = (Double)xOffsetExpr.evaluate(null, Double.class);
            Double yOffsetDouble = (Double)yOffsetExpr.evaluate(null, Double.class);
            if (xOffsetDouble != null && yOffsetDouble != null) {
                Point2D.Double point = new Point2D.Double(xOffsetDouble, yOffsetDouble);
                return point;
            }
        }
        return null;
    }

    public static void setOffset(Symbolizer symbolizer, String text) {
        if (text.indexOf(44) == -1) {
            return;
        }
        String[] split = text.split(",");
        if (split.length != 2) {
            return;
        }
        double xOffset = Double.parseDouble(split[0]);
        double yOffset = Double.parseDouble(split[1]);
        Expression geometry = symbolizer.getGeometry();
        if (geometry != null) {
            if (geometry instanceof FilterFunction_offset) {
                FilterFunction_offset offsetFunction = (FilterFunction_offset)geometry;
                List parameters = offsetFunction.getParameters();
                parameters.set(1, ff.literal(xOffset));
                parameters.set(2, ff.literal(yOffset));
            }
        } else {
            Function function = ff.function("offset", new Expression[]{ff.property("the_geom"), ff.literal(xOffset), ff.literal(yOffset)});
            symbolizer.setGeometry((Expression)function);
        }
    }

    public static String checkSameNameRule(List<RuleWrapper> rulesWrapper, String ruleName) {
        int index = 1;
        Object name = ruleName.trim();
        for (int i = 0; i < rulesWrapper.size(); ++i) {
            RuleWrapper ruleWrapper = rulesWrapper.get(i);
            String tmpName = ruleWrapper.getName();
            if (tmpName == null) continue;
            if ((tmpName = tmpName.trim()).equals(name)) {
                name = ((String)name).endsWith(")") ? ((String)name).trim().replaceFirst("\\([0-9]+\\)$", "(" + index++ + ")") : (String)name + " (" + index++ + ")";
                i = 0;
            }
            if (index != 1000) continue;
            throw new RuntimeException();
        }
        return name;
    }

    public static String checkSameNameFeatureTypeStyle(List<FeatureTypeStyleWrapper> ftsWrapperList, String ftsName) {
        int index = 1;
        Object name = ftsName.trim();
        for (int i = 0; i < ftsWrapperList.size(); ++i) {
            FeatureTypeStyleWrapper ftsWrapper = ftsWrapperList.get(i);
            String tmpName = ftsWrapper.getName();
            if (tmpName == null) continue;
            if ((tmpName = tmpName.trim()).equals(name)) {
                name = ((String)name).endsWith(")") ? ((String)name).trim().replaceFirst("\\([0-9]+\\)$", "(" + index++ + ")") : (String)name + " (" + index++ + ")";
                i = 0;
            }
            if (index != 1000) continue;
            throw new RuntimeException();
        }
        return name;
    }

    public static String checkSameNameStyle(List<StyleWrapper> styles, String styleName) {
        int index = 1;
        Object name = styleName.trim();
        for (int i = 0; i < styles.size(); ++i) {
            StyleWrapper styleWrapper = styles.get(i);
            String tmpName = styleWrapper.getName();
            if (tmpName == null) continue;
            if ((tmpName = tmpName.trim()).equals(name)) {
                name = ((String)name).endsWith(")") ? ((String)name).trim().replaceFirst("\\([0-9]+\\)$", "(" + index++ + ")") : (String)name + " (" + index++ + ")";
                i = 0;
            }
            if (index != 1000) continue;
            throw new RuntimeException();
        }
        return name;
    }

    public static Style rulesToStyle(List<Rule> rules, String name, boolean oneFeaturetypestylePerRule) {
        Style namedStyle = sf.createStyle();
        if (!oneFeaturetypestylePerRule) {
            FeatureTypeStyle featureTypeStyle = sf.createFeatureTypeStyle();
            List currentRules = featureTypeStyle.rules();
            for (int i = 0; i < rules.size(); ++i) {
                Rule rule = rules.get(i);
                currentRules.add(rule);
            }
            namedStyle.featureTypeStyles().add(featureTypeStyle);
        } else {
            for (int i = 0; i < rules.size(); ++i) {
                FeatureTypeStyle featureTypeStyle = sf.createFeatureTypeStyle();
                Rule rule = rules.get(i);
                featureTypeStyle.rules().add(rule);
                namedStyle.featureTypeStyles().add(featureTypeStyle);
            }
        }
        namedStyle.setName(name);
        return namedStyle;
    }

    public static String styleToString(Style style) throws Exception {
        StyledLayerDescriptor sld = sf.createStyledLayerDescriptor();
        UserLayer layer = sf.createUserLayer();
        layer.setLayerFeatureConstraints(new FeatureTypeConstraint[]{null});
        sld.addStyledLayer((StyledLayer)layer);
        layer.addUserStyle(style);
        SLDTransformer aTransformer = new SLDTransformer();
        aTransformer.setIndentation(4);
        String xml = aTransformer.transform((Object)sld);
        return xml;
    }

    public static StyleWrapper createStyleFromGraphic(File graphicsPath) throws IOException {
        String name = graphicsPath.getName();
        ExternalGraphic exGraphic = null;
        if (name.toLowerCase().endsWith(".png")) {
            exGraphic = sf.createExternalGraphic(graphicsPath.toURI().toURL(), "image/png");
        } else if (name.toLowerCase().endsWith(".svg")) {
            exGraphic = sf.createExternalGraphic(graphicsPath.toURI().toURL(), "image/svg+xml");
        } else if (name.toLowerCase().endsWith(SLD_EXTENTION)) {
            StyledLayerDescriptor sld = StyleUtilities.readStyle(graphicsPath);
            Style style = SldUtilities.getDefaultStyle(sld);
            return new StyleWrapper(style);
        }
        if (exGraphic == null) {
            throw new IOException("Style could not be created!");
        }
        Graphic gr = sf.createDefaultGraphic();
        gr.graphicalSymbols().clear();
        gr.graphicalSymbols().add(exGraphic);
        Literal size = ff.literal(20);
        gr.setSize((Expression)size);
        Rule rule = sf.createRule();
        PointSymbolizer pointSymbolizer = sf.createPointSymbolizer(gr, null);
        rule.symbolizers().add(pointSymbolizer);
        FeatureTypeStyle featureTypeStyle = sf.createFeatureTypeStyle();
        featureTypeStyle.rules().add(rule);
        Style namedStyle = sf.createStyle();
        namedStyle.featureTypeStyles().add(featureTypeStyle);
        namedStyle.setName(FilenameUtils.removeExtension((String)name));
        return new StyleWrapper(namedStyle);
    }

    public static float[] getDash(String dashStr) {
        if (dashStr == null) {
            return null;
        }
        String[] dashSplit = dashStr.split(",");
        int size = dashSplit.length;
        float[] dash = new float[size];
        try {
            for (int i = 0; i < dash.length; ++i) {
                dash[i] = Float.parseFloat(dashSplit[i].trim());
            }
            return dash;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String getDashString(float[] dashArray) {
        StringBuilder sb = null;
        for (float f : dashArray) {
            if (sb == null) {
                sb = new StringBuilder(String.valueOf(f));
                continue;
            }
            sb.append(",");
            sb.append(String.valueOf(f));
        }
        return sb.toString();
    }

    public static <T extends Number> T isNumber(String value, Class<T> adaptee) {
        if (value == null) {
            return null;
        }
        if (adaptee == null) {
            adaptee = Double.class;
        }
        if (adaptee.isAssignableFrom(Double.class)) {
            try {
                Double parsed = Double.parseDouble(value);
                return (T)((Number)adaptee.cast(parsed));
            }
            catch (Exception e) {
                return null;
            }
        }
        if (adaptee.isAssignableFrom(Float.class)) {
            try {
                Float parsed = Float.valueOf(Float.parseFloat(value));
                return (T)((Number)adaptee.cast(parsed));
            }
            catch (Exception e) {
                return null;
            }
        }
        if (adaptee.isAssignableFrom(Integer.class)) {
            try {
                Integer parsed = Integer.parseInt(value);
                return (T)((Number)adaptee.cast(parsed));
            }
            catch (Exception e) {
                Double number = StyleUtilities.isNumber(value, Double.class);
                if (number != null) {
                    return (T)((Number)adaptee.cast(number.intValue()));
                }
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int sld2awtJoin(String sldJoin) {
        if (sldJoin.equals(lineJoinNames[1])) {
            return 2;
        }
        if (sldJoin.equals("") || sldJoin.equals(lineJoinNames[2])) {
            return 0;
        }
        if (sldJoin.equals(lineJoinNames[3])) {
            return 1;
        }
        throw new IllegalArgumentException("unsupported line join");
    }

    public static int sld2awtCap(String sldCap) {
        if (sldCap.equals("") || sldCap.equals(lineCapNames[1])) {
            return 0;
        }
        if (sldCap.equals(lineCapNames[2])) {
            return 1;
        }
        if (sldCap.equals(lineCapNames[3])) {
            return 2;
        }
        throw new IllegalArgumentException("unsupported line cap");
    }

    public static BasicStyle getBasicStyle(Style style) throws Exception {
        BasicStyle basicStyle = new BasicStyle();
        StyleWrapper styleWrapper = new StyleWrapper(style);
        List<FeatureTypeStyleWrapper> featureTypeStylesWrapperList = styleWrapper.getFeatureTypeStylesWrapperList();
        if (featureTypeStylesWrapperList.size() > 0) {
            ArrayList<RuleWrapper> rulesWrapperList = new ArrayList<RuleWrapper>();
            for (FeatureTypeStyleWrapper ftsWrapper : featureTypeStylesWrapperList) {
                List<RuleWrapper> rulesWrappers = ftsWrapper.getRulesWrapperList();
                rulesWrapperList.addAll(rulesWrappers);
            }
            if (rulesWrapperList.size() == 1) {
                RuleWrapper ruleWrapper = (RuleWrapper)rulesWrapperList.get(0);
                SymbolizerWrapper geometrySymbolizersWrapper = ruleWrapper.getGeometrySymbolizersWrapper();
                if (geometrySymbolizersWrapper != null) {
                    basicStyle = StyleUtilities.createBaseStyle(rulesWrapperList);
                    StyleUtilities.populateStyleObject(basicStyle, geometrySymbolizersWrapper);
                }
            } else if (rulesWrapperList.size() > 1) {
                basicStyle = StyleUtilities.createBaseStyle(rulesWrapperList);
                basicStyle.themeMap = new HashMap();
                for (RuleWrapper ruleWrapper : rulesWrapperList) {
                    SymbolizerWrapper geometrySymbolizersWrapper = ruleWrapper.getGeometrySymbolizersWrapper();
                    BasicStyle themeStyle = StyleUtilities.createBaseStyle(rulesWrapperList);
                    StyleUtilities.populateStyleObject(themeStyle, geometrySymbolizersWrapper);
                    Filter filter = ruleWrapper.getRule().getFilter();
                    if (!(filter instanceof IsEqualsToImpl)) continue;
                    IsEqualsToImpl equalsFilter = (IsEqualsToImpl)filter;
                    Expression expression1 = equalsFilter.getExpression1();
                    Expression expression2 = equalsFilter.getExpression2();
                    StyleUtilities.setFilter(basicStyle, themeStyle, expression1);
                    StyleUtilities.setFilter(basicStyle, themeStyle, expression2);
                }
            }
        }
        return basicStyle;
    }

    private static void setFilter(BasicStyle mainStyle, BasicStyle themeStyle, Expression expression) {
        if (expression instanceof AttributeExpressionImpl) {
            AttributeExpressionImpl attr = (AttributeExpressionImpl)expression;
            mainStyle.themeField = attr.getPropertyName();
        } else if (expression instanceof LiteralExpressionImpl) {
            LiteralExpressionImpl attr = (LiteralExpressionImpl)expression;
            mainStyle.themeMap.put(attr.getValue().toString(), themeStyle);
        }
    }

    private static void populateStyleObject(BasicStyle gpStyle, SymbolizerWrapper geometrySymbolizersWrapper) {
        if (geometrySymbolizersWrapper instanceof PointSymbolizerWrapper) {
            PointSymbolizerWrapper psw = (PointSymbolizerWrapper)geometrySymbolizersWrapper;
            gpStyle.shape = psw.getMarkName();
            gpStyle.size = StyleUtilities.getDouble(psw.getSize(), gpStyle.size);
            gpStyle.width = StyleUtilities.getDouble(psw.getStrokeWidth(), gpStyle.width);
            gpStyle.strokealpha = StyleUtilities.getDouble(psw.getStrokeOpacity(), gpStyle.strokealpha);
            gpStyle.strokecolor = StyleUtilities.getString(psw.getStrokeColor(), null);
            gpStyle.fillalpha = StyleUtilities.getDouble(psw.getFillOpacity(), gpStyle.fillalpha);
            gpStyle.fillcolor = StyleUtilities.getString(psw.getFillColor(), null);
        } else if (geometrySymbolizersWrapper instanceof PolygonSymbolizerWrapper) {
            PolygonSymbolizerWrapper psw = (PolygonSymbolizerWrapper)geometrySymbolizersWrapper;
            gpStyle.width = StyleUtilities.getDouble(psw.getStrokeWidth(), gpStyle.width);
            gpStyle.strokealpha = StyleUtilities.getDouble(psw.getStrokeOpacity(), gpStyle.strokealpha);
            gpStyle.strokecolor = StyleUtilities.getString(psw.getStrokeColor(), null);
            gpStyle.fillalpha = StyleUtilities.getDouble(psw.getFillOpacity(), gpStyle.fillalpha);
            gpStyle.fillcolor = StyleUtilities.getString(psw.getFillColor(), null);
        } else if (geometrySymbolizersWrapper instanceof LineSymbolizerWrapper) {
            LineSymbolizerWrapper lsw = (LineSymbolizerWrapper)geometrySymbolizersWrapper;
            gpStyle.width = StyleUtilities.getDouble(lsw.getStrokeWidth(), gpStyle.width);
            gpStyle.strokealpha = StyleUtilities.getDouble(lsw.getStrokeOpacity(), gpStyle.strokealpha);
            gpStyle.strokecolor = StyleUtilities.getString(lsw.getStrokeColor(), null);
        }
    }

    private static BasicStyle createBaseStyle(List<RuleWrapper> rulesWrapperListForTextSymbolizer) throws Exception {
        String fieldLabel = "";
        TextSymbolizerWrapper textSymbolizersWrapper = null;
        if (rulesWrapperListForTextSymbolizer != null) {
            for (RuleWrapper ruleWrapper : rulesWrapperListForTextSymbolizer) {
                textSymbolizersWrapper = ruleWrapper.getTextSymbolizersWrapper();
                if (textSymbolizersWrapper == null) continue;
                fieldLabel = textSymbolizersWrapper.getLabelName();
                break;
            }
        }
        BasicStyle gpStyle = new BasicStyle();
        if (fieldLabel.trim().length() > 0) {
            gpStyle.labelfield = fieldLabel;
            gpStyle.labelvisible = 1;
        }
        if (fieldLabel != null && fieldLabel.trim().length() > 0 && textSymbolizersWrapper != null) {
            String fontSize = textSymbolizersWrapper.getFontSize();
            try {
                double fontSizeDouble = Double.parseDouble(fontSize);
                gpStyle.labelsize = (float)fontSizeDouble;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return gpStyle;
    }

    private static double getDouble(String value, double defaultValue) {
        double num = defaultValue;
        try {
            num = Double.parseDouble(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num;
    }

    private static String getString(String value, String defaultValue) {
        if (value == null || value.trim().length() == 0) {
            value = defaultValue;
        }
        return value;
    }

    static {
        markNamesToDef.put(wkMarkNames[0], wkMarkDefs[0]);
        markNamesToDef.put(wkMarkNames[1], wkMarkDefs[1]);
        markNamesToDef.put(wkMarkNames[2], wkMarkDefs[2]);
        markNamesToDef.put(wkMarkNames[3], wkMarkDefs[3]);
        markNamesToDef.put(wkMarkNames[4], wkMarkDefs[4]);
        markNamesToDef.put(wkMarkNames[5], wkMarkDefs[5]);
        markNamesToDef.put(wkMarkNames[6], wkMarkDefs[6]);
        markNamesToDef.put(wkMarkNames[7], wkMarkDefs[7]);
        markNamesToDef.put(wkMarkNames[8], wkMarkDefs[8]);
        markNamesToDef.put(shapeMarkNames[1], shapeMarkDefs[1]);
        markNamesToDef.put(shapeMarkNames[2], shapeMarkDefs[2]);
        markNamesToDef.put(shapeMarkNames[3], shapeMarkDefs[3]);
        markNamesToDef.put(shapeMarkNames[4], shapeMarkDefs[4]);
        markNamesToDef.put(shapeMarkNames[5], shapeMarkDefs[5]);
        markNamesToDef.put(shapeMarkNames[6], shapeMarkDefs[6]);
        markNamesToDef.put(shapeMarkNames[7], shapeMarkDefs[7]);
        lineCapNames = new String[]{"", "butt", "round", "square"};
        verticalPlacementNames = new String[]{"bevel", "miter", "round"};
        lineJoinNames = new String[]{"", "bevel", "miter", "round"};
        lineEndStyles = new HashMap();
        lineEndStyles.put("arrow - open", "shape://oarrow");
        lineEndStyles.put("arrow - closed", "shape://carrow");
        lineEndStyles.put("circle", "circle");
        lineEndStyles.put("square", "square");
        sf = CommonFactoryFinder.getStyleFactory((Hints)GeoTools.getDefaultHints());
        ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        sb = new StyleBuilder(sf, ff);
    }
}

