/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.style;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Graphic;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.hortonmachine.gears.utils.style.LineSymbolizerWrapper;
import org.hortonmachine.gears.utils.style.PointSymbolizerWrapper;
import org.hortonmachine.gears.utils.style.PolygonSymbolizerWrapper;
import org.hortonmachine.gears.utils.style.RasterSymbolizerWrapper;
import org.hortonmachine.gears.utils.style.RuleWrapper;
import org.hortonmachine.gears.utils.style.StyleUtilities;
import org.hortonmachine.gears.utils.style.TextSymbolizerWrapper;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;

public abstract class SymbolizerWrapper {
    private Symbolizer symbolizer;
    protected ExternalGraphic externalGraphic;
    protected ExternalGraphic strokeExternalGraphicStroke;
    protected ExternalGraphic strokeExternalGraphicFill;
    protected ExternalGraphic fillExternalGraphicStroke;
    protected ExternalGraphic fillExternalGraphicFill;
    protected String xOffset;
    protected String yOffset;
    private final RuleWrapper parent;

    protected SymbolizerWrapper(Symbolizer symbolizer, RuleWrapper parent) {
        this.symbolizer = symbolizer;
        this.parent = parent;
    }

    public RuleWrapper getParent() {
        return this.parent;
    }

    public Symbolizer getSymbolizer() {
        return this.symbolizer;
    }

    public boolean isTextSymbolizer() {
        return this.symbolizer instanceof TextSymbolizer;
    }

    public boolean isRasterSymbolizer() {
        return this.symbolizer instanceof RasterSymbolizerWrapper;
    }

    public <T> T adapt(Class<T> adaptee) {
        if (adaptee.isAssignableFrom(PointSymbolizerWrapper.class) && this instanceof PointSymbolizerWrapper) {
            return adaptee.cast(this);
        }
        if (adaptee.isAssignableFrom(LineSymbolizerWrapper.class) && this instanceof LineSymbolizerWrapper) {
            return adaptee.cast(this);
        }
        if (adaptee.isAssignableFrom(PolygonSymbolizerWrapper.class) && this instanceof PolygonSymbolizerWrapper) {
            return adaptee.cast(this);
        }
        if (adaptee.isAssignableFrom(TextSymbolizerWrapper.class) && this instanceof TextSymbolizerWrapper) {
            return adaptee.cast(this);
        }
        if (adaptee.isAssignableFrom(RasterSymbolizerWrapper.class) && this instanceof RasterSymbolizerWrapper) {
            return adaptee.cast(this);
        }
        return null;
    }

    public boolean hasExternalGraphic() {
        return this.externalGraphic != null;
    }

    public boolean hasStrokeExternalGraphicStroke() {
        return this.strokeExternalGraphicStroke != null;
    }

    public boolean hasFillExternalGraphicFill() {
        return this.fillExternalGraphicFill != null;
    }

    public String getExternalGraphicPath() throws MalformedURLException {
        return this.getExternalGraphicPath(this.externalGraphic);
    }

    public String getStrokeExternalGraphicStrokePath() throws MalformedURLException {
        return this.getExternalGraphicPath(this.strokeExternalGraphicStroke);
    }

    public String getFillExternalGraphicFillPath() throws MalformedURLException {
        return this.getExternalGraphicPath(this.fillExternalGraphicFill);
    }

    private String getExternalGraphicPath(ExternalGraphic extGraphic) throws MalformedURLException {
        if (extGraphic == null) {
            return "";
        }
        URL location = extGraphic.getLocation();
        String urlString = location.toExternalForm();
        if (urlString.startsWith("http://")) {
            return urlString;
        }
        if (urlString.startsWith("file:")) {
            return urlString.replaceFirst("file:", "");
        }
        throw new RuntimeException("Not implemented yet");
    }

    public void setExternalGraphicPath(String externalGraphicPath) throws MalformedURLException {
        if (externalGraphicPath == null) {
            PointSymbolizerWrapper pointSymbolizerWrapper = this.adapt(PointSymbolizerWrapper.class);
            if (pointSymbolizerWrapper != null) {
                Graphic graphic = pointSymbolizerWrapper.getGraphic();
                graphic.graphicalSymbols().clear();
                this.externalGraphic = null;
            }
        } else {
            PointSymbolizerWrapper pointSymbolizerWrapper = this.adapt(PointSymbolizerWrapper.class);
            if (pointSymbolizerWrapper != null) {
                Graphic graphic = pointSymbolizerWrapper.getGraphic();
                graphic.graphicalSymbols().clear();
                Object urlStr = externalGraphicPath;
                if (!externalGraphicPath.startsWith("http:") && !externalGraphicPath.startsWith("file:")) {
                    urlStr = "file:" + externalGraphicPath;
                } else if (externalGraphicPath.startsWith("./")) {
                    urlStr = "file:" + externalGraphicPath;
                }
                this.externalGraphic = StyleUtilities.sb.createExternalGraphic(new URL((String)urlStr), StyleUtilities.getFormat(externalGraphicPath));
                graphic.graphicalSymbols().add(this.externalGraphic);
            }
            this.setExternalGraphicPath(externalGraphicPath, this.externalGraphic);
        }
    }

    public void setStrokeExternalGraphicStrokePath(String externalGraphicPath) throws MalformedURLException {
        if (this.strokeExternalGraphicStroke == null) {
            Graphic graphic = null;
            LineSymbolizerWrapper lineSymbolizerWrapper = this.adapt(LineSymbolizerWrapper.class);
            PolygonSymbolizerWrapper polygonSymbolizerWrapper = this.adapt(PolygonSymbolizerWrapper.class);
            if (lineSymbolizerWrapper != null) {
                graphic = lineSymbolizerWrapper.getStrokeGraphicStroke();
                if (graphic == null) {
                    graphic = StyleUtilities.sb.createGraphic();
                    lineSymbolizerWrapper.setStrokeGraphicStroke(graphic);
                }
            } else if (polygonSymbolizerWrapper != null) {
                graphic = polygonSymbolizerWrapper.getStrokeGraphicStroke();
                if (graphic == null) {
                    graphic = StyleUtilities.sb.createGraphic();
                    polygonSymbolizerWrapper.setStrokeGraphicStroke(graphic);
                }
            } else {
                return;
            }
            graphic.graphicalSymbols().clear();
            Object urlStr = externalGraphicPath;
            if (!externalGraphicPath.startsWith("http:") && !externalGraphicPath.startsWith("file:")) {
                urlStr = "file:" + externalGraphicPath;
            }
            this.strokeExternalGraphicStroke = StyleUtilities.sb.createExternalGraphic(new URL((String)urlStr), StyleUtilities.getFormat(externalGraphicPath));
            graphic.graphicalSymbols().add(this.strokeExternalGraphicStroke);
        } else {
            this.setExternalGraphicPath(externalGraphicPath, this.strokeExternalGraphicStroke);
        }
    }

    public void setFillExternalGraphicFillPath(String externalGraphicPath, double size) throws MalformedURLException {
        Graphic graphic = null;
        PolygonSymbolizerWrapper polygonSymbolizerWrapper = this.adapt(PolygonSymbolizerWrapper.class);
        if (polygonSymbolizerWrapper != null) {
            graphic = polygonSymbolizerWrapper.getFillGraphicFill();
            if (graphic == null) {
                graphic = StyleUtilities.sf.createDefaultGraphic();
            }
        } else {
            return;
        }
        polygonSymbolizerWrapper.setFillGraphicFill(graphic);
        graphic.graphicalSymbols().clear();
        Object urlStr = externalGraphicPath;
        if (!externalGraphicPath.startsWith("http:") && !externalGraphicPath.startsWith("file:")) {
            urlStr = "file:" + externalGraphicPath;
        }
        if (this.fillExternalGraphicFill == null) {
            this.fillExternalGraphicFill = StyleUtilities.sb.createExternalGraphic(new URL((String)urlStr), StyleUtilities.getFormat(externalGraphicPath));
        } else {
            this.setExternalGraphicPath(externalGraphicPath, this.fillExternalGraphicFill);
        }
        graphic.graphicalSymbols().add(this.fillExternalGraphicFill);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
        graphic.setSize((Expression)ff.literal(size));
    }

    private void setExternalGraphicPath(String externalGraphicPath, ExternalGraphic extGraphic) throws MalformedURLException {
        URL url = null;
        File f = new File(externalGraphicPath);
        String format = StyleUtilities.getFormat(externalGraphicPath);
        if (!f.exists()) {
            if (externalGraphicPath.startsWith("http://") || externalGraphicPath.startsWith("file:")) {
                url = new URL(externalGraphicPath);
            } else if (externalGraphicPath.startsWith("./")) {
                url = new URL("file:" + externalGraphicPath);
            }
        }
        if (url == null) {
            url = f.toURI().toURL();
            if (externalGraphicPath.equals("")) {
                url = new URL("file:");
            }
        }
        extGraphic.setLocation(url);
        extGraphic.setFormat(format);
    }

    protected String expressionToString(Expression expression) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof PropertyName) {
            PropertyName pName = (PropertyName)expression;
            return pName.getPropertyName();
        }
        if (expression instanceof LiteralExpressionImpl) {
            LiteralExpressionImpl pName = (LiteralExpressionImpl)expression;
            return pName.getValue().toString();
        }
        Integer evaluateInt = (Integer)expression.evaluate(null, Integer.class);
        if (evaluateInt != null) {
            return evaluateInt.toString();
        }
        Double evaluateDouble = (Double)expression.evaluate(null, Double.class);
        if (evaluateDouble != null) {
            return evaluateDouble.toString();
        }
        String evaluateString = (String)expression.evaluate(null, String.class);
        if (evaluateString != null) {
            return evaluateString;
        }
        return null;
    }

    public void setOffset(String xOffset, String yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        StyleUtilities.setOffset(this.symbolizer, xOffset + "," + yOffset);
    }

    public void setOffset(String offset) {
        if (offset.indexOf(44) == -1) {
            return;
        }
        String[] split = offset.split(",");
        if (split.length != 2) {
            return;
        }
        this.xOffset = split[0];
        this.yOffset = split[1];
        this.setOffset(this.xOffset, this.yOffset);
    }

    public String getxOffset() {
        return this.xOffset;
    }

    public String getyOffset() {
        return this.yOffset;
    }

    public String toString() {
        String simpleName = this.symbolizer.getClass().getSimpleName();
        simpleName = simpleName.replaceFirst("SymbolizerImpl", " Symbolizer");
        return simpleName;
    }
}

