/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.style.sld;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.geotools.util.logging.Logging;
import org.hortonmachine.gears.utils.style.sld.EntityResolverToLSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class ResponseUtils {
    static Logger LOGGER = Logging.getLogger(ResponseUtils.class);

    public static List validate(InputSource xml, URL schemaURL, boolean skipTargetNamespaceException) {
        return ResponseUtils.validate(xml, schemaURL, skipTargetNamespaceException, null);
    }

    public static List validate(InputSource xml, URL schemaURL, boolean skipTargetNamespaceException, EntityResolver entityResolver) {
        StreamSource source = null;
        if (xml.getCharacterStream() != null) {
            source = new StreamSource(xml.getCharacterStream());
        } else if (xml.getByteStream() != null) {
            source = new StreamSource(xml.getByteStream());
        } else {
            throw new IllegalArgumentException("Could not turn input source to stream source");
        }
        return ResponseUtils.validate(source, schemaURL, skipTargetNamespaceException, entityResolver);
    }

    public static List validate(Source xml, URL schemaURL, boolean skipTargetNamespaceException) {
        return ResponseUtils.validate(xml, schemaURL, skipTargetNamespaceException, null);
    }

    public static List validate(Source xml, URL schemaURL, boolean skipTargetNamespaceException, EntityResolver entityResolver) {
        try {
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaURL);
            Validator v = schema.newValidator();
            if (entityResolver != null) {
                v.setResourceResolver(new EntityResolverToLSResourceResolver(v.getResourceResolver(), entityResolver));
            }
            Handler handler = new Handler(skipTargetNamespaceException, entityResolver);
            v.setErrorHandler(handler);
            v.validate(xml);
            return handler.errors;
        }
        catch (SAXException e) {
            return ResponseUtils.exception(e);
        }
        catch (IOException e) {
            return ResponseUtils.exception(e);
        }
    }

    static List exception(Exception e) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Validation error", e);
        }
        return Arrays.asList(new SAXParseException(e.getLocalizedMessage(), null));
    }

    private static class Handler
    extends DefaultHandler {
        public ArrayList errors = new ArrayList();
        boolean skipTargetNamespaceException;
        EntityResolver entityResolver;

        Handler(boolean skipTargetNamespaceExeption, EntityResolver entityResolver) {
            this.skipTargetNamespaceException = skipTargetNamespaceExeption;
            this.entityResolver = entityResolver;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            if (this.skipTargetNamespaceException && exception.getMessage().startsWith("TargetNamespace.2: Expecting no namespace, but the schema document has a target name")) {
                return;
            }
            this.errors.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            if (this.entityResolver != null) {
                return this.entityResolver.resolveEntity(publicId, systemId);
            }
            return super.resolveEntity(publicId, systemId);
        }
    }
}

