/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.gears.utils.time;

import org.hortonmachine.gears.libs.modules.HMConstants;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;

public class UtcTimeUtilities {
    private static DateTimeFormatter withMinutesformatter = HMConstants.utcDateFormatterYYYYMMDDHHMM;
    private static DateTimeFormatter withSecondsformatter = HMConstants.utcDateFormatterYYYYMMDDHHMMSS;

    public static DateTime newDateTime() {
        DateTime dt = new DateTime().withZone(DateTimeZone.UTC);
        return dt;
    }

    public static DateTime fromStringWithSeconds(String dateTimeString) {
        DateTime dt = withSecondsformatter.parseDateTime(dateTimeString);
        return dt;
    }

    public static DateTime fromStringWithMinutes(String dateTimeString) {
        DateTime dt = withMinutesformatter.parseDateTime(dateTimeString);
        return dt;
    }

    public static String toStringWithSeconds(DateTime dateTime) {
        String dtStr = dateTime.toString(withSecondsformatter);
        return dtStr;
    }

    public static String toStringWithMinutes(DateTime dateTime) {
        String dtStr = dateTime.toString(withMinutesformatter);
        return dtStr;
    }

    public static String quickToString(long unixEpoch) {
        return new DateTime(unixEpoch).toString(withSecondsformatter);
    }

    public static String quickToStringLocal(long unixEpoch) {
        return new DateTime(unixEpoch).toString(HMConstants.dateTimeFormatterYYYYMMDDHHMMSS);
    }
}

