/*
 * This file is part of HortonMachine (http://www.hortonmachine.org)
 * (C) HydroloGIS - www.hydrologis.com 
 * 
 * The HortonMachine is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.hortonmachine.modules;
import java.io.File;

import org.hortonmachine.gears.libs.modules.HMConstants;
import org.hortonmachine.modules.docker.PdalDockerModel;
import org.json.JSONArray;
import org.json.JSONObject;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;

@Description("Pdal converter LAS->glTF command.")
@Author(name = "Antonello Andrea", contact = "http://www.hydrologis.com")
@Keywords("pdal, docker")
@Label(HMConstants.PDAL)
@Name("_pdalconverterlas2gltf")
@Status(40)
@License("General Public License Version 3 (GPLv3)")
public class PdalConverterLas2Gltf extends PdalDockerModel {
    @Description("The las file to convert.")
    @UI(HMConstants.FILEIN_UI_HINT_GENERIC)
    @In
    public String inPath = null;

//    @Description("Print metadata.")
//    @In
//    public boolean doMetadata = true;
//
//    @Description("Print schema.")
//    @In
//    public boolean doSchema = false;
//
//    @Description("Print statistics on all points (reads the dataset).")
//    @In
//    public boolean doStats = false;
//
//    @Description("A range of points information to print out.")
//    @In
//    public String pPointsRange = "1-3";

    @Description("The output file name.")
    @In
    public String outName = null;

    @Execute
    public void process() throws Exception {
        checkFileExists(inPath);
        String error = checkDockerInstall();
        if (error == null) {
            try {
                File file = new File(inPath);
                String inName = file.getName();
                File workspaceFile = file.getParentFile();
                String workspace = workspaceFile.getAbsolutePath();

                // [
                // "infile.las",
                // {
                // "type": "filters.poisson",
                // "depth": 12
                // },
                // {
                // "type":"writers.gltf",
                // "filename":"output.glb",
                // "red": 0.8,
                // "metallic": 0.5
                // }
                // ]

//                JSONObject root = new JSONObject();
                JSONArray pipelineArray = new JSONArray();
//                root.put("pipeline", pipelineArray);

//                JSONObject input = new JSONObject(inName);
//                pipelineArray.put(input);

                JSONObject filter = new JSONObject();
                filter.put("type", "filters.poisson");
//                filter.put("depth", 12);
                pipelineArray.put(filter);

                JSONObject writer = new JSONObject();
                writer.put("type", "writers.gltf");
                writer.put("filename", outName);
                writer.put("red", 0.8);
                writer.put("metallic", 0.5);
                pipelineArray.put(writer);

                String pipelineJson = pipelineArray.toString(2);
                pipelineJson= pipelineJson.replaceFirst("\\[", "[\n\"" + inName + "\",");

                pm.message("Running pipeline with filter:");
                pm.message(pipelineJson);
                File pipelineFile = getPipelineFile(workspaceFile, pipelineJson);

                String cmd = "pdal pipeline " + pipelineFile.getName();

                startContainer(workspace);
                pm.beginTask("Running command...", -1);
                execCommand(cmd);
                pm.done();

                pipelineFile.delete();
//                JSONObject root = new JSONObject();
//                JSONArray pipelineArray = new JSONArray();
//                root.put("pipeline", pipelineArray);
//                
//                JSONObject reader = new JSONObject();
//                reader.put("type", "readers.las");
//                reader.put("filename", inName);
//                pipelineArray.put(reader);
//                
//                JSONObject filter = new JSONObject();
//                filter.put("type", "filters.poisson");
//                filter.put("depth", 12);
//                pipelineArray.put(filter);
//                
//                JSONObject writer = new JSONObject();
//                writer.put("type", "writers.gltf");
//                writer.put("filename", outName);
//                writer.put("red", 0.8);
//                writer.put("metallic", 0.5);
//                pipelineArray.put(writer);
//                
//                String pipelineJson = root.toString(2);
//                
//                pm.message("Running pipeline with filter:");
//                pm.message(pipelineJson);
//                File pipelineFile = getPipelineFile(workspaceFile, pipelineJson);
//                
//                String cmd = "pdal pipeline " + pipelineFile.getName();
//                
//                startContainer(workspace);
//                pm.beginTask("Running command...", -1);
//                execCommand(cmd);
//                pm.done();
//                
//                pipelineFile.delete();
            } finally {
                closeClient();
            }
        } else {
            pm.errorMessage(error);
        }
    }

    public static void main( String[] args ) throws Exception {
        PdalConverterLas2Gltf i = new PdalConverterLas2Gltf();
        i.inPath = "/Users/hydrologis/lavori_tmp/R3GIS_TESTS/LAS/erdbau_las.laz";
        i.outName = "erdbau.glb";
        i.process();
    }
}
