/*
 * Decompiled with CFR 0.152.
 */
package org.hortonmachine.modules;

import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.hortonmachine.hmachine.modules.geomorphology.ab.OmsAb;

@Description(value="Calculates the draining area per length unit.")
@Author(name="Andrea Antonello, Erica Ghesla, Rigon Riccardo, Andrea Cozzini, Silvano Pisoni", contact="http://www.hydrologis.com, http://www.ing.unitn.it/dica/hp/?user=rigon")
@Keywords(value="Geomorphology, OmsTca, OmsCurvatures, OmsDrainDir, OmsFlowDirections")
@Label(value="HortonMachine/Geomorphology")
@Name(value="_ab")
@Status(value=40)
@License(value="General Public License Version 3 (GPLv3)")
public class Ab
extends OmsAb {
    @Description(value="The map of the total contributing area.")
    @UI(value="infile_raster")
    @In
    public String inTca = null;
    @Description(value="The map of the planar curvatures.")
    @UI(value="infile_raster")
    @In
    public String inPlan = null;
    @Description(value="The map of area per length.")
    @UI(value="outfile")
    @In
    public String outAb = null;
    @Description(value="The map of contour line.")
    @UI(value="outfile")
    @In
    public String outB = null;

    @Execute
    public void process() throws Exception {
        OmsAb ab = new OmsAb();
        ab.inTca = this.getRaster(this.inTca);
        ab.inPlan = this.getRaster(this.inPlan);
        ab.pm = this.pm;
        ab.process();
        this.dumpRaster(ab.outAb, this.outAb);
        this.dumpRaster(ab.outB, this.outB);
    }
}

